/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.utils;

import com.aimluck.eip.cayenne.om.social.Activity;
import com.aimluck.eip.cayenne.om.social.AppData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.social.impl.ALDefaultSocialApplicationHanlder;

/**
 * ソーシャルアプリクラスALDefaultSocialApplicationHanlderのコピークラスです。<br>
 * deleteUserDataを変更しています。<br>
 * deleteUserDataのコミット、ロールバック処理をコメントアウト<br>
 */
public class ALBatchDefaultSocialApplicationHanlderUtils {

  /**
   * コミット、ロールバック処理をコメントアウト<br>
   * 
   * @param String
   *          ログインユーザー名
   * @throws Exception
   * @see {@link ALDefaultSocialApplicationHanlder#deleteUserData(String...)}
   */

  public static void deleteUserData(String... loginNameList) {
    try {
      for (String loginName : loginNameList) {
        String sql1 =
          "delete from app_data where login_name = #bind($loginName)";
        Database
          .sql(AppData.class, sql1)
          .param("loginName", loginName)
          .execute();

        String sql2 =
          "delete from activity where login_name = #bind($loginName)";
        Database
          .sql(Activity.class, sql2)
          .param("loginName", loginName)
          .execute();

        String sql3 =
          "delete from activity_map where login_name = #bind($loginName)";
        Database
          .sql(Activity.class, sql3)
          .param("loginName", loginName)
          .execute();
      }
      // Database.commit();
    } catch (Throwable t) {
      // Database.rollback();
      throw new RuntimeException(t);
    }
  }

}
