package aipo.webservice.mail;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.lang.reflect.Constructor;
import java.util.Properties;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import aipo.webservice.util.WsUtils;

import com.aimluck.eip.mail.ALMailReceiverContext;

/**
 * <HR>
 * リマインダー用メール受信機能ファクトリ
 * <p>
 * 
 * POP3メール受信機能のクラス名を取得し、設定に従ったリマインダー用POP3メール受信機能のインスタンスを生成する。
 * <P>
 * <HR>
 * <P>
 * 
 */
public class ReminderMailReceiverFactory {

  /** ロガー */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ReminderMailReceiverFactory.class
      .getName());

  /** POP3メール受信クラス */
  private static final String PROPERTY_POP3_MAIL_RECEIVER =
    "pop3.mail.receiver";

  /** プロパティファイル */
  private static final String PROPERTY_FILE =
    "WEB-INF/conf/WebService.properties";

  /**
   * リマインダー用メール受信機能ファクトリ
   * <p>
   * Webアプリケーション設定に従ったリマインダー用POP3メール受信機能のインスタンスを生成します。<br>
   * 
   * @param rcontext
   *          メール受信用コンテキスト
   * @return ReminderPop3MailReceiver リマインダー用POP3メール受信機能インスタンス
   */
  public static ReminderPop3MailReceiver createReminderPop3MailReceiver(
      ALMailReceiverContext rcontext) {
    Properties webServiceProperties = WsUtils.getProperties(PROPERTY_FILE);
    String className =
      (String) webServiceProperties.get(PROPERTY_POP3_MAIL_RECEIVER);
    ReminderPop3MailReceiver mr = null;
    try {
      Constructor<?> ct =
        Class.forName(className).getConstructor(ALMailReceiverContext.class);
      mr = (ReminderPop3MailReceiver) ct.newInstance(rcontext);
    } catch (Exception e) {
      logger.error("リマインダー用メール受信機能インスタンスの生成で予期せぬエラーが発生しました。", e);
    }
    return mr;
  }

}
