package aipo.webservice.soap.axis2.bean;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * <HR>
 * スケジュール表示情報格納用Bean
 * <p>
 * 
 * リマインダーに表示するスケジュール表示情報の格納用Beanクラス
 * <P>
 * <HR>
 * <P>
 * 
 */
public class ScheduleViewBean {

  /** スケジュールID */
  private int scheduleId;

  /** 開始日付 */
  private String date;

  /** 終了日付 */
  private String endDate;

  /** 開始時刻 */
  private String startTime;

  /** 終了時刻 */
  private String endTime;

  /** 予定名 */
  private String name;

  /** 場所 */
  private String place;

  /**
   * スケジュールIDを取得します。
   * 
   * @return スケジュールID
   */
  public int getScheduleId() {
    return scheduleId;
  }

  /**
   * 日付を設定します。
   * 
   * @param scheduleId
   *          セットする スケジュールID
   */
  public void setScheduleId(int scheduleId) {
    this.scheduleId = scheduleId;
  }

  /**
   * 日付を取得します。
   * 
   * @return 日付
   */
  public String getDate() {
    return date;
  }

  /**
   * 日付を設定します。
   * 
   * @param date
   *          セットする日付
   */
  public void setDate(String date) {
    this.date = date;
  }

  /**
   * 終了日付を取得します。
   * 
   * @return endDate
   */
  public String getEndDate() {
    return endDate;
  }

  /**
   * 終了日付を設定します。
   * 
   * @param endDate
   *          セットする 終了日付
   */
  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  /**
   * 開始時刻を取得します。
   * 
   * @return 開始時刻
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * 開始時刻を設定します。
   * 
   * @param startTime
   *          セットする開始時刻
   */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  /**
   * 終了時刻を取得します。
   * 
   * @return 終了時刻
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * 終了時刻を設定します。
   * 
   * @param endTime
   *          セットする終了時刻
   */
  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  /**
   * 予定名を取得します。
   * 
   * @return name
   */
  public String getName() {
    return name;
  }

  /**
   * 予定名を設定します。
   * 
   * @param name
   *          セットする予定名
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 場所を取得します。
   * 
   * @return 場所
   */
  public String getPlace() {
    return place;
  }

  /**
   * 場所を設定します。
   * 
   * @param place
   *          セットする場所
   */
  public void setPlace(String place) {
    this.place = place;
  }
}
