package aipo.webservice.soap.axis2.bean;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * <HR>
 * Webサービスのインポート処理の戻り値を格納するクラス
 * <p>
 * 
 * Webサービスのインポート処理の戻り値を格納するクラス。<br>
 * 実行結果、登録件数、エラーデータを保持する。<br>
 * <P>
 * <HR>
 * <P>
 * 
 */
public class WebServiceResultBean {

  /** 実行結果 */
  private boolean result;

  /** 登録件数 */
  private int count;

  /** スキップデータ */
  private String skipData;

  /** エラーメッセージ */
  private String errMsg;

  /**
   * 実行結果を取得します。
   * 
   * @return result
   */
  public boolean isResult() {
    return result;
  }

  /**
   * 実行結果を設定します。
   * 
   * @param result
   *          セットする 実行結果
   */
  public void setResult(boolean result) {
    this.result = result;
  }

  /**
   * 登録件数を取得します。
   * 
   * @return count
   */
  public int getCount() {
    return count;
  }

  /**
   * 登録件数を設定します。
   * 
   * @param count
   *          セットする 登録件数
   */
  public void setCount(int count) {
    this.count = count;
  }

  /**
   * スキップデータを取得します。
   * 
   * @return errData
   */
  public String getSkipData() {
    return skipData;
  }

  /**
   * スキップデータを設定します。
   * 
   * @param errData
   *          セットする スキップデータ
   */
  public void setSkipData(String skipData) {
    this.skipData = skipData;
  }

  /**
   * エラーメッセージを取得します。
   * 
   * @return errMsg
   */
  public String getErrMsg() {
    return errMsg;
  }

  /**
   * エラーメッセージを設定します。
   * 
   * @param errMsg
   *          セットする errMsg
   */
  public void setErrMsg(String errMsg) {
    this.errMsg = errMsg;
  }

}
