/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.tel.activity;

import java.util.ArrayList;
import java.util.List;

import com.ksk.contacts.R;
import com.ksk.contacts.tel.util.FlickUtil;
import com.ksk.contacts.tel.util.MemberListAdapter;
import com.ksk.contacts.tel.util.PriorityNumberDB;
import com.ksk.contacts.tel.util.PriorityNumberDB.PriorityNumber;
import com.ksk.contacts.util.CommonData;
import com.ksk.contacts.util.CommonData.MemberInfo;
import com.ksk.contacts.util.ContactMgr;
import com.ksk.contacts.util.ContactMgr.ContactInfo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager.LayoutParams;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.EditText;
import android.widget.ListView;

public class contacts extends Activity implements OnItemLongClickListener {

	//共通データクラス
	private CommonData mCommonData = new CommonData();

	//リストビュー
	private ListView mListView;
	private MemberListAdapter mMemberListAdapter;

	//Adapter用メンバーリスト情報
	private List<MemberInfo> mMemberList = new ArrayList<MemberInfo>();

	private long mRawContactID = -1;

	/* (非 Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //アプリ起動時のソフトキーが自動で表示されないようにする
        this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

        setContentView(R.layout.memberlist);

        //検索Viewの取得、及び設定
        EditText SerchEdit = (EditText) findViewById(R.id.edit);
        SerchEdit.addTextChangedListener(xTextListener);

        //メンバーリストアダプターの生成
        mMemberListAdapter = new MemberListAdapter(this, R.layout.memberlist_row);

        //表示設定(名前ソート)
        dispNameSort(mMemberList);

        //情報をアダプターに設定
        mMemberListAdapter.setDataList(mMemberList);
        mListView = (ListView) findViewById(R.id.list);
        mListView.setAdapter(mMemberListAdapter);

        //アイテム選択時のイベントハンドラの登録
        mListView.setOnItemLongClickListener(this);

        //フリックの実装
        new FlickUtil(this, mListView, null);
    }

	@Override
	public boolean onItemLongClick(AdapterView<?> adapterview, View view, int i, long l) {

		//選択位置のContactIDを取得
		long rawcontact_id = mMemberList.get(i).rawcontact_id;

		//取得したContactIDを元に詳細画面Activityに対して起動要求を行う。
		Intent intent = new Intent(this, contactinfo.class);
		intent.putExtra("RawContactID", rawcontact_id);
		startActivity(intent);

		mRawContactID = rawcontact_id;

		return false;
	}

    private TextWatcher xTextListener = new TextWatcher() {
		@Override
		public void afterTextChanged(Editable arg0) {

			//Adapter用メンバーリスト情報(検索用)
			List<MemberInfo> list = new ArrayList<MemberInfo>();

			//Serch用EditViewが空欄以外は以下を実施する。
			if( (arg0 != null) && (!arg0.equals("")) ){

				//入力キーが名前・フリカナ・電話番号・Emailのいずれかに含まれているかチェック。
				//含まれていない場合は、検索用リストから削除する。
				int num = mMemberList.size();
				for(int i=0; i<num; i++){
					if(mMemberList.get(i).toString().indexOf(arg0.toString()) != -1){
						list.add(mMemberList.get(i));
					}
				}

				//Adapterにリストを設定し、表示更新要求を行う
				mMemberListAdapter.setDataList(list);
				mMemberListAdapter.notifyDataSetChanged();

			}else{
				//空欄の場合は、全電話帳リストを表示する。

				//Adapterにリストを設定し、表示更新要求を行う
				mMemberListAdapter.setDataList(mMemberList);
				mMemberListAdapter.notifyDataSetChanged();
			}
		}

		@Override
		public void beforeTextChanged(CharSequence s, int start, int count,
				int after) {
			// TODO 自動生成されたメソッド・スタブ

		}

		@Override
		public void onTextChanged(CharSequence s, int start, int before,
				int count) {
			// TODO 自動生成されたメソッド・スタブ

		}
    };

    private void dispNameSort(List<MemberInfo> list){

        //電話帳登録メンバーリストを取得
        ContactMgr mContactMgr = new ContactMgr(this);
        List<ContactInfo> ContactList = mContactMgr.getContactList();

		//優先番号情報を取得
		PriorityNumberDB PN_DB = new PriorityNumberDB(this);

        //電話帳登録メンバー数分だけ処理を繰り返す
        String index_old = "";
        for(int i=0; i<ContactList.size(); i++){

        	//電話帳登録メンバーリストよりメンバーを取得
        	ContactInfo contact = ContactList.get(i);

        	//TODO
        	//索引用のIndex行を設定する。
        	String index = mContactMgr.getNameIndex(contact.name.yomi);
        	if( !index_old.equals(index) ){
        		MemberInfo data    = mCommonData.new MemberInfo();
        		data.tag = mContactMgr.getNameIndex(contact.name.yomi);
        		list.add(data);
        		index_old = index;
        	}

        	//優先番号初期設定
        	String phone = "";
        	String mail = "";
        	if(contact.phone.size() != 0){
        		phone = contact.phone.get(0).number;
        	}
        	if(contact.email.size() != 0){
        		mail = contact.email.get(0).number;
        	}
        	PN_DB.checkPriorityNumber(contact.rawcontact_id, phone, mail);

        	//メンバー情報をアダプターに設定
        	MemberInfo data    = mCommonData.new MemberInfo();
            //ContactIDの設定
            data.rawcontact_id  = contact.rawcontact_id;
            //ユーザー画像IDの設定
            data.photo       = contact.photo;
            //ユーザー名の設定
            data.name        = contact.name.dispname;

            //音声発信ボタンの設定
    		PriorityNumber pn_info = PN_DB.getPriorityNumber(contact.rawcontact_id);
            if((pn_info != null) && (pn_info.phone != null) && (!pn_info.phone.equals(""))){
            	//電話番号が存在する場合は、音声発信データを設定
            	data.tel         = pn_info.phone;
            }
            //Emailボタンの設定
            if((pn_info != null) && (pn_info.mail != null) && (!pn_info.mail.equals(""))){
            	//Emailが存在する場合は、Emailデータを設定
            	data.email        = pn_info.mail;
            }

            //ContactInfoの設定
            data.info = contact;

            list.add(data);
        }
    }

    /* (非 Javadoc)
	 * @see android.app.Activity#onDestroy()
	 */
	@Override
	protected void onDestroy() {
		// TODO 自動生成されたメソッド・スタブ
		super.onDestroy();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onPause()
	 */
	@Override
	protected void onPause() {
		// TODO 自動生成されたメソッド・スタブ
		super.onPause();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onRestart()
	 */
	@Override
	protected void onRestart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onRestart();

		for(int i=0; i<mMemberList.size(); i++){
			if((mMemberList.get(i).rawcontact_id != null) && (mRawContactID == mMemberList.get(i).rawcontact_id)){

				PriorityNumberDB PN_DB = new PriorityNumberDB(this);

	            //音声発信ボタンの設定
	    		PriorityNumber pn_info = PN_DB.getPriorityNumber(mMemberList.get(i).rawcontact_id);
	            if((pn_info != null) && (pn_info.phone != null) && (!pn_info.phone.equals(""))){
	            	//電話番号が存在する場合は、音声発信データを設定
	            	mMemberList.get(i).tel = pn_info.phone;
	            }else{
	            	mMemberList.get(i).tel = "";
	            }
	            //Emailボタンの設定
	            if((pn_info != null) && (pn_info.mail != null) && (!pn_info.mail.equals(""))){
	            	//Emailが存在する場合は、Emailデータを設定
	            	mMemberList.get(i).email = pn_info.mail;
	            }else{
	            	mMemberList.get(i).email = "";
	            }

	            mMemberListAdapter.notifyDataSetChanged();
	            break;
			}
		}

		mRawContactID = -1;
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onResume()
	 */
	@Override
	protected void onResume() {
		// TODO 自動生成されたメソッド・スタブ
		super.onResume();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStart()
	 */
	@Override
	protected void onStart() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStart();
	}

	/* (非 Javadoc)
	 * @see android.app.Activity#onStop()
	 */
	@Override
	protected void onStop() {
		// TODO 自動生成されたメソッド・スタブ
		super.onStop();
	}
}
