/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ksk.contacts.widget;

import java.util.List;

import android.app.PendingIntent;
import android.app.Service;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.net.Uri;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.RemoteViews;
import com.ksk.contacts.R;
import com.ksk.contacts.tel.activity.telgroup;
import com.ksk.contacts.util.CallLogMgr;
import com.ksk.contacts.util.CallLogMgr.CallLogData;
import com.ksk.contacts.util.CommonData;

public class WidgetService extends Service {

	private CommonData mData = new CommonData();

	private SharedPreferences mPref = null;

	private RemoteViews[]       mRemoteViews = {null, null};

	private ComponentName[]     mComponentName = {null, null};

	private AppWidgetManager[]  mAppWidgetManager = {null, null};

	private CallLogMgr        mCallLogMgr = null;

	static  final String      UPDATE_LOG_ACTION = "com.ksk.contacts.widget.WidgetService.UPDATE_LOG_ACTION";


	@Override
	public void onCreate() {
		// TODO 自動生成されたメソッド・スタブ
		super.onCreate();

		Log.d("WidgetService","onCreate");
	}


	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
		// TODO 自動生成されたメソッド・スタブ
		Log.d("WidgetService","onStartCommand");

		return super.onStartCommand(intent, flags, startId);
	}

    @Override
    public void onStart(Intent intent, int startId) {


    	int layout  = intent.getIntExtra("layout", mData.APPWIDGET_3_1);
    	int shortCutNum = 0;
    	String number = "";
    	int[] shorCutTbl = {R.id.shortcut1,
    					    R.id.shortcut2,
    					    R.id.shortcut3,
    					    R.id.shortcut4};

    	Log.d("WidgetService","onStart:layout=" + layout);

    	//レイアウトの取得
    	if(layout == mData.APPWIDGET_2_1){
    		//レイアウト(2×1)
    		mRemoteViews[layout] = new RemoteViews(getPackageName(), R.layout.widget2_1);
    		mComponentName[layout] = new ComponentName(this, ContactWidget2_1.class);

    	}else if(layout == mData.APPWIDGET_3_1){
    		//レイアウト(3×1)
    		mRemoteViews[layout] = new RemoteViews(getPackageName(), R.layout.widget3_1);
    		mComponentName[layout] = new ComponentName(this, ContactWidget3_1.class);
            shortCutNum = 4;

    	}else{
    		//上記以外
    		mRemoteViews[layout] = new RemoteViews(getPackageName(), R.layout.widget3_1);
    		mComponentName[layout] = new ComponentName(this, ContactWidget3_1.class);
            shortCutNum = 4;
    	}

        //TODO
        //電話アイコンの設定
    	//未確認の着信履歴の確認
    	mCallLogMgr = new CallLogMgr(this);
    	List<CallLogData> list = mCallLogMgr.getNewCallLogData();
    	if(list.size() == 0){
    		//未確認の着信履歴は0件の場合
    		//非表示設定
    		mRemoteViews[layout].setViewVisibility(R.id.tel_log, View.GONE);
    	}else{
    		//未確認の着信履歴は1件以上の場合
    		//件数を表示
    		mRemoteViews[layout].setViewVisibility(R.id.tel_log, View.VISIBLE);
    		mRemoteViews[layout].setTextViewText(R.id.tel_log, String.valueOf(list.size()));
    	}

    	//電話アイコン押下時のアクション設定
    	Intent clickIntent = new Intent(this, telgroup.class);
    	PendingIntent pendingIntent = PendingIntent.getActivity(this, layout, clickIntent, 0);
		mRemoteViews[layout].setOnClickPendingIntent(R.id.tel, pendingIntent);

        //TODO
    	//メールアイコンの設定
		//未確認のメールは0件の場合
		//非表示設定
		mRemoteViews[layout].setViewVisibility(R.id.mail_log, View.GONE);

		//メールアイコン押下時のアクション設定
    	clickIntent = new Intent(this, telgroup.class);
    	pendingIntent = PendingIntent.getActivity(this, layout, clickIntent, 0);
		mRemoteViews[layout].setOnClickPendingIntent(R.id.tel, pendingIntent);


    	//短縮ダイヤルの設定
		Intent pIntent;
        mPref = PreferenceManager.getDefaultSharedPreferences(this);
        for(int i=0; i<shortCutNum; i++){
        	number = mPref.getString("edittext_key" + (i + 1), "");
        	if(!number.equals("")){
        		if(number.compareTo("@") >= 0){
        			//Email送信
        			pIntent = new Intent(Intent.ACTION_SENDTO, Uri.parse("mailto:" + number));
        			mRemoteViews[layout].setTextColor(shorCutTbl[i], Color.GREEN);

        		}else{
        			//音声発信
        			pIntent = new Intent(Intent.ACTION_DIAL, Uri.parse("tel:" + number));
        			mRemoteViews[layout].setTextColor(shorCutTbl[i], Color.RED);
        		}
        		pendingIntent = PendingIntent.getActivity(this, layout, pIntent, 0);

        		mRemoteViews[layout].setOnClickPendingIntent(shorCutTbl[i], pendingIntent);
        	}
        }

        //レイアウトの更新
        mAppWidgetManager[layout] = AppWidgetManager.getInstance(this);
        mAppWidgetManager[layout].updateAppWidget(mComponentName[layout], mRemoteViews[layout]);


        //着信イベント受信用のBroadcastRecieverの登録
        //サービスが強制終了されている可能性もあるため、外部Recieverを作成する形で実装
        IntentFilter filter = new IntentFilter();
        filter.addAction(UPDATE_LOG_ACTION);
        registerReceiver(mBroadcastReceiver ,filter);
    }

	private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {
	    @Override
	    public void onReceive(Context context, Intent intent) {
	    	Log.d("WidgetService","onReceive:" + intent.getAction());

	    	if(intent.getAction().equals(UPDATE_LOG_ACTION)){
            	List<CallLogData> list = mCallLogMgr.getNewCallLogData();
            	if(list.size() == 0){
            		//未確認の着信履歴は0件の場合
            		//非表示設定
            		if(mRemoteViews[mData.APPWIDGET_2_1] != null){
            			mRemoteViews[mData.APPWIDGET_2_1].setViewVisibility(R.id.tel_log, View.GONE);
            		}
            		if(mRemoteViews[mData.APPWIDGET_3_1] != null){
            			mRemoteViews[mData.APPWIDGET_3_1].setViewVisibility(R.id.tel_log, View.GONE);
            		}
            	}else{
            		//未確認の着信履歴は1件以上の場合
            		//件数を表示
            		if(mRemoteViews[mData.APPWIDGET_2_1] != null){
	            		mRemoteViews[mData.APPWIDGET_2_1].setViewVisibility(R.id.tel_log, View.VISIBLE);
	            		mRemoteViews[mData.APPWIDGET_2_1].setTextViewText(R.id.tel_log, String.valueOf(list.size()));
            		}
            		if(mRemoteViews[mData.APPWIDGET_3_1] != null){
	            		mRemoteViews[mData.APPWIDGET_3_1].setViewVisibility(R.id.tel_log, View.VISIBLE);
	            		mRemoteViews[mData.APPWIDGET_3_1].setTextViewText(R.id.tel_log, String.valueOf(list.size()));
            		}

            	}
            	if(mAppWidgetManager[mData.APPWIDGET_2_1] != null){
            		mAppWidgetManager[mData.APPWIDGET_2_1].updateAppWidget(mComponentName[mData.APPWIDGET_2_1], mRemoteViews[mData.APPWIDGET_2_1]);
            	}
            	if(mAppWidgetManager[mData.APPWIDGET_3_1] != null){
            		mAppWidgetManager[mData.APPWIDGET_3_1].updateAppWidget(mComponentName[mData.APPWIDGET_3_1], mRemoteViews[mData.APPWIDGET_3_1]);
            	}

	    	}
	    }
	};

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }
}
