﻿using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.DirectWrite;
using D2DBench.Properties;

using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using Drawing = System.Drawing;

namespace D2DBench
{
    class Method2: IBench
    {
        public int fillAreaSize { get { return 0; } }
        public string methodName { get { return "四角形"; } }
        public int loopCount { get; set; }

        IRender d2d;
        Drawing.Size ClientSize;
        const int Height = 256;
        Random rnd;

        public void Init(Control ctrl, bool antialias, RenderMethod method)
        {
            ClientSize = ctrl.ClientSize;
            if (method == RenderMethod.Direct2D)
                this.d2d = new Direct2D(ctrl, ClientSize, antialias);
            else
                this.d2d = new GDI(ctrl);
            rnd = new Random();
        }

        public void Exec()
        {
            this.d2d.BeginDraw();
            for (int i = 0; i < this.loopCount; i++)
            {
                int left = rnd.Next(ClientSize.Width);
                int top = rnd.Next(ClientSize.Height);
                this.d2d.DrawRectangle(left,
                    top,
                    left + Form1.FigureHeight,
                    top + Form1.FigureHeight,
                    rnd.Next(this.d2d.ColorCount - 1));
            }
            this.d2d.EndDraw();
        }

        public void Dispose()
        {
            this.d2d.Dispose();
        }
    }
}
