﻿using System;
using System.Drawing;
using System.Collections.Generic;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.DirectWrite;

using Factory = SharpDX.Direct2D1.Factory;

namespace D2DBench
{
    class ColorTableD2D
    {
        List<SolidColorBrush> brushlist = new List<SolidColorBrush>();

        public ColorTableD2D(WindowRenderTarget render)
        {
            foreach (KnownColor item in Enum.GetValues(typeof(KnownColor)))
            {
                var brush = new SolidColorBrush(render, Color.FromKnownColor(item));
                brushlist.Add(brush);
            }
        }

        public int Count
        {
            get { return this.brushlist.Count; }
        }

        public SolidColorBrush this[int i]
        {
            get { return this.brushlist[i]; }
        }

        public void Clear()
        {
            foreach (SolidColorBrush brush in this.brushlist)
                brush.Dispose();
            this.brushlist.Clear();
        }
    }
}
