﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;
using D2DBench.Properties;

namespace D2DBench
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            this.textBox4.Text = Screen.GetBounds(this).Size.Width.ToString();
            this.textBox5.Text = Screen.GetBounds(this).Size.Height.ToString();
            this.comboBox1.SelectedIndex = 0;
            this.comboBox2.SelectedIndex = 0;
            if (Environment.OSVersion.Version.Major <= 5)
                this.comboBox3.SelectedIndex = 0;
            else
                this.comboBox3.SelectedIndex = 1;
        }

        public const int FigureHeight = 256;

        private void button1_Click(object sender, EventArgs e)
        {
            int maxcount = GetIntFromComoboBox(this.comboBox1);
            int loopCountAtOneLoop = GetIntFromComoboBox(this.comboBox2);

            this.listView1.Items.Clear();

            Form2 benchFrom = CreateBenchForm();

            List<IBench> methods = new List<IBench>();

            methods.Add(new Method1());
            methods.Add(new Method2());
            methods.Add(new Method6());
            methods.Add(new Method3());
            methods.Add(new Method4());
            methods.Add(new Method5());
            methods.Add(new Method7());

            foreach (IBench method in methods)
            {
                RenderMethod renderMethod = RenderMethod.Direct2D;
                if (this.comboBox3.SelectedIndex == 0)
                    renderMethod = RenderMethod.GDI;
                method.Init(benchFrom, this.comboBox3.SelectedIndex == 2, renderMethod);
                method.loopCount = loopCountAtOneLoop;

                Stopwatch watch = new Stopwatch();
                watch.Start();
                for (int i = 0; i < maxcount; i++)
                    method.Exec();
                watch.Stop();
                
                ListViewItem item = new ListViewItem(method.methodName);
                item.SubItems.Add(string.Format(Resources.Result, watch.ElapsedMilliseconds));
                double fillrate = (double)method.fillAreaSize / watch.ElapsedMilliseconds * 1000 / 1024 / 1024 * maxcount;
                item.SubItems.Add(string.Format(Resources.FillRate, Math.Floor(fillrate * 100) / 100));
                this.listView1.Items.Add(item);

                method.Dispose();
            }

            benchFrom.Close();
        }

        private int GetIntFromComoboBox(ComboBox box)
        {
            if (box.SelectedItem == null)
                return int.Parse(box.Text);
            else
                return int.Parse(box.SelectedItem.ToString());
        }

        private Form2 CreateBenchForm()
        {
            Form2 benchFrom = new Form2();
            benchFrom.Location = new Point(0, 0);
            benchFrom.ClientSize = new Size(Int16.Parse(this.textBox4.Text), Int16.Parse(this.textBox5.Text));
            benchFrom.Show();
            return benchFrom;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            StringBuilder result = new StringBuilder();
            result.AppendFormat("OS:{0}\r\n", Environment.OSVersion.VersionString);
            result.AppendFormat("ウィンドウサイズ:{0}×{1}\r\n", this.textBox4.Text, this.textBox5.Text);
            result.AppendFormat("ループ回数:{0}\r\n", (string)this.comboBox1.SelectedItem);
            result.AppendFormat("実行回数/１ループ:{0}\r\n", (string)this.comboBox2.SelectedItem);
            result.AppendFormat("実行方式:{0}\r\n", this.comboBox3.SelectedItem.ToString());
            foreach (string proc in HWInfo.processorNames)
                result.AppendFormat("CPU:{0}\r\n",proc);
            foreach (string vga in HWInfo.vgaNames)
                result.AppendFormat("Video Controller:{0}\r\n", vga);
            foreach (ListViewItem item in this.listView1.Items)
                result.AppendFormat("{0}:{1} {2}\r\n", item.Text, item.SubItems[1].Text,item.SubItems[2].Text);
            Clipboard.SetText(result.ToString());
        }

    }
}
