/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "GlobalDef.h"
#ifdef _USE_MP3

#include <windows.h>

#include <memory.h>

#include <mmreg.h>
#ifdef _USE_MP3ACM
#include <msacm.h>
#endif // _USE_MP3ACM

#include "_Memory.hpp"

// Wave t@C̃wb_
#ifdef _USE_MP3ACM
typedef struct {
	char			cRIFF[4];
	int				iSizeRIFF;
	char			cType[4];
	char			cFmt[4];
	int				iSizeFmt;
	WAVEFORMATEX	WaveFmt;
	char			cData[4];
	int				iSizeData;
} WAVEEXFILEHEADER;
#else
typedef struct {
	char					cRIFF[4];
	int						iSizeRIFF;
	char					cType[4];
	char					cFmt[4];
	int						iSizeFmt;
	MPEGLAYER3WAVEFORMAT	WaveFmt;
	char					cFact[4];
	int						iSizeFact;
	DWORD					dwSample;
	char					cData[4];
	int						iSizeData;
} MP3WAVEFILEHEADER;
#endif // _USE_MP3ACM

// rbg[g̎擾
int MP3BitRateTable[2][3][14] = {
	// MPEG-1
	{
		{  32,  64,  96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448 },	// Layer-1
		{  32,  48,  56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320, 384 },	// Layer-2
		{  32,  40,  48,  56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320 }	// Layer-3
	},

	// MPEG-2
	{
		{  32,  48,  56,  64,  80,  96, 112, 128, 144, 160, 176, 192, 224, 256 },	// Layer-1
		{   8,  16,  24,  32,  40,  48,  56,  64,  80,  96, 112, 128, 114, 160 },	// Layer-2
		{   8,  16,  24,  32,  40,  48,  56,  64,  80,  96, 112, 128, 114, 160 }	// Later-3
	}
};

// TvOg
int MP3FreqTable[2][3] = {
	// MPEG-1
	{ 44100, 48000, 32000 },

	// MPEG-2
	{ 22050, 24000, 16000 }
};

// t[wb_\
typedef struct {
	BYTE	Layer;			// 0:Layer-1 1:Layer-2 2:Layer-3
	BYTE	MpegV;			// 0:MPEG-1 1:MPEG-2
	BYTE	BitRateIndex;
	BYTE	SampleRateIndex;
	BYTE	PaddingBit;
	BYTE	ChannelNum;
	DWORD	SampleRate;
	DWORD	BitRate;
	DWORD	FrameSize;
} MP3FRAMEHEADER;

BOOL GetMP3FrameHeader( BYTE* Header, MP3FRAMEHEADER* FrHead )
{
	// MP3 f[^ׂ
	if( (Header[0] != 0xFF) || ((Header[1] & 0xF0) != 0xF0) ) return FALSE;

	// MPEG ̃o[W𓾂(0:Ver1 1:Ver2)
	FrHead->MpegV = ((Header[1] & 0x8) == 0x8) ? 0 : 1;

	// C𓾂(0:Layer-1 1:Layer-2 2:Layer-3)
	FrHead->Layer = 3 - ((Header[1] >> 1) & 0x3);
	if( FrHead->Layer > 2 ) return FALSE;

	// rbg[g̃CfbNXl𓾂
	FrHead->BitRateIndex = (Header[2] >> 4) & 0xF;
	if( FrHead->BitRateIndex > 14 ) return FALSE;

	// rbg[g𓾂
	FrHead->BitRate = MP3BitRateTable[FrHead->MpegV][FrHead->Layer][FrHead->BitRateIndex - 1];

	// TvOg̃CfbNXl𓾂
	FrHead->SampleRateIndex = (Header[2] >> 2) & 0x3;
	if( FrHead->SampleRateIndex > 2 ) return FALSE;

	// TvOg𓾂
	FrHead->SampleRate = MP3FreqTable[FrHead->MpegV][FrHead->SampleRateIndex];

	// pfBOrbg𓾂
	FrHead->PaddingBit = (Header[2] >> 1) & 1;

	// `l[h`l𓾂
	FrHead->ChannelNum = (((Header[3] >> 6) & 0x3) == 3) ? 1 : 2;
	
	// t[TCYvZ
	switch( FrHead->MpegV )
	{
	case 0:	// MPEG-1
		switch( FrHead->Layer )
		{
		case 0:	// Layer-1
			FrHead->FrameSize = ((12 * (FrHead->BitRate * 1000) / FrHead->SampleRate) + FrHead->PaddingBit) * 4;
			break;			
		case 1:	// Layer-2
		case 2:	// Layer-3
			FrHead->FrameSize = (144 * (FrHead->BitRate * 1000) / FrHead->SampleRate) + FrHead->PaddingBit;
			break;
		}
		break;
	case 1:	// MPEG-2
		switch( FrHead->Layer )
		{
		case 0:	// Layer-1
			FrHead->FrameSize = ((12 * (FrHead->BitRate * 1000) / FrHead->SampleRate) + FrHead->PaddingBit) * 4;
			break ;
		case 1:	// Layer-2
		case 2:	// Layer-3
			FrHead->FrameSize = (72 * (FrHead->BitRate * 1000) / FrHead->SampleRate) + FrHead->PaddingBit;
			break;
		}
		break;
	}

	// I
	return TRUE;
}

/*
 * MP3  Wave ֕ϊ
 */
_Memory* MP3ToWAV( _Memory* data )
{
	_Memory* pWaveData = NULL;

	int size = data->size();
	BYTE* ptr = data->ptr();
	int offset = 0;

	// ID3 ^O菜
	if( size >= 3 )
	{
		if( (ptr[0] == 'I') &&
			(ptr[1] == 'D') &&
			(ptr[2] == '3') )
		{
			offset = (ptr[6] << 21) + (ptr[7] << 14) + (ptr[8] << 7) + ptr[9] + 10;
			size -= offset;
			if( (ptr[3] == 4) && ((ptr[5] & 0x10) != 0) )
			{
				size -= 10;
			}
		}
		else
		{
			if( size >= 128 )
			{
				if( (ptr[size - 128] == 'T') &&
					(ptr[size - 127] == 'A') &&
					(ptr[size - 126] == 'G') )
				{
					size -= 128;
				}
			}
		}
	}

	MP3FRAMEHEADER MP3Frame;
	if( GetMP3FrameHeader( &(ptr[offset]), &MP3Frame ) == FALSE )
	{
		return NULL;
	}

#ifdef _USE_MP3ACM
	MPEGLAYER3WAVEFORMAT mf;
	memset( &mf, 0, sizeof(MPEGLAYER3WAVEFORMAT) );
	mf.wfx.cbSize          = MPEGLAYER3_WFX_EXTRA_BYTES;
	mf.wfx.wFormatTag      = WAVE_FORMAT_MPEGLAYER3;
	mf.wfx.nChannels       = MP3Frame.ChannelNum;
	mf.wfx.nSamplesPerSec  = MP3Frame.SampleRate;
	mf.wfx.nAvgBytesPerSec = MP3Frame.BitRate * 1000 / 8;
	mf.wfx.nBlockAlign     = 1;
	mf.wfx.wBitsPerSample  = 0;
	mf.wID                 = MPEGLAYER3_ID_MPEG;
	mf.fdwFlags            = MP3Frame.PaddingBit;
	mf.nBlockSize          = (WORD)MP3Frame.FrameSize;
	mf.nFramesPerBlock     = 1;
	mf.nCodecDelay         = 0x0571;

	MMRESULT mmr;

	WAVEFORMATEX wf;
	wf.cbSize     = sizeof(WAVEFORMATEX);
	wf.wFormatTag = WAVE_FORMAT_PCM;
	mmr = acmFormatSuggest( NULL, &mf.wfx, &wf, sizeof(WAVEFORMATEX), ACM_FORMATSUGGESTF_WFORMATTAG );
	if( mmr != 0 )
	{
		return NULL;
	}

	HACMSTREAM as;
	mmr = acmStreamOpen( &as, NULL, &mf.wfx, &wf, NULL, 0, 0, 0 );
	if( mmr != 0 )
	{
		return NULL;
	}

	ACMSTREAMHEADER ash;
	memset( &ash, 0, sizeof(ACMSTREAMHEADER) );
	ash.cbStruct = sizeof(ACMSTREAMHEADER);
	ash.cbSrcLength = size;
	ash.pbSrc = new BYTE[ash.cbSrcLength];
	memcpy( ash.pbSrc, &(ptr[offset]), ash.cbSrcLength );
	mmr = acmStreamSize( as, ash.cbSrcLength, &ash.cbDstLength, ACM_STREAMSIZEF_SOURCE );
	ash.pbDst = new BYTE[ash.cbDstLength];

	mmr = acmStreamPrepareHeader( as, &ash, 0 );
	if( mmr != 0 )
	{
		acmStreamClose( as, 0 );
		delete[] ash.pbSrc;
		delete[] ash.pbDst;
		delete pWaveData;
		return NULL;
	}
	mmr = acmStreamConvert( as, &ash, ACM_STREAMCONVERTF_BLOCKALIGN );
	if( mmr != 0 )
	{
		acmStreamUnprepareHeader( as, &ash, 0 );
		acmStreamClose( as, 0 );
		delete[] ash.pbSrc;
		delete[] ash.pbDst;
		delete pWaveData;
		return NULL;
	}

	// wb_TCY擾
	WAVEEXFILEHEADER wh;
	LONG lWHSize =
		sizeof(wh.cRIFF) + sizeof(wh.iSizeRIFF) + sizeof(wh.cType  ) +
		sizeof(wh.cFmt ) + sizeof(wh.iSizeFmt ) + sizeof(wh.WaveFmt) +
		sizeof(wh.cData) + sizeof(wh.iSizeData);

	// m
	pWaveData = new _Memory();
	if( !(pWaveData->alloc( ash.cbDstLengthUsed + lWHSize, FALSE/*𑼂ɔC*/ )) )
	{
		acmStreamUnprepareHeader( as, &ash, 0 );
		acmStreamClose( as, 0 );
		delete[] ash.pbSrc;
		delete[] ash.pbDst;
		delete pWaveData;
		return NULL;
	}

	// ̃f[^֏
	memcpy( pWaveData->ptr() + lWHSize, ash.pbDst, ash.cbDstLengthUsed );

	// wb_̏
	memcpy( wh.cRIFF, "RIFF", 4 );
	wh.iSizeRIFF = lWHSize + ash.cbDstLengthUsed - 8;
	memcpy( wh.cType, "WAVE", 4 );
	memcpy( wh.cFmt , "fmt ", 4 );
	wh.iSizeFmt = sizeof(WAVEFORMATEX);
	memcpy( &wh.WaveFmt, &wf, sizeof(WAVEFORMATEX) );
	memcpy( wh.cData, "data", 4 );
	wh.iSizeData = ash.cbDstLengthUsed;

	// ̃wb_֏
	INT iSize = 0;
	memcpy( pWaveData->ptr(),         &wh.cRIFF,     sizeof(wh.cRIFF    ) ); iSize += sizeof(wh.cRIFF    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeRIFF, sizeof(wh.iSizeRIFF) ); iSize += sizeof(wh.iSizeRIFF);
	memcpy( pWaveData->ptr() + iSize, &wh.cType,     sizeof(wh.cType    ) ); iSize += sizeof(wh.cType    );
	memcpy( pWaveData->ptr() + iSize, &wh.cFmt,      sizeof(wh.cFmt     ) ); iSize += sizeof(wh.cFmt     );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeFmt,  sizeof(wh.iSizeFmt ) ); iSize += sizeof(wh.iSizeFmt );
	memcpy( pWaveData->ptr() + iSize, &wh.WaveFmt,   sizeof(wh.WaveFmt  ) ); iSize += sizeof(wh.WaveFmt  );
	memcpy( pWaveData->ptr() + iSize, &wh.cData,     sizeof(wh.cData    ) ); iSize += sizeof(wh.cData    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeData, sizeof(wh.iSizeData) );

	acmStreamUnprepareHeader( as, &ash, 0 );
	acmStreamClose( as, 0 );
	delete[] ash.pbSrc;
	delete[] ash.pbDst;
#else
	// wb_TCY擾
	MP3WAVEFILEHEADER wh;
	LONG lWHSize =
		sizeof(wh.cRIFF) + sizeof(wh.iSizeRIFF) + sizeof(wh.cType   ) +
		sizeof(wh.cFmt ) + sizeof(wh.iSizeFmt ) + sizeof(wh.WaveFmt ) +
		sizeof(wh.cFact) + sizeof(wh.iSizeFact) + sizeof(wh.dwSample) +
		sizeof(wh.cData) + sizeof(wh.iSizeData);

	// m
	pWaveData = new _Memory();
	if( !(pWaveData->alloc( size + lWHSize, FALSE/*𑼂ɔC*/ )) )
	{
		delete pWaveData;
		return NULL;
	}

	// ̃f[^֏
	memcpy( pWaveData->ptr() + lWHSize, &(ptr[offset]), size );

	// wb_̏
	memcpy( wh.cRIFF, "RIFF", 4 );
	wh.iSizeRIFF = lWHSize + size - 8;
	memcpy( wh.cType, "WAVE", 4 );
	memcpy( wh.cFmt , "fmt ", 4 );
	wh.iSizeFmt = sizeof(MPEGLAYER3WAVEFORMAT);
	memset( &(wh.WaveFmt), 0, sizeof(MPEGLAYER3WAVEFORMAT) );
	wh.WaveFmt.wfx.cbSize          = MPEGLAYER3_WFX_EXTRA_BYTES;
	wh.WaveFmt.wfx.wFormatTag      = WAVE_FORMAT_MPEGLAYER3;
	wh.WaveFmt.wfx.nChannels       = MP3Frame.ChannelNum;
	wh.WaveFmt.wfx.nSamplesPerSec  = MP3Frame.SampleRate;
	wh.WaveFmt.wfx.nAvgBytesPerSec = MP3Frame.BitRate * 1000 / 8;
	wh.WaveFmt.wfx.nBlockAlign     = 1;
	wh.WaveFmt.wfx.wBitsPerSample  = 0;
	wh.WaveFmt.wID                 = MPEGLAYER3_ID_MPEG;
	wh.WaveFmt.fdwFlags            = MP3Frame.PaddingBit;
	wh.WaveFmt.nBlockSize          = (WORD)MP3Frame.FrameSize;
	wh.WaveFmt.nFramesPerBlock     = 1;
	wh.WaveFmt.nCodecDelay         = 0x0571;
	memcpy( wh.cFact, "fact", 4 );
	wh.iSizeFact = 4;
	wh.dwSample = (DWORD)((double)size / (double)wh.WaveFmt.wfx.nAvgBytesPerSec * (double)MP3Frame.SampleRate);
	memcpy( wh.cData, "data", 4 );
	wh.iSizeData = size;

	// ̃wb_֏
	INT iSize = 0;
	memcpy( pWaveData->ptr(),         &wh.cRIFF,     sizeof(wh.cRIFF    ) ); iSize += sizeof(wh.cRIFF    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeRIFF, sizeof(wh.iSizeRIFF) ); iSize += sizeof(wh.iSizeRIFF);
	memcpy( pWaveData->ptr() + iSize, &wh.cType,     sizeof(wh.cType    ) ); iSize += sizeof(wh.cType    );
	memcpy( pWaveData->ptr() + iSize, &wh.cFmt,      sizeof(wh.cFmt     ) ); iSize += sizeof(wh.cFmt     );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeFmt,  sizeof(wh.iSizeFmt ) ); iSize += sizeof(wh.iSizeFmt );
	memcpy( pWaveData->ptr() + iSize, &wh.WaveFmt,   sizeof(wh.WaveFmt  ) ); iSize += sizeof(wh.WaveFmt  );
	memcpy( pWaveData->ptr() + iSize, &wh.cFact,     sizeof(wh.cFact    ) ); iSize += sizeof(wh.cFact    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeFact, sizeof(wh.iSizeFact) ); iSize += sizeof(wh.iSizeFact);
	memcpy( pWaveData->ptr() + iSize, &wh.dwSample,  sizeof(wh.dwSample ) ); iSize += sizeof(wh.dwSample );
	memcpy( pWaveData->ptr() + iSize, &wh.cData,     sizeof(wh.cData    ) ); iSize += sizeof(wh.cData    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeData, sizeof(wh.iSizeData) );
#endif // _USE_MP3ACM

	return pWaveData;
}

#endif // _USE_MP3
