/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#define STRICT				// ^`FbNɍsȂ
#define WIN32_LEAN_AND_MEAN	// wb_[gȂ֐Ȃ
#define WINVER 0x040A		// Windows 98 & Windows 2000 ȍ~

#include <windows.h>

#include <mmsystem.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <d3dx9.h>
#if D3D_SDK_VERSION >= 32
#include <dxerr.h>
#else
#include <dxerr9.h>
#endif // D3D_SDK_VERSION >= 32

#include "_Main.hpp"

#include "_Graphics.hpp"
#include "_ImageInfo.hpp"
#include "_Memory.hpp"
#include "_SoundData.hpp"
#include "_String.hpp"

#include "_Global.h"

#define WRITE_ERR(str,hr)	g_main->writeLog( str ); DXTRACE_ERR( str, hr )
#define RETURN_ERR(str,hr)	g_main->writeLog( str ); return DXTRACE_ERR( str, hr )

_MAIN_CLASS* g_main;

char g_appDir[MAX_PATH];
char g_logFile[MAX_PATH];

// EBhEEXg
#include <list>
#include <utility>
using namespace std;
typedef pair<HWND, WINDOWPLACEMENT> window_attr;
typedef list<window_attr> window_list;
window_list wl;

// FPS vp
UINT g_framePerSecond = 0;								//
UINT g_frame = 0;										//
UINT g_oldFrame = 0;									//

HINSTANCE g_hInstance = NULL;							// CX^XEnh
HWND g_hWindow = NULL;									// EChEEnh

BOOL g_bRun = TRUE;										//
BOOL g_bActive = FALSE;									// ANeBu
BOOL g_bSuspend = FALSE;								// TXyh
BOOL g_bSuspendTimer = FALSE;							// TXyh^C}[ɂ paint() ֐Ăяosǂ
BOOL g_bDeviceLost = FALSE;								// foCX̏tO
BOOL g_bDraw = TRUE;									//

// C^[tFCX
LPDIRECT3D9 g_pD3D = NULL;								// Direct3D C^[tFCX
LPDIRECT3DDEVICE9 g_pD3DDevice = NULL;					// Direct3DDevice C^[tFCX
D3DPRESENT_PARAMETERS g_D3DPP;							// D3DDevice ̐ݒ

#ifdef _USE_DIRECTMUSIC
// DirectMusic ̕ϐ
IDirectMusicPerformance8* g_pPerformance = NULL;		// ptH[}X
IDirectMusicAudioPath8* g_pDefAudioPath = NULL;			// ftHgEI[fBIpX
IDirectMusicAudioPath8* g_pAudioPath = NULL;			// BGM pI[fBIEpX
IDirectMusicLoader8* g_pLoader = NULL;					// [_[
#else
// DirectSound ̕ϐ
LPDIRECTSOUND8 g_pDSound = NULL;						// DirectSound C^[tFCX
#ifdef _USE_DUPLICATESOUND
IDirectSoundBuffer* g_srcSound[_DUPLICATESOUND_NUM];	// Lobt@̋L
IDirectSoundBuffer* g_dupSound[_DUPLICATESOUND_NUM];	// Lobt@
int g_soundIndex = 0;									//
#endif // _USE_DUPLICATESOUND
#endif // _USE_DIRECTMUSIC
BOOL g_bEnableSound = FALSE;							//
_SoundData g_curSound;									//
int g_minVolume;										//
int g_maxVolume;										//
int g_volumeMusic;										//
int g_volumeSound;										//

// XvCg@\
LPD3DXSPRITE g_pD3DXSprite = NULL;						// XvCg

// tHg@\
LPD3DXFONT g_pD3DXFont = NULL;							// D3DXFont C^[tFCX

// VFCvp
LPDIRECT3DTEXTURE9 g_pShapeTexture = NULL;				//
LPDIRECT3DSURFACE9 g_pShapeSurface = NULL;				//

// wiF
D3DCOLOR g_backCol;

// L[ATCp
UINT g_keyAssign[26];

// L[͗p
BYTE g_keyState[256];									// L[{[h
JOYINFO g_joyInfo;										// WCXeBbN
UINT g_key = 0;

// }EXp
POINT g_mousePos;

_Main::_Main()
{
	_g = new _Graphics();

	// wiF
	g_backCol = _g->getColorOfRGB( 0, 0, 0 );

	// L[ATCp
	int i;
	for( i = 'A'; i <= 'Z'; i++ )
	{
		g_keyAssign[i - 'A'] = 0;
	}
}

_Main::~_Main()
{
	delete _g;
}

void _Main::writeLog( LPCTSTR str )
{
	if( g_logFile[0] != '\0' )
	{
		FILE* fp;
		if( (fp = fopen( g_logFile, "a+t" )) != NULL )
		{
			fprintf( fp, "%s\n", str );
			fflush( fp );
			fclose( fp );
		}
	}
}

void _Main::terminate()
{
	g_bRun = FALSE;
}

// wiF
void _Main::setBackColor( D3DCOLOR col )
{
	g_backCol = col;
}

// L[ATC
void _Main::setKeyAssign( int key, UINT key_type )
{
	g_keyAssign[key - 'A'] = key_type;
}
void _Main::setKey( UINT key_z, UINT key_x, UINT key_c, UINT key_v )
{
	setKeyAssign( 'Z', key_z );
	setKeyAssign( 'X', key_x );
	setKeyAssign( 'C', key_c );
	setKeyAssign( 'V', key_v );
}

// L[͗p
void GetKey()
{
	UINT key = 0;

	// L[̓`FbN
	if( GetKeyboardState( g_keyState ) )
	{
		if( g_keyState[VK_ESCAPE] & 0x80 ) key |= _KEY_ESCAPE;
		if( g_keyState[VK_SHIFT ] & 0x80 ) key |= _KEY_SHIFT;
		if( g_keyState[VK_SPACE ] & 0x80 ) key |= _KEY_SPACE;
		if( g_keyState[VK_LEFT  ] & 0x80 ) key |= _KEY_LEFT;
		if( g_keyState[VK_RIGHT ] & 0x80 ) key |= _KEY_RIGHT;
		if( g_keyState[VK_UP    ] & 0x80 ) key |= _KEY_UP;
		if( g_keyState[VK_DOWN  ] & 0x80 ) key |= _KEY_DOWN;
		int i;
		for( i = 'A'; i <= 'Z'; i++ )
		{
			if( g_keyAssign[i - 'A'] != 0 )
			{
				if( g_keyState[i] & 0x80 ) key |= g_keyAssign[i - 'A'];
			}
		}
	}

	// WCXeBbN̓`FbN
	if( !joyGetPos( JOYSTICKID1, &g_joyInfo ) )
	{
		if( g_joyInfo.wXpos == 0              ) key |= _KEY_LEFT;
		if( g_joyInfo.wXpos == 65535          ) key |= _KEY_RIGHT;
		if( g_joyInfo.wYpos == 0              ) key |= _KEY_UP;
		if( g_joyInfo.wYpos == 65535          ) key |= _KEY_DOWN;
		if( g_joyInfo.wButtons & JOY_BUTTON1  ) key |= _KEY_BUTTON1;
		if( g_joyInfo.wButtons & JOY_BUTTON2  ) key |= _KEY_BUTTON2;
		if( g_joyInfo.wButtons & JOY_BUTTON3  ) key |= _KEY_BUTTON3;
		if( g_joyInfo.wButtons & JOY_BUTTON4  ) key |= _KEY_BUTTON4;
		if( g_joyInfo.wButtons & JOY_BUTTON5  ) key |= _KEY_BUTTON5;
		if( g_joyInfo.wButtons & JOY_BUTTON6  ) key |= _KEY_BUTTON6;
		if( g_joyInfo.wButtons & JOY_BUTTON7  ) key |= _KEY_BUTTON7;
		if( g_joyInfo.wButtons & JOY_BUTTON8  ) key |= _KEY_BUTTON8;
		if( g_joyInfo.wButtons & JOY_BUTTON9  ) key |= _KEY_BUTTON9;
		if( g_joyInfo.wButtons & JOY_BUTTON10 ) key |= _KEY_BUTTON10;
		if( g_joyInfo.wButtons & JOY_BUTTON11 ) key |= _KEY_BUTTON11;
		if( g_joyInfo.wButtons & JOY_BUTTON12 ) key |= _KEY_BUTTON12;
		if( g_joyInfo.wButtons & JOY_BUTTON13 ) key |= _KEY_BUTTON13;
	}

	if( key != g_key )
	{
		int i;
		for( i = 0; i < 20; i++ )
		{
			UINT tmp = 1 << i;
			if( ((g_key & tmp) != 0) && ((key & tmp) == 0) )
			{
				g_main->processEvent( _KEY_RELEASED_EVENT, tmp );
			}
		}
		for( i = 0; i < 20; i++ )
		{
			UINT tmp = 1 << i;
			if( ((g_key & tmp) == 0) && ((key & tmp) != 0) )
			{
				g_main->processEvent( _KEY_PRESSED_EVENT, tmp );
			}
		}
		g_key = key;
	}
}
BOOL _Main::checkKey( int key )
{
	if( GetKeyState( key ) & 0x80 ) return TRUE;
	return FALSE;
}
UINT _Main::getKeypadState()
{
	return g_key;
}

// }EX
int _Main::getMouseX()
{
	return g_mousePos.x;
}
int _Main::getMouseY()
{
	return g_mousePos.y;
}

_Graphics* _Main::getGraphics()
{
	return _g;
}

#ifdef _USE_CAPTURE
HRESULT SaveFrontBuffer();
#endif // _USE_CAPTURE
#ifdef _USE_MP3
_Memory* MP3ToWAV( _Memory* data );
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
_Memory* OggVorbisToWAV( LPCSTR szName, INT iWord );
#endif // _USE_OGGVORBIS

/*
 * EBhE
 */
LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, UINT wParam, LONG lParam )
{
	HRESULT hr;

	switch( msg )
	{
	case WM_ACTIVATE:
		g_bActive = (LOWORD( wParam ) != 0);
		break;
	case WM_DESTROY:
		// Q[ŗL̏I
		g_main->destroy();

		// tHg̏
		if( g_pD3DXFont )
		{
			g_pD3DXFont->OnLostDevice();
			g_pD3DXFont->Release();
		}

		// XvCg̏
		if( g_pD3DXSprite )
		{
			g_pD3DXSprite->OnLostDevice();
			g_pD3DXSprite->Release();
		}

		// VFCvp
		if( g_pShapeSurface )
		{
			g_pShapeSurface->Release();
		}
		if( g_pShapeTexture )
		{
			g_pShapeTexture->Release();
		}

		// t~
		g_main->stopMusic();
#ifdef _USE_DIRECTMUSIC
		if( g_pPerformance )
		{
			hr = g_pPerformance->Stop( NULL, NULL, 0, 0 );
			if( FAILED( hr ) )
			{
				WRITE_ERR( "SZOg̉t~Ɏs", hr );
			}
		}
#endif // _USE_DIRECTMUSIC

		// DirectX Graphics ̏I
		if( g_pD3DDevice )
		{
			g_pD3DDevice->Release();
		}
		if( g_pD3D )
		{
			g_pD3D->Release();
		}

#ifdef _USE_DIRECTMUSIC
		// DirectMusic ̏I
		if( g_pLoader )
		{
			g_pLoader->Release();
		}
		if( g_pDefAudioPath )
		{
			g_pDefAudioPath->Release();
		}
		if( g_pAudioPath )
		{
			g_pAudioPath->Release();
		}
		if( g_pPerformance )
		{
			hr = g_pPerformance->CloseDown();
			if( FAILED( hr ) )
			{
				WRITE_ERR( "ptH[}X̃N[YɎs", hr );
			}
			g_pPerformance->Release();
		}
#else
#ifdef _USE_DUPLICATESOUND
		for( int i = 0; i < _DUPLICATESOUND_NUM; i++ )
		{
			if( g_dupSound[i] != NULL )
			{
				g_dupSound[i]->Release();
			}
		}
#endif // _USE_DUPLICATESOUND

		// DirectSound ̏I
		if( g_pDSound )
		{
			g_pDSound->Release();
		}
#endif // _USE_DIRECTMUSIC

		// EChE
		PostQuitMessage( 0 );

		g_hWindow = NULL;

		return 0;
	case WM_SETCURSOR:
		if( !(g_main->showCursor()) )
		{
			if( g_D3DPP.Windowed )
			{
				POINT pos;
				::GetCursorPos( &pos );
				::ScreenToClient( g_hWindow, &pos );
				if( (pos.x >= 0) && (pos.x < g_main->width ()) &&
					(pos.y >= 0) && (pos.y < g_main->height()) )
				{
					SetCursor( NULL );
					return 1;
				}
			}
			else
			{
				SetCursor( NULL );
				return 1;
			}
		}
		break;
	case WM_LBUTTONDOWN:
		::SetCapture( g_hWindow );
		g_main->processEvent( _MOUSE_LBUTTONDOWN_EVENT, 0 );
		break;
	case WM_LBUTTONUP:
		::ReleaseCapture();
		g_main->processEvent( _MOUSE_LBUTTONUP_EVENT, 0 );
		break;
	case WM_RBUTTONDOWN:
		::SetCapture( g_hWindow );
		g_main->processEvent( _MOUSE_RBUTTONDOWN_EVENT, 0 );
		break;
	case WM_RBUTTONUP:
		::ReleaseCapture();
		g_main->processEvent( _MOUSE_RBUTTONUP_EVENT, 0 );
		break;
	case WM_MOUSEMOVE:
		g_mousePos.x = LOWORD( lParam );
		g_mousePos.y = HIWORD( lParam );
		g_main->processEvent( _MOUSE_MOVE_EVENT, 0 );
		break;
#ifdef _USE_CAPTURE
	case WM_KEYDOWN:
		if( wParam == _CAPTURE_KEY )
		{
			SaveFrontBuffer();
		}
		break;
#endif // _USE_CAPTURE
	}

	// ftHg
	return DefWindowProc( hWnd, msg, wParam, lParam );
}

/*
 * AvP[V(ŏɈxĂ΂)
 */
HRESULT InitApp()
{
	// EChEENX̓o^
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style         = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc   = (WNDPROC)MainWndProc;
	wcex.cbClsExtra    = 0;
	wcex.cbWndExtra    = 0;
	wcex.hInstance     = g_hInstance;
	wcex.hIcon         = LoadIcon( g_hInstance, (LPCTSTR)_WNDCLASS_ICON );
	wcex.hIconSm       = (HICON)LoadImage( g_hInstance, (LPCTSTR)_WNDCLASS_ICON, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR );
	wcex.hCursor       = LoadCursor( NULL, IDC_ARROW );
	wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wcex.lpszMenuName  = NULL;
	wcex.lpszClassName = _WNDCLASS_NAME;

	if( !RegisterClassEx( &wcex ) )
	{
		RETURN_ERR( "EChEENX̓o^Ɏs", GetLastError() );
	}

	RECT rect;
	if( g_main->isWindow() )
	{
		RECT tmp;
		tmp.left   = 0;
		tmp.top    = 0;
		tmp.right  = g_main->width();
		tmp.bottom = g_main->height();
		AdjustWindowRect( &tmp, WS_OVERLAPPED | WS_CAPTION, FALSE );

		RECT r;
		GetWindowRect( GetDesktopWindow(), &r );

		rect.left   = (r.right - tmp.right) / 2;
		rect.top    = (r.bottom - tmp.bottom) / 2;
		rect.right  = tmp.right - tmp.left;
		rect.bottom = tmp.bottom - tmp.top;
	}
	else
	{
		rect.left   = 0;
		rect.top    = 0;
		rect.right  = g_main->width();
		rect.bottom = g_main->height();
	}

	g_hWindow = CreateWindow(
		_WNDCLASS_NAME, _WINDOW_TITLE,
		g_main->isWindow() ? (WS_OVERLAPPED | WS_CAPTION) : WS_POPUP,
		rect.left, rect.top, rect.right, rect.bottom,
		NULL, NULL, g_hInstance, NULL
		);
	if( g_hWindow == NULL )
	{
		RETURN_ERR( "EChE쐬Ɏs", GetLastError() );
	}

	// IME ֎~
	ImmAssociateContext( g_hWindow, NULL );

	// EChE\
	ShowWindow( g_hWindow, SW_SHOWNORMAL );
	UpdateWindow( g_hWindow );

	return S_OK;
}

/*
 * K؂ Direct3DDevice tH[}bg̑I
 */
HRESULT CheckDeviceCaps( D3DCAPS9* Caps );
HRESULT SelectAdapterFormat( UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode );
HRESULT SelectDisplayMode( UINT Adapter );
HRESULT SelectD3DDevice( UINT* Adapter, D3DDEVTYPE* Device )
{
	ZeroMemory( &g_D3DPP, sizeof(g_D3DPP) );
	g_D3DPP.MultiSampleType            = D3DMULTISAMPLE_NONE;
	g_D3DPP.MultiSampleQuality         = 0;
	g_D3DPP.SwapEffect                 = D3DSWAPEFFECT_DISCARD;
	g_D3DPP.hDeviceWindow              = g_hWindow;
	g_D3DPP.Windowed                   = g_main->isWindow() ? TRUE : FALSE;
	g_D3DPP.EnableAutoDepthStencil     = FALSE;
	g_D3DPP.AutoDepthStencilFormat     = D3DFMT_UNKNOWN;
	g_D3DPP.Flags                      = 0;
	g_D3DPP.FullScreen_RefreshRateInHz = 0;
	g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;

	// A_v^̑I
	*Adapter = D3DADAPTER_DEFAULT;	// vC}EfBXvCEA_v^

	// foCX\͂̎擾
	D3DCAPS9 Caps;	// \͂󂯎 D3DCAPS9 \

	HRESULT hr;
	*Device = D3DDEVTYPE_HAL;	// HALfoCX`FbN
	hr = g_pD3D->GetDeviceCaps( *Adapter, *Device, &Caps );
	if( FAILED( hr ) || FAILED( CheckDeviceCaps( &Caps ) ) )
	{
		WRITE_ERR( "HALfoCX̃`FbNs", E_FAIL );

		*Device = D3DDEVTYPE_REF;	// REFfoCX`FbN
		hr = g_pD3D->GetDeviceCaps( *Adapter, *Device, &Caps );
		if( FAILED( hr ) || FAILED( CheckDeviceCaps( &Caps ) ) )
		{
			RETURN_ERR( "REFfoCX̃`FbNs", E_FAIL );
		}
	}

	// ݂̃fBXvC̃tH[}bgȂǂ擾Ă
	D3DDISPLAYMODE dmode;
	hr = g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &dmode );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "݂̃fBXvC[h擾Ɏs", hr );
	}

	// fBXvCƃobNEobt@̃tH[}bg̒
	hr = SelectAdapterFormat( *Adapter, *Device, dmode );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "fBXvCƃobNEobt@̃tH[}bg擾Ɏs", hr );
	}

	// fBXvCE[h𒲂ׂ
	hr = SelectDisplayMode( *Adapter );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "fBXvCE[hIɎs", hr );
	}

	return S_OK;
}

/*
 * foCX\͂̃`FbN
 */
HRESULT CheckDeviceCaps( D3DCAPS9* Caps )
{
//	// _Xg[
//	if( Caps->MaxStreams < 3 )
//	{
//		RETURN_ERR( "_Xg[Ȃ", E_FAIL );
//	}

//	// v~eBu
//	if( Caps->MaxPrimitiveCount < 0xFFFF )
//	{
//		RETURN_ERR( "v~eBuȂ", E_FAIL );
//	}

//	// CfbNX
//	if( Caps->MaxVertexIndex < 0xFFFF )
//	{
//		RETURN_ERR( "CfbNXȂ", E_FAIL );
//	}

//	// _VF[_Eo[W
//	if( Caps->VertexShaderVersion < D3DVS_VERSION(2, 0) )
//	{
//		RETURN_ERR( "_VF[_Eo[WႢ", E_FAIL );
//	}

//	// sNZEVF[_Eo[W
//	if( Caps->PixelShaderVersion < D3DPS_VERSION(2, 0) )
//	{
//		RETURN_ERR( "sNZEVF[_Eo[WႢ", E_FAIL );
//	}

	return S_OK;
}

/*
 * fBXvCƃobNEobt@̃tH[}bg̒
 */
HRESULT SelectAdapterFormat( UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode )
{
	int i;
	HRESULT hr = S_OK;
	D3DFORMAT FORMAT[] = { D3DFMT_X8R8G8B8, D3DFMT_X1R5G5B5, D3DFMT_R5G6B5 };	// ]fBXvCEtH[}bg
	if( g_main->isWindow() )
	{
		// EChEE[h
		g_D3DPP.BackBufferCount = 1;
		for( i = 0; i < 3; i++ )
		{
			hr = g_pD3D->CheckDeviceType( Adapter, Device, dmode.Format, FORMAT[i], TRUE );
			if( SUCCEEDED( hr ) )
			{
				g_D3DPP.BackBufferFormat = FORMAT[i];
				break;
			}
		}
		if( FAILED( hr ) )
		{
			RETURN_ERR( "fBXvCƃobNEobt@̃tH[}bg擾Ɏs", hr );
		}
	}
	else
	{
		// tXN[E[h
		g_D3DPP.BackBufferCount = 1;
		for( i = 0; i < 3; i++ )
		{
			hr = g_pD3D->CheckDeviceType( Adapter, Device, FORMAT[i], FORMAT[i], FALSE );
			if( SUCCEEDED( hr ) )
			{
				g_D3DPP.BackBufferFormat = FORMAT[i];
				break;
			}
		}
		if( FAILED( hr ) )
		{
			RETURN_ERR( "fBXvCƃobNEobt@̃tH[}bg擾Ɏs", hr );
		}
	}
	return S_OK;
}

/*
 * fBXvCE[h𒲂ׂ
 */
HRESULT SelectDisplayMode( UINT Adapter )
{
	if( g_main->isWindow() )
	{
		// EChEE[h(ׂKvȂ)
		g_D3DPP.BackBufferWidth  = 0;
		g_D3DPP.BackBufferHeight = 0;
	}
	else
	{
		// tXN[E[h
		D3DDISPLAYMODE dmode = { 0, 0, 0, D3DFMT_UNKNOWN };
		int level = 1000000;
		int num = g_pD3D->GetAdapterModeCount( Adapter, g_D3DPP.BackBufferFormat );
		for( int i = 0; i < num; i++ )
		{
			// fBXvCE[h̗
			D3DDISPLAYMODE dm;
			g_pD3D->EnumAdapterModes( Adapter, g_D3DPP.BackBufferFormat, i, &dm );

			// ]̃[hƂ̌덷
			int l = abs( (int)(g_main->width() - dm.Width) ) + abs( (int)(g_main->height() - dm.Height) );
			if( l < level )
			{
				// K؂ȃ[hI
				dmode = dm;
				level = l;
			}
		}
		if( dmode.Format == D3DFMT_UNKNOWN )
		{
			RETURN_ERR( "fBXvCE[hIɎs", E_FAIL );
		}
		g_D3DPP.BackBufferWidth  = dmode.Width;
		g_D3DPP.BackBufferHeight = dmode.Height;
	}
	return S_OK;
}

/*
 * DirectX Graphics 
 */
HRESULT InitDXGraphics()
{
	HRESULT hr;

	// Direct3D IuWFNg̍쐬
	g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );
	if( g_pD3D == NULL )
	{
		RETURN_ERR( "Direct3D IuWFNg̍쐬Ɏs", E_FAIL );
	}

	// D3DDevice IuWFNg̍쐬
	UINT Adapter;
	D3DDEVTYPE Device;
	hr = SelectD3DDevice( &Adapter, &Device );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "K؂ Direct3DDevice tH[}bg̑IɎs", hr );
	}
	hr = g_pD3D->CreateDevice(
		Adapter, Device, g_hWindow,
		D3DCREATE_HARDWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice
		);
	if( FAILED( hr ) )
	{
		hr = g_pD3D->CreateDevice(
			Adapter, Device, g_hWindow,
			D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice
			);
		if( FAILED( hr ) )
		{
			RETURN_ERR( "D3DDevice IuWFNg̍쐬Ɏs", hr );
		}
	}

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X      = 0;
	vp.Y      = 0;
	vp.Width  = g_D3DPP.BackBufferWidth;
	vp.Height = g_D3DPP.BackBufferHeight;
	vp.MinZ   = 0.0f;
	vp.MaxZ   = 1.0f;
	hr = g_pD3DDevice->SetViewport( &vp );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "r[|[g̐ݒɎs", hr );
	}

	// ufBOL
	g_pD3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	g_pD3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	g_pD3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	// XvCg@\̏
	hr = D3DXCreateSprite( g_pD3DDevice, &g_pD3DXSprite );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "XvCg@\̏Ɏs", hr );
	}

	// tHg@\̏
	hr = D3DXCreateFont(
		g_pD3DDevice,
		_FONT_HEIGHT,					// 
		NULL,							// 
		FW_DONTCARE,					// 
		NULL,							// ~bv}bvx
		FALSE,							// Α
		SHIFTJIS_CHARSET,				// Zbg
		OUT_DEFAULT_PRECIS,				// o͐x
		DEFAULT_QUALITY,				// o͕i
		DEFAULT_PITCH | FF_DONTCARE,	// tHgsb`tHgt@~
		_FONT_FACENAME,					// tHg
		&g_pD3DXFont
		);
	if( FAILED( hr ) )
	{
		RETURN_ERR( "tHg@\̏Ɏs", hr );
	}

	// VFCvp
	g_pD3DDevice->CreateTexture( 1, 1, 0, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &g_pShapeTexture, NULL );
	g_pShapeTexture->GetSurfaceLevel( 0, &g_pShapeSurface );

	return S_OK;
}

#ifdef _USE_DIRECTMUSIC
/*
 * DirectMusic Ɋւ鏉
 */
void InitDMusic()
{
	HRESULT hr;

	// ptH[}X̍쐬
	hr = CoCreateInstance(
		CLSID_DirectMusicPerformance, NULL,
		CLSCTX_INPROC, IID_IDirectMusicPerformance8,
		(void**)&g_pPerformance
		);
	if( FAILED( hr ) )
	{
		WRITE_ERR( "ptH[}X̍쐬Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	// ptH[}X̏
	hr = g_pPerformance->InitAudio(
		NULL,								// IDirectMusic C^[tFCX͕sv
		NULL,								// IDirectSound C^[tFCX͕sv
		g_hWindow,							// EBhẼnh
		DMUS_APATH_SHARED_STEREOPLUSREVERB,	// ftHg̃I[fBIpXE^Cv
		64,									// ptH[}XE`l̐
		DMUS_AUDIOF_ALL,					// VZTCŰ@\
		NULL								// I[fBIEp[^ɂ̓ftHggp
		);
	if( FAILED( hr ) )
	{
		WRITE_ERR( "ptH[}X̏Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	// ftHgEI[fBIpX̎擾
	hr = g_pPerformance->GetDefaultAudioPath( &g_pDefAudioPath );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "ftHgEI[fBIpX̎擾Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	// BGM p̃I[fBIEpX
	hr = g_pPerformance->CreateStandardAudioPath(
		DMUS_APATH_DYNAMIC_STEREO,	// pX̎
		64,							// ptH[}XE`l̐
		TRUE,						// ŃANeBuɂȂ
		&g_pAudioPath
		);
	if( FAILED( hr ) )
	{
		WRITE_ERR( "I[fBIEpX̍쐬Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	g_minVolume = DSBVOLUME_MIN + (DSBVOLUME_MAX - DSBVOLUME_MIN) / 2;
	g_maxVolume = DSBVOLUME_MAX;
	if( g_main->volumeMusic() == 0 )
	{
		g_volumeMusic = DSBVOLUME_MIN;
	}
	else if( g_main->volumeMusic() == 100 )
	{
		g_volumeMusic = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeMusic = g_minVolume + (g_maxVolume - g_minVolume) * g_main->volumeMusic() / 100;
	}
	if( g_main->volumeSound() == 0 )
	{
		g_volumeSound = DSBVOLUME_MIN;
	}
	else if( g_main->volumeSound() == 100 )
	{
		g_volumeSound = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeSound = g_minVolume + (g_maxVolume - g_minVolume) * g_main->volumeSound() / 100;
	}

	// [_[̍쐬
	hr = CoCreateInstance(
		CLSID_DirectMusicLoader, NULL, 
		CLSCTX_INPROC, IID_IDirectMusicLoader8,
		(void**)&g_pLoader
		);
	if( FAILED( hr ) )
	{
		WRITE_ERR( "[_[̍쐬Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	// [_[ɌpXݒ
	char strPath[MAX_PATH];
	WCHAR wstrSearchPath[MAX_PATH];
	strcpy( strPath, g_appDir );
	MultiByteToWideChar( CP_ACP, 0, strPath, -1, wstrSearchPath, MAX_PATH );
	hr = g_pLoader->SetSearchDirectory(
		GUID_DirectMusicAllTypes,
		wstrSearchPath, FALSE
		);
	if( FAILED( hr ) )
	{
		WRITE_ERR( "pX̐ݒɎs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	g_bEnableSound = TRUE;
}
#else
/*
 * DirectSound Ɋւ鏉
 */
void InitDSound()
{
	HRESULT hr;

	// IDirectSound8 C^[tFCX̎擾
	hr = DirectSoundCreate8( NULL, &g_pDSound, NULL );
	if( FAILED( hr ) )
	{
	    WRITE_ERR( "IDirectSound8 C^[tFCX̎擾Ɏs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	// xݒ
	hr = g_pDSound->SetCooperativeLevel( g_hWindow, DSSCL_PRIORITY );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "x̐ݒɎs", hr );
		g_bEnableSound = FALSE;
		return;
	}

	g_minVolume = DSBVOLUME_MIN + (DSBVOLUME_MAX - DSBVOLUME_MIN) / 2;
	g_maxVolume = DSBVOLUME_MAX;
	if( g_main->volumeMusic() == 0 )
	{
		g_volumeMusic = DSBVOLUME_MIN;
	}
	else if( g_main->volumeMusic() == 100 )
	{
		g_volumeMusic = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeMusic = g_minVolume + (g_maxVolume - g_minVolume) * g_main->volumeMusic() / 100;
	}
	if( g_main->volumeSound() == 0 )
	{
		g_volumeSound = DSBVOLUME_MIN;
	}
	else if( g_main->volumeSound() == 100 )
	{
		g_volumeSound = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeSound = g_minVolume + (g_maxVolume - g_minVolume) * g_main->volumeSound() / 100;
	}

	g_bEnableSound = TRUE;
}
#endif // _USE_DIRECTMUSIC

/*
 * `揈
 */
BOOL Paint()
{
	if( !g_pD3D || !g_pD3DDevice )
	{
		return FALSE;
	}

	if( g_main->isCheckActive() )
	{
		if( !g_bActive )
		{
			if( !g_bSuspend )
			{
				g_bSuspend = TRUE;
				g_bSuspendTimer = g_main->suspend();
			}
			if( !g_bSuspendTimer )
			{
				return TRUE;
			}
		}
		else
		{
			if( g_bSuspend )
			{
				g_bSuspend = FALSE;
				g_main->resume();
			}
		}
	}

#ifndef _USE_DIRECTMUSIC
#ifdef _USE_DUPLICATESOUND
	DWORD status;
	for( int i = 0; i < _DUPLICATESOUND_NUM; i++ )
	{
		if( g_dupSound[i] != NULL )
		{
			g_dupSound[i]->GetStatus( &status );
			if( (status & DSBSTATUS_PLAYING) == 0 )
			{
				g_srcSound[i] = NULL;
				g_dupSound[i]->Release();
				g_dupSound[i] = NULL;
			}
		}
	}
#endif // _USE_DUPLICATESOUND
#endif // _USE_DIRECTMUSIC

	// foCX̕
	HRESULT hr;
	if( g_bDeviceLost )
	{
		Sleep( 100 );	// 0.1 b҂

		// foCXԂ̃`FbN
		hr = g_pD3DDevice->TestCooperativeLevel();
		if( FAILED( hr ) )
		{
			if( hr == D3DERR_DEVICELOST )
			{
				return TRUE;	// foCX͂܂Ă
			}

			if( hr != D3DERR_DEVICENOTRESET )
			{
				return FALSE;	// \ʃG[
			}

			// XvCg̏
			g_pD3DXSprite->OnLostDevice();

			// tHg̏
			g_pD3DXFont->OnLostDevice();

			hr = g_pD3DDevice->Reset( &g_D3DPP );	// ݂
			if( FAILED( hr ) )
			{
				if( hr == D3DERR_DEVICELOST )
				{
					return TRUE;	// foCX͂܂Ă
				}

				WRITE_ERR( "foCX̕Ɏs", hr );
				return FALSE;	// foCX̕Ɏs
			}

			// XvCg̏
			g_pD3DXSprite->OnResetDevice();

			// tHg̏
			g_pD3DXFont->OnResetDevice();
		}

		// foCX
		g_bDeviceLost = FALSE;
	}

	if( g_bDraw )
	{
		// V[̃NA
		g_pD3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET, g_backCol, 1.0f, 0 );

		// V[̕`
		if( SUCCEEDED( g_pD3DDevice->BeginScene() ) )
		{
			g_main->paint();
			g_pD3DDevice->EndScene();
		}

		// V[̕\
		hr = g_pD3DDevice->Present( NULL, NULL, NULL, NULL );
		if( hr == D3DERR_DEVICELOST )
		{
			g_bDeviceLost = TRUE;	// foCX̏
		}
		else if( FAILED( hr ) )
		{
			return FALSE;
		}
	}
	else
	{
		g_main->paint();
	}

	return g_bRun;
}

/*
 * EBhE̕ێ
 */
BOOL CALLBACK CollectWindowPlacement( HWND hWnd, LPARAM /*lParam*/ )
{
	if( IsWindowVisible( hWnd ) )
	{
		wl.push_back( window_attr( hWnd, WINDOWPLACEMENT() ) );
		WINDOWPLACEMENT* wp = &wl.back().second;
		wp->length = sizeof(WINDOWPLACEMENT);
		GetWindowPlacement( hWnd, wp );
	}
	return TRUE;
}

/*
 * EBhE̕
 */
BOOL CALLBACK RestoreWindowPlacement( HWND hWnd, LPARAM /*lParam*/ )
{
	for( window_list::iterator p = wl.begin(); p != wl.end(); ++p )
	{
		if( p->first == hWnd )
		{
			SetWindowPlacement( p->first, &p->second );
		}
	}
	return TRUE;
}

/*
 * FPS v
 */
void CALLBACK CountFrame( HWND /*hWnd*/, UINT /*uMsg*/, UINT_PTR /*idEvent*/, DWORD /*dwTime*/ )
{
	g_framePerSecond = g_frame - g_oldFrame;
	g_oldFrame = g_frame;
}

/*
 * C
 */
int WINAPI WinMain( HINSTANCE hInst, HINSTANCE /*hPrevInst*/, LPSTR /*lpCmdLine*/, int /*nCmdShow*/ )
{
	HRESULT hr;

	// EBhE̕ێ
	EnumWindows( CollectWindowPlacement, 0 );

	// AvP[ṼCX^XEnhۑ
	g_hInstance = hInst;

	// AvP[VfBNg̎擾
	char* ptrEnd;
	::GetModuleFileName( NULL, g_appDir, 128 );
	if( (ptrEnd = strrchr( g_appDir, '\\' )) != NULL )
	{
		*ptrEnd = '\0';
	}
	else
	{
		g_appDir[0] = '\0';
	}

	g_main = new _MAIN_CLASS();

	if( g_main->logFile() == NULL )
	{
		g_logFile[0] = '\0';
	}
	else
	{
		strcpy( g_logFile, g_main->logFile() );
		if( g_logFile[0] != '\0' )
		{
			sprintf( g_logFile, "%s\\%s", g_appDir, g_main->logFile() );
			::DeleteFile( g_logFile );
		}
	}

	g_main->writeLog( "N" );

	// COM ̏
	hr = CoInitialize( NULL );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "COM̏Ɏs", hr );
		g_main->writeLog( "f" );
		delete g_main;
		return 0;
	}

	// AvP[VɊւ鏉
	hr = InitApp();
	if( FAILED( hr ) )
	{
		WRITE_ERR( "AvP[VɊւ鏉Ɏs", hr );
		g_main->writeLog( "f" );

		// COM J
		CoUninitialize();

		delete g_main;
		return 0;
	}

	MSG msg;

	hr = InitDXGraphics();	// DirectX Graphics ̏
	if( FAILED( hr ) )
	{
		WRITE_ERR( "DirectX Graphics ̏Ɏs", hr );
		g_main->writeLog( "f" );
		DestroyWindow( g_hWindow );
		msg.wParam = 0;
	}
	else
	{
#ifdef _USE_DIRECTMUSIC
		InitDMusic();	// DirectMusic Ɋւ鏉
#else
		InitDSound();	// DirectSound Ɋւ鏉

#ifdef _USE_DUPLICATESOUND
		for( int i = 0; i < _DUPLICATESOUND_NUM; i++ )
		{
			g_srcSound[i] = NULL;
			g_dupSound[i] = NULL;
		}
#endif // _USE_DUPLICATESOUND
#endif // _USE_DIRECTMUSIC

		// XvCg̏
		g_pD3DXSprite->OnResetDevice();

		// tHg̏
		g_pD3DXFont->OnResetDevice();

		// Q[ŗL̏
		g_main->start();

		// Sleep ̐xグ
		timeBeginPeriod( 1 );

		// FPS vp
		SetTimer( NULL, NULL, 1000, CountFrame );

		// bZ[WE[v
		unsigned long startTime;
		int sleepTime;
		int frameTime;
		do
		{
			if( PeekMessage( &msg, 0, 0, 0, PM_REMOVE ) )
			{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
			else
			{
				for( ; ; )
				{
					startTime = timeGetTime();
					frameTime = 0;

					if( !(g_main->isFullFrame()) )
					{
						g_bDraw = FALSE;

						GetKey();
						if( !Paint() )
						{
							DestroyWindow( g_hWindow );
							break;
						}
						frameTime += g_main->frameTime();

						g_bDraw = TRUE;
					}

					GetKey();
					if( !Paint() )
					{
						DestroyWindow( g_hWindow );
						break;
					}
					frameTime += g_main->frameTime();

					// FPS vp
					g_frame++;

					sleepTime = frameTime - (int)(timeGetTime() - startTime);
					if( sleepTime > 0 )
					{
						Sleep( sleepTime );
					}

					break;
				}
			}
		}
		while( msg.message != WM_QUIT );

		// Sleep ̐xɖ߂
		timeEndPeriod( 1 );

		g_main->writeLog( "I" );
	}

	// EChEENX̓o^
	UnregisterClass( _WNDCLASS_NAME, g_hInstance );

	// COM J
	CoUninitialize();

	if( !(g_main->isWindow()) )
	{
		// EBhE̕
		EnumWindows( RestoreWindowPlacement, 0 );
	}

	delete g_main;

	return msg.wParam;
}

#ifdef _USE_CAPTURE
/*
 * ʃLv`
 */
HRESULT SaveFrontBuffer()
{
	HRESULT hr;

	// ݂̃fBXvC̃tH[}bgȂǂ擾
	D3DDISPLAYMODE dmode;
	hr = g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &dmode );
	if( FAILED( hr ) )
	{
		RETURN_ERR( "݂̃fBXvC̃tH[}bgȂǂ擾s", hr );
	}

	// Lv`pT[tFX쐬
	LPDIRECT3DSURFACE9 pSurface;
	hr = g_pD3DDevice->CreateOffscreenPlainSurface(
		dmode.Width,
		dmode.Height,
		D3DFMT_A8R8G8B8,
		D3DPOOL_SCRATCH, &pSurface, NULL
		);
	if( FAILED( hr ) )
	{
		RETURN_ERR( "Lv`pT[tFX쐬Ɏs", hr );
	}

	// Lv`
	hr = g_pD3DDevice->GetFrontBufferData( 0, pSurface );
	if( FAILED( hr ) )
	{
		pSurface->Release();
		RETURN_ERR( "Lv`s", hr );
	}

	// T[tFX̕ۑ
	RECT rect;
	if( g_D3DPP.Windowed )
	{
		POINT p = { 0, 0 };
		ClientToScreen( g_hWindow, &p );
		rect.left = p.x;
		rect.top  = p.y;
		p.x = g_D3DPP.BackBufferWidth;
		p.y = g_D3DPP.BackBufferHeight;
		ClientToScreen( g_hWindow, &p );
		rect.right  = p.x;
		rect.bottom = p.y;
	}
	char file[MAX_PATH];
	FILE* fp;
	sprintf( file, "%s\\%s", g_appDir, _CAPTURE_DIR );
	CreateDirectory( file, NULL );
	for( int i = 0; ; i++ )
	{
		sprintf( file, "%s\\%s\\%08d.png", g_appDir, _CAPTURE_DIR, i );
		if( (fp = fopen( file, "rb" )) == NULL )
		{
			break;
		}
		fclose( fp );
	}
	hr = D3DXSaveSurfaceToFile(
		file,
		D3DXIFF_PNG/*PNG `*/,
		pSurface,
		NULL,
		g_D3DPP.Windowed ? &rect : NULL
		);
	pSurface->Release();
	if( FAILED( hr ) )
	{
		RETURN_ERR( "T[tFX̕ۑɎs", hr );
	}

	return S_OK;
}
#endif // _USE_CAPTURE

#ifndef _USE_DIRECTMUSIC
BOOL GetWaveInfo( LPBYTE buf, LPBYTE* lpData, DWORD* dataSize, WAVEFORMATEX* wf )
{
	if( *(LPDWORD)buf != *(LPDWORD)"RIFF" ) return FALSE;
	buf += 4;

	DWORD dataLen = *(DWORD*)buf;
	buf += 4;

	if( *(LPDWORD)buf != *(LPDWORD)"WAVE" ) return FALSE;
	buf += 4;

	if( *(LPDWORD)buf != *(LPDWORD)"fmt " ) return FALSE;
	buf += 4;

	DWORD wfLen = *(DWORD*)buf;
	buf += 4;
	*wf = *(WAVEFORMATEX*)buf;
	buf += wfLen;

	if( *(LPDWORD)buf == *(LPDWORD)"fact" )
	{
		buf += 4;
		DWORD len = *(DWORD*)buf;
		buf += 4;
		buf += len;
	}

	if( *(LPDWORD)buf != *(LPDWORD)"data" ) return FALSE;
	buf += 4;

	*dataSize = *(DWORD*)buf;
	buf += 4;

	*lpData = buf;

	return TRUE;
}
#endif // _USE_DIRECTMUSIC

/*
 * TEhf[^\z
 */
BOOL _Main::createSound( _SoundData* sound, _Memory* data, int type )
{
	if( !g_bEnableSound )
	{
writeLog( "TEhf[^\zɎs" );
		return FALSE;
	}

	HRESULT hr;

	_Memory* mem = NULL;
	switch( type )
	{
#ifdef _USE_DIRECTMUSIC
	case _SOUND_MIDI:
#endif // _USE_DIRECTMUSIC
	case _SOUND_WAV:
		mem = new _Memory();
		if( mem->alloc( data->size(), FALSE/*𑼂ɔC*/ ) )
		{
			memcpy( mem->ptr(), data->ptr(), data->size() );
		}
		else
		{
			delete mem;
			mem = NULL;
		}
		break;
#ifdef _USE_MP3
	case _SOUND_MP3:
		mem = MP3ToWAV( data );
		break;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
	case _SOUND_OGGVORBIS:
		// f[^Ή
		break;
#endif // _USE_OGGVORBIS
	}
	if( mem == NULL )
	{
writeLog( "TEhf[^\zɎs" );
		return FALSE;
	}

#ifdef _USE_DIRECTMUSIC
	DMUS_OBJECTDESC objdesc;
	ZeroMemory(&objdesc, sizeof(DMUS_OBJECTDESC));
	objdesc.dwSize      = sizeof(DMUS_OBJECTDESC);
	objdesc.dwValidData = DMUS_OBJ_MEMORY | DMUS_OBJ_CLASS;
	objdesc.guidClass   = CLSID_DirectMusicSegment;
	objdesc.llMemLength = mem->size();
	objdesc.pbMemData   = (LPBYTE)(mem->ptr());
	hr = g_pLoader->GetObject( &objdesc, IID_IDirectMusicSegment8, (LPVOID*)&(sound->sound) );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "Wavet@C̃ZOg̃[hɎs", hr );
		mem->free();	// 
		delete mem;
		return FALSE;
	}

	if( type == _SOUND_MIDI )
	{
		hr = sound->sound->SetParam( GUID_StandardMIDIFile, 0xFFFFFFFF, 0, 0, NULL );
		if( FAILED( hr ) )
		{
			WRITE_ERR( "MIDIZOg̃p[^ݒɎs", hr );
			sound->sound->Unload( g_pPerformance );
			sound->sound->Release();
			sound->sound = NULL;
			delete mem;
			return FALSE;
		}
	}

	hr = sound->sound->Download( g_pPerformance );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "ZOgP̃oh̃_E[hɎs", hr );
		sound->sound->Unload( g_pPerformance );
		sound->sound->Release();
		sound->sound = NULL;
		delete mem;
		return FALSE;
	}
#else
	LPBYTE lpData;
	DWORD dataSize;
	WAVEFORMATEX wf;
	if( !GetWaveInfo( mem->ptr(), &lpData, &dataSize, &wf ) )
	{
writeLog("WAVEtH[}bgG[");
		mem->free();	// 
		delete mem;
		return FALSE;
	}

	DSBUFFERDESC bufdesc;
	ZeroMemory( &bufdesc, sizeof(DSBUFFERDESC) );
	bufdesc.dwSize          = sizeof(DSBUFFERDESC);
	bufdesc.dwFlags         = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCDEFER | DSBCAPS_CTRLVOLUME;
	bufdesc.dwBufferBytes   = dataSize;
	bufdesc.lpwfxFormat     = &wf;

	// ZJ_Eobt@̍쐬
	hr = g_pDSound->CreateSoundBuffer( &bufdesc, &(sound->sound), NULL );
	if( FAILED( hr ) )
	{
		WRITE_ERR( "ZJ_Eobt@̍쐬Ɏs", hr );
		mem->free();	// 
		delete mem;
		return FALSE;
	}

	// obt@bNĉf[^
	LPVOID lockBuf;
	DWORD lockLength;
	hr = sound->sound->Lock( 0, 0, &lockBuf, &lockLength, NULL, NULL, DSBLOCK_ENTIREBUFFER );
	if( hr == DSERR_BUFFERLOST )
	{
		// DSERR_BUFFERLOST ԂꂽꍇAobt@𕜌
		sound->sound->Restore();
		hr = sound->sound->Lock( 0, 0, &lockBuf, &lockLength, NULL, NULL, DSBLOCK_ENTIREBUFFER );
	}
	if( SUCCEEDED( hr ) )
	{
		memcpy( lockBuf, lpData, dataSize );
		sound->sound->Unlock( lockBuf, lockLength, NULL, 0 );
	}
#endif // _USE_DIRECTMUSIC

	sound->data = mem;
	return TRUE;
}
BOOL _Main::createSound( _SoundData* sound, char* file, int type )
{
	if( !g_bEnableSound )
	{
writeLog( "TEhf[^\zɎs" );
		return FALSE;
	}

	_Memory* mem = NULL;

	switch( type )
	{
#ifdef _USE_DIRECTMUSIC
	case _SOUND_MIDI:
#endif // _USE_DIRECTMUSIC
	case _SOUND_WAV:
#ifdef _USE_MP3
	case _SOUND_MP3:
#endif // _USE_MP3
		{
			_Memory* data = NULL;

			// t@CeɎ荞
			HANDLE hFile;
			hFile = ::CreateFile(
				(LPCTSTR)file,
				GENERIC_READ,
				FILE_SHARE_READ,
				NULL,
				OPEN_EXISTING,
				NULL,
				NULL
				);
			if( hFile != INVALID_HANDLE_VALUE )
			{
				DWORD tmp;
				data = new _Memory();
				if( data->alloc( ::GetFileSize( hFile, NULL ) ) )
				{
					::ReadFile( hFile, data->ptr(), data->size(), &tmp, NULL );
				}
				else
				{
					delete data;
					data = NULL;
				}
				::CloseHandle( hFile );
			}

			if( data )
			{
				createSound( sound, data, type );
				mem = sound->data;
				delete data;
			}
		}
		break;
#ifdef _USE_OGGVORBIS
	case _SOUND_OGGVORBIS:
		if( (mem = OggVorbisToWAV( file, 2 )) != NULL )
		{
			HRESULT hr;

#ifdef _USE_DIRECTMUSIC
			DMUS_OBJECTDESC objdesc;
			ZeroMemory(&objdesc, sizeof(DMUS_OBJECTDESC));
			objdesc.dwSize      = sizeof(DMUS_OBJECTDESC);
			objdesc.dwValidData = DMUS_OBJ_MEMORY | DMUS_OBJ_CLASS;
			objdesc.guidClass   = CLSID_DirectMusicSegment;
			objdesc.llMemLength = mem->size();
			objdesc.pbMemData   = (LPBYTE)(mem->ptr());
			hr = g_pLoader->GetObject( &objdesc, IID_IDirectMusicSegment8, (LPVOID*)&(sound->sound) );
			if( FAILED( hr ) )
			{
				WRITE_ERR( "Wavet@C̃ZOg̃[hɎs", hr );
				mem->free();	// 
				delete mem;
				return FALSE;
			}

			hr = sound->sound->Download( g_pPerformance );
			if( FAILED( hr ) )
			{
				WRITE_ERR( "ZOgP̃oh̃_E[hɎs", hr );
				sound->sound->Unload( g_pPerformance );
				sound->sound->Release();
				sound->sound = NULL;
				delete mem;
				return FALSE;
			}
#else
			LPBYTE lpData;
			DWORD dataSize;
			WAVEFORMATEX wf;
			if( !GetWaveInfo( mem->ptr(), &lpData, &dataSize, &wf ) )
			{
writeLog( "WAVEtH[}bgG[" );
				mem->free();	// 
				delete mem;
				return FALSE;
			}

			DSBUFFERDESC bufdesc;
			ZeroMemory( &bufdesc, sizeof(DSBUFFERDESC) );
			bufdesc.dwSize          = sizeof(DSBUFFERDESC);
			bufdesc.dwFlags         = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCDEFER | DSBCAPS_CTRLVOLUME;
			bufdesc.dwBufferBytes   = dataSize;
			bufdesc.lpwfxFormat     = &wf;

			// ZJ_Eobt@̍쐬
			hr = g_pDSound->CreateSoundBuffer( &bufdesc, &(sound->sound), NULL );
			if( FAILED( hr ) )
			{
				WRITE_ERR( "ZJ_Eobt@̍쐬Ɏs", hr );
				mem->free();	// 
				delete mem;
				return FALSE;
			}

			// obt@bNĉf[^
			LPVOID lockBuf;
			DWORD lockLength;
			hr = sound->sound->Lock( 0, 0, &lockBuf, &lockLength, NULL, NULL, DSBLOCK_ENTIREBUFFER );
			if( hr == DSERR_BUFFERLOST )
			{
				// DSERR_BUFFERLOST ԂꂽꍇAobt@𕜌
				sound->sound->Restore();
				hr = sound->sound->Lock( 0, 0, &lockBuf, &lockLength, NULL, NULL, DSBLOCK_ENTIREBUFFER );
			}
			if( SUCCEEDED( hr ) )
			{
				memcpy( lockBuf, lpData, dataSize );
				sound->sound->Unlock( lockBuf, lockLength, NULL, 0 );
			}
#endif // _USE_DIRECTMUSIC
		}
		break;
#endif // _USE_OGGVORBIS
	}
	if( mem == NULL )
	{
writeLog("TEhf[^\zɎs");
		return FALSE;
	}

	sound->data = mem;
	return TRUE;
}

/*
 * TEhf[^j
 */
void _Main::disposeSound( _SoundData* sound )
{
	sound->Dispose();
}

/*
 * BGM Đ
 */
void _Main::PlayMusic( BOOL loop )
{
	if( !g_bEnableSound || !(g_curSound.isEnabled()) ) return;
#ifdef _USE_DIRECTMUSIC
	if( loop )
	{
		g_curSound.sound->SetLoopPoints( 0, 0 );
		g_curSound.sound->SetRepeats( DMUS_SEG_REPEAT_INFINITE );
	}
	g_pAudioPath->SetVolume( g_volumeMusic, 0 );
	g_pPerformance->PlaySegmentEx(
		g_curSound.sound,
		NULL,
		NULL,
		0/*݂̍Đ𒆒fčĐJn*/,
		0/*ł邾ĐJn*/,
		NULL/*ZOgԃIuWFNgsv*/,
		NULL/*ĐJnɒ~IuWFNgȂ*/,
		g_pAudioPath
		);
#else
	g_curSound.sound->SetVolume( g_volumeMusic );
	g_curSound.sound->SetCurrentPosition( 0 );
	HRESULT hr;
	hr = g_curSound.sound->Play( 0, 0, loop ? DSBPLAY_LOOPING : 0 );
	if( hr == DSERR_BUFFERLOST )
	{
		g_curSound.sound->Restore();
	}
#endif // _USE_DIRECTMUSIC
}
void _Main::playMusic( _Memory* data, int type, BOOL loop )
{
	if( !g_bEnableSound ) return;
	stopMusic();
	createSound( &g_curSound, data, type );
	PlayMusic( loop );
}
void _Main::playMusic( char* file, int type, BOOL loop )
{
	if( !g_bEnableSound ) return;
	stopMusic();
	createSound( &g_curSound, file, type );
	PlayMusic( loop );
}
void _Main::playMusic( _SoundData* sound, BOOL loop )
{
	if( !g_bEnableSound ) return;
	stopMusic();
	g_curSound.attach( sound->sound );
	PlayMusic( loop );
}

/*
 * BGM ~
 */
void _Main::stopMusic()
{
	if( !g_bEnableSound || !(g_curSound.isEnabled()) ) return;
#ifdef _USE_DIRECTMUSIC
	g_pPerformance->StopEx( g_curSound.sound, 0, 0 );
#else
	g_curSound.sound->Stop();
#endif // _USE_DIRECTMUSIC
	disposeSound( &g_curSound );
}

/*
 * BGM ̃{[ݒ肷
 */
void _Main::setVolumeMusic( int volume )
{
	if( !g_bEnableSound ) return;
	volume = volume * g_main->volumeMusic() / 100;
	if( volume == 0 )
	{
		g_volumeMusic = DSBVOLUME_MIN;
	}
	else if( volume == 100 )
	{
		g_volumeMusic = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeMusic = g_minVolume + (g_maxVolume - g_minVolume) * volume / 100;
	}
#ifdef _USE_DIRECTMUSIC
	g_pAudioPath->SetVolume( g_volumeMusic, 0 );
#else
	if( g_curSound.isEnabled() )
	{
		g_curSound.sound->SetVolume( g_volumeMusic );
	}
#endif // _USE_DIRECTMUSIC
}

/*
 * SE ̃{[ݒ肷
 */
void _Main::setVolumeSound( int volume )
{
	if( !g_bEnableSound ) return;
	volume = volume * g_main->volumeSound() / 100;
	if( volume == 0 )
	{
		g_volumeSound = DSBVOLUME_MIN;
	}
	else if( volume == 100 )
	{
		g_volumeSound = DSBVOLUME_MAX;
	}
	else
	{
		g_volumeSound = g_minVolume + (g_maxVolume - g_minVolume) * volume / 100;
	}
}

/*
 * SE Đ
 */
void _Main::playSound( _SoundData* sound )
{
	if( !g_bEnableSound || !(sound->isEnabled()) ) return;
#ifdef _USE_DIRECTMUSIC
	g_pDefAudioPath->SetVolume( g_volumeSound, 0 );
	g_pPerformance->PlaySegmentEx(
		sound->sound,
		NULL,
		NULL,
		DMUS_SEGF_SECONDARY/*ZJ_EZOgƂčĐ*/,
		0/*ł邾ĐJn*/,
		NULL/*ZOgԃIuWFNgsv*/,
		NULL/*ĐJnɒ~IuWFNgȂ*/,
		NULL/*ftHg̃I[fBIEpXg*/
		);
#else
#ifdef _USE_DUPLICATESOUND
	int i;
	for( i = 0; i < _DUPLICATESOUND_NUM; i++ )
	{
		if( g_dupSound[i] == NULL )
		{
			g_soundIndex = i;

			g_srcSound[g_soundIndex] = sound->sound;
			g_pDSound->DuplicateSoundBuffer( g_srcSound[g_soundIndex], &g_dupSound[g_soundIndex] );
			g_dupSound[g_soundIndex]->SetVolume( g_volumeSound );
			g_dupSound[g_soundIndex]->SetCurrentPosition( 0 );
			g_dupSound[g_soundIndex]->Play( 0, 0, 0 );

			break;
		}
	}
	if( i >= _DUPLICATESOUND_NUM )
	{
		g_soundIndex++;
		if( g_soundIndex >= _DUPLICATESOUND_NUM )
		{
			g_soundIndex = 0;
		}
		g_dupSound[g_soundIndex]->Stop();
		g_dupSound[g_soundIndex]->Release();

		g_srcSound[g_soundIndex] = sound->sound;
		g_pDSound->DuplicateSoundBuffer( g_srcSound[g_soundIndex], &g_dupSound[g_soundIndex] );
		g_dupSound[g_soundIndex]->SetVolume( g_volumeSound );
		g_dupSound[g_soundIndex]->SetCurrentPosition( 0 );
		g_dupSound[g_soundIndex]->Play( 0, 0, 0 );
	}
#else
	sound->sound->SetVolume( g_volumeSound );
	sound->sound->SetCurrentPosition( 0 );
	sound->sound->Play( 0, 0, 0 );
#endif // _USE_DUPLICATESOUND
#endif // _USE_DIRECTMUSIC
}

/*
 * SE ~
 */
void _Main::stopSound( _SoundData* sound )
{
	if( !g_bEnableSound || !(sound->isEnabled()) ) return;
#ifdef _USE_DIRECTMUSIC
	g_pPerformance->StopEx( sound->sound, 0, 0 );
#else
#ifdef _USE_DUPLICATESOUND
	for( int i = 0; i < _DUPLICATESOUND_NUM; i++ )
	{
		if( g_srcSound[i] == sound->sound )
		{
			g_srcSound[i] = NULL;
			g_dupSound[i]->Stop();
			g_dupSound[i]->Release();
			g_dupSound[i] = NULL;
		}
	}
#else
	sound->sound->Stop();
#endif // _USE_DUPLICATESOUND
#endif // _USE_DIRECTMUSIC
}
