/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include <windows.h>

#include "_Memory.hpp"

_Memory::_Memory()
{
	_ptr = NULL;
	_free = TRUE;
}

_Memory::~_Memory()
{
	if( _free ) free();
}

BOOL _Memory::alloc( unsigned long size, BOOL free )
{
	this->free();
	_size = size;
	_free = free;
	if( (_ptr = (BYTE*)GlobalAlloc( GMEM_FIXED, _size )) == NULL )
	{
		return FALSE;
	}
	return TRUE;
}

void _Memory::free()
{
	if( _ptr )
	{
		GlobalFree( _ptr );
		_ptr = NULL;
	}
}
