/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "GlobalDef.h"
#ifdef _USE_OGGVORBIS

#include <windows.h>

#include <math.h>
#include <memory.h>
#include <stdio.h>

#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>

#include "_Memory.hpp"

// Wave t@C̃wb_
typedef struct {
	char			cRIFF[4];
	int				iSizeRIFF;
	char			cType[4];
	char			cFmt[4];
	int				iSizeFmt;
	WAVEFORMATEX	WaveFmt;
	char			cData[4];
	int				iSizeData;
} WAVEEXFILEHEADER;

/*
 * OggVorbis  Wave ֕ϊ
 */
_Memory* OggVorbisToWAV( LPCSTR szName, INT iWord )
{
	_Memory* pWaveData = NULL;

	// ʎqoCg 1(8bit)  2(16bit)
	if( !(iWord == 1 || iWord == 2) ) return NULL;

	// t@CJ
	FILE* pFile = fopen( szName, "rb" );
	if( pFile == NULL ) return NULL;

	// OggVorbis ̃t@C擾
	OggVorbis_File vf;
	if( ov_open( pFile, &vf, NULL, 0 ) < 0 )
	{
		fclose( pFile );
		return NULL;
	}

	// OggVorbis ̏擾
	vorbis_info* vi = ov_info( &vf, -1 );
	if( vi == NULL )
	{
		ov_clear( &vf );
		return NULL;
	}

	// wb_TCY擾
	WAVEEXFILEHEADER wh;
	LONG lWHSize =
		sizeof(wh.cRIFF) + sizeof(wh.iSizeRIFF) + sizeof(wh.cType  ) +
		sizeof(wh.cFmt ) + sizeof(wh.iSizeFmt ) + sizeof(wh.WaveFmt) +
		sizeof(wh.cData) + sizeof(wh.iSizeData);

	// fR[h̃f[^TCY߁Am
	LONG lDataSize = (LONG)ceil( vi->channels * vi->rate * ov_time_total( &vf, -1 ) * iWord );
	pWaveData = new _Memory();
	if( !(pWaveData->alloc( lDataSize + lWHSize, FALSE/*𑼂ɔC*/ )) )
	{
		delete pWaveData;
		ov_clear( &vf );
		return NULL;
	}

	// OggVorbis  Wave փfR[h
	INT iCurrentSection;
	LONG lWriteSize;
	LONG lReadSize = 0;
	for( ; ; )
	{
		// fR[h
		lWriteSize = ov_read( &vf, (char*)(pWaveData->ptr() + lReadSize + lWHSize), lDataSize - lReadSize, 0, iWord, 1, &iCurrentSection );

		// I
		if( !lWriteSize )
		{
			break;
		}
		else if( lWriteSize < 0 )
		{
			pWaveData->free();	// 
			delete pWaveData;
			ov_clear( &vf );
			return NULL;
		}

		// SăfR[hłȂ
		lReadSize += lWriteSize;
	}

	// wb_̏
	memcpy( wh.cRIFF, "RIFF", 4 );
	wh.iSizeRIFF = lWHSize + lReadSize - 8;
	memcpy( wh.cType, "WAVE", 4 );
	memcpy( wh.cFmt , "fmt ", 4 );
	wh.iSizeFmt = sizeof(WAVEFORMATEX);
	wh.WaveFmt.cbSize          = sizeof(WAVEFORMATEX);
	wh.WaveFmt.wFormatTag      = WAVE_FORMAT_PCM;
	wh.WaveFmt.nChannels       = vi->channels;
	wh.WaveFmt.nSamplesPerSec  = vi->rate;
	wh.WaveFmt.nAvgBytesPerSec = vi->rate * vi->channels * iWord;
	wh.WaveFmt.nBlockAlign     = vi->channels * iWord;
	wh.WaveFmt.wBitsPerSample  = iWord * 8;
	memcpy( wh.cData, "data", 4 );
	wh.iSizeData = lReadSize;

	// ̃wb_֏
	INT iSize = 0;
	memcpy( pWaveData->ptr(),         &wh.cRIFF,     sizeof(wh.cRIFF    ) ); iSize += sizeof(wh.cRIFF    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeRIFF, sizeof(wh.iSizeRIFF) ); iSize += sizeof(wh.iSizeRIFF);
	memcpy( pWaveData->ptr() + iSize, &wh.cType,     sizeof(wh.cType    ) ); iSize += sizeof(wh.cType    );
	memcpy( pWaveData->ptr() + iSize, &wh.cFmt,      sizeof(wh.cFmt     ) ); iSize += sizeof(wh.cFmt     );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeFmt,  sizeof(wh.iSizeFmt ) ); iSize += sizeof(wh.iSizeFmt );
	memcpy( pWaveData->ptr() + iSize, &wh.WaveFmt,   sizeof(wh.WaveFmt  ) ); iSize += sizeof(wh.WaveFmt  );
	memcpy( pWaveData->ptr() + iSize, &wh.cData,     sizeof(wh.cData    ) ); iSize += sizeof(wh.cData    );
	memcpy( pWaveData->ptr() + iSize, &wh.iSizeData, sizeof(wh.iSizeData) );

	// I
	ov_clear( &vf );

	return pWaveData;
}

#endif // _USE_OGGVORBIS
