/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include <windows.h>

#include <stdio.h>
#include <string.h>

#include "_String.hpp"

_String::_String( const char* str )
{
	int len = strlen( str );
	_str = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( _str, str, len );
	_str[len] = '\0';
}
_String::_String( const char* str, int beginIndex, int endIndex )
{
	int len = endIndex - beginIndex;
	_str = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( _str, &str[beginIndex], len );
	_str[len] = '\0';
}
_String::_String( _String* str )
{
	int len = strlen( str->_str );
	_str = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( _str, str->_str, len );
	_str[len] = '\0';
}
_String::_String( int val )
{
	_str = (char*)GlobalAlloc( GMEM_FIXED, 1 );
	_str[0] = '\0';
	add( val );
}

_String::~_String()
{
	GlobalFree( _str );
}

void _String::set( const char* str )
{
	GlobalFree( _str );
	int len = strlen( str );
	_str = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( _str, str, len );
	_str[len] = '\0';
}
void _String::set( const char* str, int beginIndex, int endIndex )
{
	GlobalFree( _str );
	int len = endIndex - beginIndex;
	_str = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( _str, &str[beginIndex], len );
	_str[len] = '\0';
}
void _String::set( _String* str )
{
	set( str->_str );
}
void _String::set( int val )
{
	char tmp[32];
	sprintf( tmp, "%d", val );
	set( tmp );
}

void _String::add( const char* str )
{
	char* tmp = (char*)GlobalAlloc( GMEM_FIXED, strlen( _str ) + strlen( str ) + 1 );
	strcpy( tmp, _str );
	strcat( tmp, str );
	GlobalFree( _str );
	_str = tmp;
}
void _String::add( const char* str, int beginIndex, int endIndex )
{
	int len = endIndex - beginIndex;
	char* tmp = (char*)GlobalAlloc( GMEM_FIXED, len + 1 );
	memcpy( tmp, &str[beginIndex], len );
	tmp[len] = '\0';
	add( tmp );
	GlobalFree( tmp );
}
void _String::add( _String* str )
{
	add( str->_str );
}
void _String::add( int val )
{
	char tmp[32];
	sprintf( tmp, "%d", val );
	add( tmp );
}

int _String::length()
{
	return strlen( _str );
}

BOOL _String::equals( const char* str )
{
	return (strcmp( _str, str ) == 0) ? TRUE : FALSE;
}
BOOL _String::equals( _String* str )
{
	return equals( str->_str );
}

int _String::parseInt()
{
	if( _str[0] == '-' )
	{
		return 0 - strtoul( &_str[1], NULL, 10 );
	}
	return strtoul( _str, NULL, 10 );
}
