/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include <stdlib.h>
#include <string.h>

#include "_String.hpp"

#include "StreamReader.hpp"

StreamReader::StreamReader(char* in) {
	data_size = strlen(in);
	data = (unsigned char*)GlobalAlloc(GMEM_FIXED, data_size + 1);
	strcpy((char*)data, in);
	data_index = 0;
}

StreamReader::~StreamReader() {
	GlobalFree(data);
}

int StreamReader::read_chr() {
	if ( data_index >= data_size ) {
		return -1;
	}
	int chr = data[data_index];
	data_index++;
	return chr;
}

_String* StreamReader::read() {
	int word_index = 0;
	int chr = 0;

	// ݈ʒuɉsR[h̏ꍇɓǂݔ΂
	for ( ; ; ) {
		chr = read_chr();
		if ( chr <= 0 ) break;
		if ( (chr != '\r') && (chr != '\n') ) {
			if ( chr != ' ' ) {
				word[word_index] = (char)chr;
				word_index++;
			}
			break;
		}
	}
	if ( chr != ',' ) {
		for ( ; ; ) {
			chr = read_chr();
			if ( (chr <= 0) || (chr == ',') || (chr == '\r') || (chr == '\n') ) break;
			if ( chr != ' ' ) {
				word[word_index] = (char)chr;
				word_index++;
			}
		}
	}
	_String* str = new _String((char*)word, 0, word_index);
	return str;
}

int StreamReader::read_val() {
	int val;
	_String* str = read();
	val = str->parseInt();
	delete str;
	return val;
}
