/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#ifndef SYSTEM_HPP
#define SYSTEM_HPP

#include <windows.h>

#include <stdio.h>
#include <string.h>

struct SystemData {
	BOOL bWindow;
	BOOL bFullFrame;
	BOOL bCheckActive;
	BOOL bShowFPS;
	BOOL bWriteLog;
	int volumeMusic;
	int volumeSound;
	char name[11];
	int button[6];
};

class MySystem {
private:
	char szDir[MAX_PATH];

public:
	/**
	 * RXgN^
	 */
	MySystem(char* dir) {
		strcpy(szDir, dir);
	}

	/**
	 * ݒ̓ǂݍ
	 */
	void load(SystemData* data) {
		// ftHgl
		data->bWindow      = TRUE;
		data->bFullFrame   = TRUE;
		data->bCheckActive = TRUE;
		data->bShowFPS     = FALSE;
		data->bWriteLog    = TRUE;
		data->volumeMusic  = 100;
		data->volumeSound  = 85;
		memset(data->name, '\0', 11);
		data->button[0] = 0;
		data->button[1] = 1;
		data->button[2] = 2;
		data->button[3] = 3;
		data->button[4] = 4;
		data->button[5] = 5;

		int i;
		char file[MAX_PATH];
		sprintf(file, "%s\\system.ini", szDir);
		int tmp;
		char tmp2[11];

		::GetPrivateProfileString("SYSTEM", "Window", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->bWindow = (tmp == 1) ? TRUE : FALSE;
		}

		::GetPrivateProfileString("SYSTEM", "FullFrame", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->bFullFrame = (tmp == 1) ? TRUE : FALSE;
		}

		::GetPrivateProfileString("SYSTEM", "CheckActive", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->bCheckActive = (tmp == 1) ? TRUE : FALSE;
		}

		::GetPrivateProfileString("SYSTEM", "ShowFPS", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->bShowFPS = (tmp == 1) ? TRUE : FALSE;
		}

		::GetPrivateProfileString("SYSTEM", "WriteLog", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->bWriteLog = (tmp == 1) ? TRUE : FALSE;
		}

		::GetPrivateProfileString("SYSTEM", "VolumeMusic", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->volumeMusic = tmp;
		}

		::GetPrivateProfileString("SYSTEM", "VolumeSound", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			tmp = atol(tmp2);
			data->volumeSound = tmp;
		}

		::GetPrivateProfileString("SYSTEM", "Name", "", tmp2, 10, file);
		if ( strlen(tmp2) > 0 ) {
			memcpy(data->name, tmp2, 10);
			data->name[10] = '\0';
		}

		char key[8];
		for ( i = 0; i < 6; i++ ) {
			sprintf(key, "Button%d", i + 1);
			::GetPrivateProfileString("SYSTEM", key, "", tmp2, 10, file);
			if ( strlen(tmp2) > 0 ) {
				tmp = atol(tmp2) - 1;
				data->button[i] = tmp;
			}
		}
	}
};

#endif // SYSTEM_HPP
