/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include <io.h>
#include <stdio.h>

#include "_Global.h"

#include "_String.hpp"

#include "Main.hpp"

Main::Main() {
	MySystem* sys = new MySystem(g_appDir);
	sys->load(&sys_data);
	delete sys;

	for ( int i = 0; i < 4; i++ ) {
		switch ( sys_data.button[i] ) {
		case  0: button[i] = _KEY_BUTTON1 ; break;
		case  1: button[i] = _KEY_BUTTON2 ; break;
		case  2: button[i] = _KEY_BUTTON3 ; break;
		case  3: button[i] = _KEY_BUTTON4 ; break;
		case  4: button[i] = _KEY_BUTTON5 ; break;
		case  5: button[i] = _KEY_BUTTON6 ; break;
		case  6: button[i] = _KEY_BUTTON7 ; break;
		case  7: button[i] = _KEY_BUTTON8 ; break;
		case  8: button[i] = _KEY_BUTTON9 ; break;
		case  9: button[i] = _KEY_BUTTON10; break;
		case 10: button[i] = _KEY_BUTTON11; break;
		case 11: button[i] = _KEY_BUTTON12; break;
		case 12: button[i] = _KEY_BUTTON13; break;
		}
	}

	setKey(button[0], button[1], button[2], 0);
}

void Main::start() {
	int i;

	lock_dispose_image = FALSE;

	pak_data = NULL;

	g = getGraphics();

	_rand = new _Random();
	stage = new Stage();
	wave = new Wave();

	speeder[0] = new Speeder();
	speeder[1] = new Speeder();
	speeder[2] = new Speeder();

	COLOR_C = g->getColorOfRGB(  0, 255, 255);
	COLOR_M = g->getColorOfRGB(255,   0, 255);
	COLOR_Y = g->getColorOfRGB(255, 255,   0);
	COLOR_K = g->getColorOfRGB(  0,   0,   0);
	COLOR_W = g->getColorOfRGB(255, 255, 255);

	setBackColor(COLOR_K);

	launch_step = 0;

	state = STATE_LAUNCH;
	pause = FALSE;

	set_state(STATE_LAUNCH);
}

void Main::destroy() {
writeLog("I");
	if ( pak_data ) {
		GlobalFree(pak_data);
	}

	delete _rand;
	delete stage;
	delete wave;

	delete speeder[0];
	delete speeder[1];
	delete speeder[2];

	lock_dispose_image = FALSE;
	dispose_image();

	dispose_music();
	dispose_sound();
writeLog("I܂");
}

BOOL Main::suspend() {
	return FALSE;
}

void Main::resume() {
}

void Main::paint() {
	UINT key = getKeypadState();

	int i;

	switch ( state ) {
	case STATE_LAUNCH:
		g->setColor(COLOR_W);
		g->drawString("[h...", 5, 20);
		g->drawString("[h...", 6, 20);
		if ( launch_step == 0 ) {
			if ( _elapse > 0 ) {
				launch_step++;
			}
			break;
		} else if ( launch_step == 1 ) {
			// ɋ󂫂ꍇApbNf[^Ɏ荞ł܂
			_String* file = new _String("");
			file->set(g_appDir);
			file->add("\\data.pak");
			HANDLE hFile;
			hFile = ::CreateFile(
				(LPCTSTR)file->str(),
				GENERIC_READ,
				FILE_SHARE_READ,
				NULL,
				OPEN_EXISTING,
				NULL,
				NULL
				);
			if ( hFile != INVALID_HANDLE_VALUE ) {
				DWORD tmp;
				DWORD size = ::GetFileSize(hFile, NULL);
				if ( (pak_data = (unsigned char*)GlobalAlloc(GMEM_FIXED, size)) != NULL ) {
					::ReadFile(hFile, pak_data, size, &tmp, NULL);
writeLog("pbNf[^Ɏ荞݂܂");
				}
				::CloseHandle(hFile);
			}
			delete file;
#ifdef _DEBUG
			{
				char file[MAX_PATH];
				FILE* fp;
				sprintf(file, "%s\\debug", g_appDir);
				CreateDirectory(file, NULL);
				_Memory* data;
				for ( i = 0; i < DATA_NUM; i++ ) {
					data = read_data(i);
					sprintf(file, "%s\\debug\\%d", g_appDir, i);
					if ( (fp = fopen(file, "w+b")) != NULL ) {
						fwrite(data->ptr(), 1, data->size(), fp);
						fflush(fp);
						fclose(fp);
					}
					delete data;
				}
			}
#endif // _DEBUG
			launch_step++;
			break;
		} else if ( launch_step == 2 ) {
			BOOL lock = TRUE;
			for ( i = 0; i < IMAGE_NUM; i++ ) {
				if ( use_image(i) == NULL ) {
					lock = FALSE;
				}
			}
			lock_dispose_image = lock;
			dispose_image();
			launch_step++;
			break;
		} else if ( launch_step == 3 ) {
			for ( i = 0; i < SE_NUM; i++ ) {
				use_sound(i);
			}
			for ( i = 0; i < BGM_NUM; i++ ) {
				if ( !create_music(i) ) {
					dispose_music();
					break;
				}
			}
			launch_step++;
			break;
		} else if ( launch_step == 4 ) {
			load_config();
			launch_step++;
			break;
		}
writeLog("N܂");
		set_state(STATE_TITLE);
		// ̂܂܉ɗ
	case STATE_TITLE:
	case STATE_TITLE_LOADING:
		// `
		{
			int x;

			g->setROP(_ROP_ADD);

			g->drawImage(use_image(DATA_LOGO), 0, 0);

			x = (640 - (TEXT_NEUTRAL_W + 16 + TEXT_OFF_W)) / 2;
			g->drawImage(use_image(DATA_TITLE), x, 230, TEXT_NEUTRAL_X, TEXT_NEUTRAL_Y, TEXT_NEUTRAL_W, TEXT_NEUTRAL_H); x += (TEXT_NEUTRAL_W + 16);
			if ( neutral ) {
				g->drawImage(use_image(DATA_TITLE), x, 230, TEXT_ON_X, TEXT_ON_Y, TEXT_ON_W, TEXT_ON_H);
			} else {
				g->drawImage(use_image(DATA_TITLE), x, 230, TEXT_OFF_X, TEXT_OFF_Y, TEXT_OFF_W, TEXT_OFF_H);
			}

			if ( ((_elapse / 5) % 4) < 2 ) {
				g->drawImage(use_image(DATA_TITLE), 310, 286, 282, 0, 18, 10);
				g->drawImage(use_image(DATA_TITLE), 310, 332, 282, 10, 18, 10);
			}
			switch ( level ) {
			case 0:
				x = (640 - (TEXT_RACE_W + 16 + TEXT_EASY_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_RACE_X, TEXT_RACE_Y, TEXT_RACE_W, TEXT_RACE_H); x += (TEXT_RACE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_EASY_X, TEXT_EASY_Y, TEXT_EASY_W, TEXT_EASY_H);
				break;
			case 1:
				x = (640 - (TEXT_RACE_W + 16 + TEXT_HARD_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_RACE_X, TEXT_RACE_Y, TEXT_RACE_W, TEXT_RACE_H); x += (TEXT_RACE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_HARD_X, TEXT_HARD_Y, TEXT_HARD_W, TEXT_HARD_H);
				break;
			case 2:
				x = (640 - (TEXT_FREE_W + 16 + TEXT_EASY_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_FREE_X, TEXT_FREE_Y, TEXT_FREE_W, TEXT_FREE_H); x += (TEXT_FREE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_EASY_X, TEXT_EASY_Y, TEXT_EASY_W, TEXT_EASY_H);
				break;
			case 3:
				x = (640 - (TEXT_FREE_W + 16 + TEXT_HARD_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_FREE_X, TEXT_FREE_Y, TEXT_FREE_W, TEXT_FREE_H); x += (TEXT_FREE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_HARD_X, TEXT_HARD_Y, TEXT_HARD_W, TEXT_HARD_H);
				break;
			case 4:
				x = (640 - (TEXT_TRAINING_W + 16 + TEXT_1_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_TRAINING_X, TEXT_TRAINING_Y, TEXT_TRAINING_W, TEXT_TRAINING_H); x += (TEXT_TRAINING_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_1_X, TEXT_1_Y, TEXT_1_W, TEXT_1_H);
				break;
			case 5:
				x = (640 - (TEXT_TRAINING_W + 16 + TEXT_2_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_TRAINING_X, TEXT_TRAINING_Y, TEXT_TRAINING_W, TEXT_TRAINING_H); x += (TEXT_TRAINING_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_2_X, TEXT_2_Y, TEXT_2_W, TEXT_2_H);
				break;
			case 6:
				x = (640 - (TEXT_OMAKE_W + 16 + TEXT_1_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_OMAKE_X, TEXT_OMAKE_Y, TEXT_OMAKE_W, TEXT_OMAKE_H); x += (TEXT_OMAKE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_1_X, TEXT_1_Y, TEXT_1_W, TEXT_1_H);
				break;
			case 7:
				x = (640 - (TEXT_OMAKE_W + 16 + TEXT_2_W)) / 2;
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_OMAKE_X, TEXT_OMAKE_Y, TEXT_OMAKE_W, TEXT_OMAKE_H); x += (TEXT_OMAKE_W + 16);
				g->drawImage(use_image(DATA_TITLE), x, 304, TEXT_2_X, TEXT_2_Y, TEXT_2_W, TEXT_2_H);
				break;
			}

			if ( level != 6 ) {
				g->drawImage(use_image(DATA_TITLE), (640 - TEXT_BESTTIME_W) / 2, 358, TEXT_BESTTIME_X, TEXT_BESTTIME_Y, TEXT_BESTTIME_W, TEXT_BESTTIME_H);
				if ( best_time[index_b()][0] == 99999 ) {
					g->drawImage(use_image(DATA_TITLE), 272, 390, 240, 0, 24, 24);
					g->drawImage(use_image(DATA_TITLE), 296, 390, 240, 0, 24, 24);
					g->drawImage(use_image(DATA_TITLE), 320, 390, 240, 0, 24, 24);
					g->drawImage(use_image(DATA_TITLE), 344, 390, 240, 0, 24, 24);
				} else {
					x = 272 + 24 * 3;
					int tmp = best_time[index_b()][0] / 4;
					for ( i = 0; i < 4; i++ ) {
						g->drawImage(use_image(DATA_TITLE), x, 390, (tmp % 10) * 24, 0, 24, 24);
						tmp /= 10;
						x -= 24;
					}
				}
			} else {
				g->drawImage(use_image(DATA_TITLE), (640 - TEXT_DISTANCE_W) / 2, 358, TEXT_DISTANCE_X, TEXT_DISTANCE_Y, TEXT_DISTANCE_W, TEXT_DISTANCE_H);
				i = 0;
				int tmp = best_distance / 5;
				for ( ; ; ) {
					i++;
					tmp /= 10;
					if ( tmp == 0 ) {
						break;
					}
				}
				x = 640 - ((640 - (24 * i)) / 2);
				tmp = best_distance / 5;
				for ( ; ; ) {
					x -= 24;
					g->drawImage(use_image(DATA_TITLE), x, 390, (tmp % 10) * 24, 0, 24, 24);
					tmp /= 10;
					if ( tmp == 0 ) {
						break;
					}
				}
			}

			g->drawImage(use_image(DATA_TITLE), (640 - TEXT_COPYRIGHT_W) / 2, 450, TEXT_COPYRIGHT_X, TEXT_COPYRIGHT_Y, TEXT_COPYRIGHT_W, TEXT_COPYRIGHT_H);

			g->setROP(_ROP_COPY);

			g->setColor(COLOR_K);
			g->rightDrawString(VERSION, 4, 21);
			g->rightDrawString(VERSION, 5, 21);
			g->rightDrawString(VERSION, 6, 21);
			g->setColor(COLOR_W);
			g->rightDrawString(VERSION, 5, 20);
			g->rightDrawString(VERSION, 6, 20);
		}

		if ( state == STATE_TITLE_LOADING ) {
			if ( (level < 2) || (level == 7) ) {
				set_state(STATE_SELECT);
			} else {
				set_state(STATE_READY);
			}
		}

		break;
	case STATE_SELECT:
	case STATE_SELECT_LOADING:
		// `
		{
			int x = 0;
			int tmp = 0;

			g->setBright(127);
			switch ( player ) {
			case 0:
				g->drawImage(use_image(DATA_RAY), 80, 0, 0, 0, 480, 480);
				break;
			case 1:
				g->drawImage(use_image(DATA_RAX), 80, 0, 0, 0, 480, 480);
				break;
			case 2:
				g->drawImage(use_image(DATA_COM), 80, 0, 0, 0, 480, 480);
				break;
			}
			g->setBright(255);

			g->setROP(_ROP_ADD);

			g->drawImage(use_image(DATA_SELECT), 320 - 268 / 2, 20, 0, 160, 268, 30);

			g->drawImage(use_image(DATA_TITLE), 360 - TEXT_ACCELERATION_W, 300, TEXT_ACCELERATION_X, TEXT_ACCELERATION_Y, TEXT_ACCELERATION_W, TEXT_ACCELERATION_H);
			g->drawImage(use_image(DATA_TITLE), 360 - TEXT_SLOWDOWN_W, 340, TEXT_SLOWDOWN_X, TEXT_SLOWDOWN_Y, TEXT_SLOWDOWN_W, TEXT_SLOWDOWN_H);
			g->drawImage(use_image(DATA_TITLE), 360 - TEXT_STEERING_W, 380, TEXT_STEERING_X, TEXT_STEERING_Y, TEXT_STEERING_W, TEXT_STEERING_H);

			g->drawImage(use_image(DATA_SELECT), 240, 90, 160 * ((_elapse / 4) % 3), 0, 160, 160);
			if ( ((_elapse / 5) % 4) < 2 ) {
				g->drawImage(use_image(DATA_TITLE), 222, 162, 300, 0, 10, 18);
				g->drawImage(use_image(DATA_TITLE), 410, 162, 310, 0, 10, 18);
			}

			g->setROP(_ROP_COPY);

			switch ( player ) {
			case 0:
				g->setROP(_ROP_ADD);
				for ( i = 0; i < 3; i++ ) {
					switch ( i ) {
					case 0: x = 210; tmp = win[index_w()][2]; break;
					case 1: x = 370; tmp = win[index_w()][0]; break;
					case 2: x = 530; tmp = win[index_w()][1]; break;
					}
					while ( tmp != 0 ) {
						g->drawImage(use_image(DATA_TITLE), x, 100, (tmp % 10) * 24, 0, 24, 24);
						tmp /= 10;
						x -= 24;
					}
				}
				g->setROP(_ROP_COPY);

				g->drawImage(use_image(DATA_SPEEDER3_1), 160 - (_SPEEDER3_W / 2), 196 - _SPEEDER3_H);
				g->drawImage(use_image(DATA_SPEEDER1_1), 320 - (_SPEEDER1_W / 2), 196 - _SPEEDER1_H);
				g->drawImage(use_image(DATA_SPEEDER2_1), 480 - (_SPEEDER2_W / 2), 196 - _SPEEDER2_H);

				g->setROP(_ROP_ADD);

				g->drawImage(use_image(DATA_TITLE), (640 - TEXT_RAY_W) / 2, 210, TEXT_RAY_X, TEXT_RAY_Y, TEXT_RAY_W, TEXT_RAY_H);

				g->drawImage(use_image(DATA_TITLE), 380, 300, TEXT_FAST_X, TEXT_FAST_Y, TEXT_FAST_W, TEXT_FAST_H);
				g->drawImage(use_image(DATA_TITLE), 380, 340, TEXT_NORMAL_X, TEXT_NORMAL_Y, TEXT_NORMAL_W, TEXT_NORMAL_H);
				g->drawImage(use_image(DATA_TITLE), 380, 380, TEXT_NORMAL_X, TEXT_NORMAL_Y, TEXT_NORMAL_W, TEXT_NORMAL_H);

				g->setROP(_ROP_COPY);

				break;
			case 1:
				g->setROP(_ROP_ADD);
				for ( i = 0; i < 3; i++ ) {
					switch ( i ) {
					case 0: x = 210; tmp = win[index_w()][0]; break;
					case 1: x = 370; tmp = win[index_w()][1]; break;
					case 2: x = 530; tmp = win[index_w()][2]; break;
					}
					while ( tmp != 0 ) {
						g->drawImage(use_image(DATA_TITLE), x, 100, (tmp % 10) * 24, 0, 24, 24);
						tmp /= 10;
						x -= 24;
					}
				}
				g->setROP(_ROP_COPY);

				g->drawImage(use_image(DATA_SPEEDER1_1), 160 - (_SPEEDER1_W / 2), 196 - _SPEEDER1_H);
				g->drawImage(use_image(DATA_SPEEDER2_1), 320 - (_SPEEDER2_W / 2), 196 - _SPEEDER2_H);
				g->drawImage(use_image(DATA_SPEEDER3_1), 480 - (_SPEEDER3_W / 2), 196 - _SPEEDER3_H);

				g->setROP(_ROP_ADD);

				g->drawImage(use_image(DATA_TITLE), (640 - TEXT_RAX_W) / 2, 210, TEXT_RAX_X, TEXT_RAX_Y, TEXT_RAX_W, TEXT_RAX_H);

				g->drawImage(use_image(DATA_TITLE), 380, 300, TEXT_MIDDLE_X, TEXT_MIDDLE_Y, TEXT_MIDDLE_W, TEXT_MIDDLE_H);
				g->drawImage(use_image(DATA_TITLE), 380, 340, TEXT_SLIGHT_X, TEXT_SLIGHT_Y, TEXT_SLIGHT_W, TEXT_SLIGHT_H);
				g->drawImage(use_image(DATA_TITLE), 380, 380, TEXT_NORMAL_X, TEXT_NORMAL_Y, TEXT_NORMAL_W, TEXT_NORMAL_H);

				g->setROP(_ROP_COPY);

				break;
			case 2:
				g->setROP(_ROP_ADD);
				for ( i = 0; i < 3; i++ ) {
					switch ( i ) {
					case 0: x = 210; tmp = win[index_w()][1]; break;
					case 1: x = 370; tmp = win[index_w()][2]; break;
					case 2: x = 530; tmp = win[index_w()][0]; break;
					}
					while ( tmp != 0 ) {
						g->drawImage(use_image(DATA_TITLE), x, 100, (tmp % 10) * 24, 0, 24, 24);
						tmp /= 10;
						x -= 24;
					}
				}
				g->setROP(_ROP_COPY);

				g->drawImage(use_image(DATA_SPEEDER2_1), 160 - (_SPEEDER2_W / 2), 196 - _SPEEDER2_H);
				g->drawImage(use_image(DATA_SPEEDER3_1), 320 - (_SPEEDER3_W / 2), 196 - _SPEEDER3_H);
				g->drawImage(use_image(DATA_SPEEDER1_1), 480 - (_SPEEDER1_W / 2), 196 - _SPEEDER1_H);

				g->setROP(_ROP_ADD);

				g->drawImage(use_image(DATA_TITLE), (640 - TEXT_COM_W) / 2, 210, TEXT_COM_X, TEXT_COM_Y, TEXT_COM_W, TEXT_COM_H);

				g->drawImage(use_image(DATA_TITLE), 380, 300, TEXT_SLOW_X, TEXT_SLOW_Y, TEXT_SLOW_W, TEXT_SLOW_H);
				g->drawImage(use_image(DATA_TITLE), 380, 340, TEXT_NORMAL_X, TEXT_NORMAL_Y, TEXT_NORMAL_W, TEXT_NORMAL_H);
				g->drawImage(use_image(DATA_TITLE), 380, 380, TEXT_QUICK_X, TEXT_QUICK_Y, TEXT_QUICK_W, TEXT_QUICK_H);

				g->setROP(_ROP_COPY);

				break;
			}
		}

		if ( state == STATE_SELECT_LOADING ) {
			set_state(STATE_READY);
		}

		break;
	case STATE_READY:
		// `
		stage->draw(TRUE);
		wave->draw();
		speeder[0]->draw(TRUE);
		if ( (level < 2) || (level == 7) ) {
			speeder[1]->draw(TRUE);
			speeder[2]->draw(TRUE);
		}
		switch ( level ) {
		case 4:
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_AUTOSTEERING_W) / 2, 160, TEXT_AUTOSTEERING_X, TEXT_AUTOSTEERING_Y, TEXT_AUTOSTEERING_W, TEXT_AUTOSTEERING_H);
			break;
		case 5:
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_AUTOSHIELD_W) / 2, 160, TEXT_AUTOSHIELD_X, TEXT_AUTOSHIELD_Y, TEXT_AUTOSHIELD_W, TEXT_AUTOSHIELD_H);
			break;
		}
		g->drawImage(use_image(DATA_STATUS), (640 - TEXT_READY_W) / 2, (480 - TEXT_READY_H) / 2, TEXT_READY_X, TEXT_READY_Y, TEXT_READY_W, TEXT_READY_H);
		drawStatus(TRUE);

		// 莞ԉ߂Q[Jn
		if ( _elapse >= WAIT_2 ) {
play_sound(SE_START);
			set_state(STATE_PLAY);
		} else {
			if ( !pause ) {
				if ( (_elapse % WAIT_H) == 0 ) {
play_sound(SE_READY);
				}
			}
		}

		break;
	case STATE_PLAY:
		if ( !pause ) {
			time[0]++;

			// XVO̍Wێ
			if ( (level < 2) || (level == 7) ) {
				old_y[0] = speeder[1]->dsp_y();
				old_y[1] = speeder[2]->dsp_y();
			}

			// XV
			stage->update();
			wave->update();

			if ( (level != 6) && dsp_lap && !finish && ((_elapse - _elapse_l) <= WAIT_1) && (((_elapse - _elapse_l) % WAIT_COUNTER) == 0) ) {
play_sound(SE_COUNTER);
			}

			if ( (level < 2) || (level == 7) ) {
				for ( i = 0; i < 2; i++ ) {
					if ( shield_wait[i] > 0 ) {
						shield_wait[i]--;
						if ( shield_wait[i] == 0 ) {
							speeder[i + 1]->shield(shield_col[i]);
						}
					}

					new_y[i] = speeder[i + 1]->dsp_y();
					if ( (old_y[i] > -96) && (new_y[i] <= -96) ) {
						speeder[i + 1]->out(wave->top_x());
					} else if ( (old_y[i] <= -96) && (new_y[i] > -96) ) {
						speeder[i + 1]->in(wave->top_x());
					} else if ( (old_y[i] < 640) && (new_y[i] >= 640) ) {
						speeder[i + 1]->out(wave->bottom_x());
					} else if ( (old_y[i] >= 640) && (new_y[i] < 640) ) {
						speeder[i + 1]->in(wave->bottom_x());
					}

					if ( new_y[i] <= -480 ) {
						if ( speeder[0]->speed() < 510 ) {
							speeder[i + 1]->speed_limit(500);
						} else if ( speeder[0]->_type == SPEEDER3 ) {
							speeder[i + 1]->speed_limit(speeder[0]->speed() - 15);
						} else {
							speeder[i + 1]->speed_limit(speeder[0]->speed() - 10);
						}
					}
				}
			}

			// Xs[_[̈ړ
			if ( level == 4 ) {
				switch ( speeder[0]->__auto() ) {
				case AUTO_MOVED_INERTIA: speeder[0]->__auto(AUTO_INERTIA); break;
				case AUTO_MOVED_NEUTRAL: speeder[0]->__auto(AUTO_NEUTRAL); break;
				case AUTO_INERTIA: speeder[0]->inertia(FALSE); break;
				case AUTO_NEUTRAL: speeder[0]->inertia(TRUE ); break;
				}
			} else {
				if      ( (key & _KEY_LEFT ) != 0 ) speeder[0]->left ();
				else if ( (key & _KEY_RIGHT) != 0 ) speeder[0]->right();
				else speeder[0]->inertia(neutral);
				if ( (level < 2) || (level == 7) ) {
					for ( i = 1; i < 3; i++ ) {
						switch ( speeder[i]->__auto() ) {
						case AUTO_MOVED_INERTIA: speeder[i]->__auto(AUTO_INERTIA); break;
						case AUTO_MOVED_NEUTRAL: speeder[i]->__auto(AUTO_NEUTRAL); break;
						case AUTO_INERTIA: speeder[i]->inertia(FALSE); break;
						case AUTO_NEUTRAL: speeder[i]->inertia(TRUE ); break;
						}
					}
				}
			}
		}

		// `
		stage->draw(FALSE);
		{
			int cnt = wave->draw();
			if ( (cnt < 0) || (stage->offset_x() < 0) ) {
				if ( (elapse() % 4) < 2 ) {
					g->drawImage(use_image(DATA_BAR), 20, 204, 400, 0, 80, 72);
				}
			} else if ( (cnt > 0) || (stage->offset_x() > 0) ) {
				if ( (elapse() % 4) < 2 ) {
					g->drawImage(use_image(DATA_BAR), 540, 204, 400, 72, 80, 72);
				}
			}
		}
		speeder[0]->draw(FALSE);
		if ( (level < 2) || (level == 7) ) {
			speeder[1]->draw(FALSE);
			speeder[2]->draw(FALSE);
		}
		if ( level != 6 ) {
			if ( _elapse < WAIT_2 ) {
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_START_W) / 2, (480 - TEXT_START_H) / 2, TEXT_START_X, TEXT_START_Y, TEXT_START_W, TEXT_START_H);
			}
		}
		drawStatus(FALSE);

		if ( level != 6 ) {
			if ( finish ) {
				// Xe[WNA
				set_state(STATE_CLEAR);
			}
		} else {
			if ( speeder[0]->speed() == 0 ) {
				// Q[I
				set_state(STATE_STOP);
			}
		}

		break;
	case STATE_CLEAR:
		setVolumeMusic(100 - 100 * _elapse / WAIT_4);

		// XVO̍Wێ
		if ( (level < 2) || (level == 7) ) {
			old_y[0] = speeder[1]->dsp_y();
			old_y[1] = speeder[2]->dsp_y();
		}

		// XV
		stage->update();
		wave->update();

		if ( (level < 2) || (level == 7) ) {
			for ( i = 0; i < 2; i++ ) {
				new_y[i] = speeder[i + 1]->dsp_y();
				if ( (old_y[i] <= -96) && (new_y[i] > -96) ) {
					speeder[i + 1]->in(speeder[0]->x() - 176);
				} else if ( (old_y[i] >= 640) && (new_y[i] < 640) ) {
					speeder[i + 1]->in(speeder[0]->x() - 176);
				}
			}
		}

		// Xs[_[̈ړ
		speeder[0]->inertia(TRUE);
		if ( (level < 2) || (level == 7) ) {
			speeder[1]->inertia(TRUE);
			speeder[2]->inertia(TRUE);
		}

		// `
		stage->draw(FALSE);
		wave->draw();
		speeder[0]->draw(FALSE);
		if ( (level < 2) || (level == 7) ) {
			speeder[1]->draw(FALSE);
			speeder[2]->draw(FALSE);
		}
		if ( (level < 2) || (level == 7) ) {
			int y = (480 - (TEXT_FINISH_H + 20 + TEXT_1ST_H + 20 + TEXT_NEWRECORD_H)) / 2;
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_FINISH_W) / 2, y, TEXT_FINISH_X, TEXT_FINISH_Y, TEXT_FINISH_W, TEXT_FINISH_H);
			y += (TEXT_FINISH_H + 20);
			switch ( ranking ) {
			case 1:
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_1ST_W) / 2, y, TEXT_1ST_X, TEXT_1ST_Y, TEXT_1ST_W, TEXT_1ST_H);
				break;
			case 2:
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_2ND_W) / 2, y, TEXT_2ND_X, TEXT_2ND_Y, TEXT_2ND_W, TEXT_2ND_H);
				break;
			case 3:
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_3RD_W) / 2, y, TEXT_3RD_X, TEXT_3RD_Y, TEXT_3RD_W, TEXT_3RD_H);
				break;
			}
			y += (TEXT_1ST_H + 20);
			if ( new_time ) {
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_NEWRECORD_W) / 2, y, TEXT_NEWRECORD_X, TEXT_NEWRECORD_Y, TEXT_NEWRECORD_W, TEXT_NEWRECORD_H);
			}
		} else {
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_FINISH_W) / 2, (480 - TEXT_FINISH_H) / 2, TEXT_FINISH_X, TEXT_FINISH_Y, TEXT_FINISH_W, TEXT_FINISH_H);
			if ( new_time ) {
				g->drawImage(use_image(DATA_STATUS), (640 - TEXT_NEWRECORD_W) / 2, 280, TEXT_NEWRECORD_X, TEXT_NEWRECORD_Y, TEXT_NEWRECORD_W, TEXT_NEWRECORD_H);
			}
		}
		drawStatus(FALSE);

		// 莞ԉ߂^Cgʂ
		if ( _elapse > WAIT_4 ) {
			set_state(STATE_TITLE);
		}

		break;
	case STATE_STOP:
		// Xs[_[̈ړ
		speeder[0]->inertia(TRUE);

		// `
		stage->draw(FALSE);
		wave->draw();
		speeder[0]->draw(FALSE);
		{
			int x = (640 - (TEXT_STOP_W + 6 + TEXT_PED_W)) / 2;
			int y = (480 - TEXT_STOP_H) / 2;
			g->drawImage(use_image(DATA_STATUS), x, y, TEXT_STOP_X, TEXT_STOP_Y, TEXT_STOP_W, TEXT_STOP_H); x += (TEXT_STOP_W + 6);
			g->drawImage(use_image(DATA_STATUS), x, y, TEXT_PED_X, TEXT_PED_Y, TEXT_PED_W, TEXT_PED_H);
		}
		if ( new_distance ) {
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_NEWRECORD_W) / 2, 280, TEXT_NEWRECORD_X, TEXT_NEWRECORD_Y, TEXT_NEWRECORD_W, TEXT_NEWRECORD_H);
		}
		drawStatus(FALSE);

		// 莞ԉ߂^Cgʂ
		if ( _elapse > WAIT_4 ) {
			set_state(STATE_TITLE);
		}

		break;
	}

	if ( pause ) {
		_elapse_p++;
	} else {
		_elapse++;
		if ( _elapse_s > 0 ) {
			_elapse_s++;
		}
	}

	// FPS \
	if ( sys_data.bShowFPS ) {
		int x = 637 - 24;
		int tmp = g_framePerSecond;
		for ( i = 0; i < 2; i++ ) {
			g->drawImage(use_image(DATA_STATUS), x, 451, (tmp % 10) * 24, 0, 24, 26);
			tmp /= 10;
			x -= 24;
		}
	}
}

void Main::processEvent(UINT type, UINT param) {
	if ( type == _KEY_PRESSED_EVENT ) {
		switch ( state ) {
		case STATE_LAUNCH:
			break;
		case STATE_TITLE:
			if ( (param == _KEY_LEFT) || (param == _KEY_RIGHT) ) {
play_sound(SE_CURSOR);
				neutral = neutral ? FALSE : TRUE;
			} else if ( param == _KEY_UP ) {
play_sound(SE_CURSOR);
				level--; if ( level < 0 ) level = level_max();
			} else if ( param == _KEY_DOWN ) {
play_sound(SE_CURSOR);
				level++; if ( level > level_max() ) level = 0;
			} else if ( param == button[0] ) {
play_sound(SE_SELECT);
				set_state(STATE_TITLE_LOADING);
			}
			break;
		case STATE_TITLE_LOADING:
			break;
		case STATE_SELECT:
			if ( param == _KEY_LEFT ) {
play_sound(SE_CURSOR);
				player--; if ( player < 0 ) player = 2;
			} else if ( param == _KEY_RIGHT ) {
play_sound(SE_CURSOR);
				player++; if ( player > 2 ) player = 0;
			} else if ( param == button[0] ) {
play_sound(SE_SELECT);
				set_state(STATE_SELECT_LOADING);
			} else if ( param == button[1] ) {
play_sound(SE_CANCEL);
				set_state(STATE_TITLE);
			}
			break;
		case STATE_SELECT_LOADING:
			break;
		default:
			if ( (param == _KEY_SPACE) || (param == button[3]) ) {
				pause = pause ? FALSE : TRUE;
				if ( pause ) {
					pause2 = TRUE;
					select_pause = 0;
					_elapse_p = 0;
				}
			} else if ( param == _KEY_SHIFT ) {
				if ( pause ) {
					pause2 = pause2 ? FALSE : TRUE;
				}
			} else if ( param == _KEY_UP ) {
				if ( pause && pause2 ) {
play_sound(SE_CURSOR);
					select_pause = 0;
				}
			} else if ( param == _KEY_DOWN ) {
				if ( pause && pause2 ) {
play_sound(SE_CURSOR);
					select_pause = 1;
				}
			} else if ( param == button[0] ) {
				if ( pause ) {
					if ( pause2 ) {
						switch ( select_pause ) {
						case 0:
							pause = FALSE;
							break;
						case 1:
play_sound(SE_CANCEL);
							set_state(STATE_TITLE);
							break;
						}
					} else {
						pause = FALSE;
					}
				} else {
					if ( level != 5 ) {
						if ( boost && (speeder[0]->_shield == 0) ) {
							_elapse_b = _elapse;
							boost = FALSE;
							speeder[0]->speed_up(400);
play_sound(SE_BOOST);
						} else {
							speeder[0]->shield(0);
						}
					}
				}
			} else if ( param == button[1] ) {
				if ( pause ) {
					pause = FALSE;
				} else {
					if ( level != 5 ) {
						if ( boost && (speeder[0]->_shield == 1) ) {
							_elapse_b = _elapse;
							boost = FALSE;
							speeder[0]->speed_up(400);
play_sound(SE_BOOST);
						} else {
							speeder[0]->shield(1);
						}
					}
				}
			} else if ( param == button[2] ) {
				if ( pause ) {
				} else {
					if ( level != 5 ) {
						if ( boost && (speeder[0]->_shield == 2) ) {
							_elapse_b = _elapse;
							boost = FALSE;
							speeder[0]->speed_up(400);
play_sound(SE_BOOST);
						} else {
							speeder[0]->shield(2);
						}
					}
				}
			}
			break;
		}
	} else if ( type == _KEY_RELEASED_EVENT ) {
		if ( param == _KEY_ESCAPE ) {
writeLog("Iv");
			lock_dispose_image = FALSE;
			dispose_image();
			dispose_music();
			dispose_sound();
			save_config();
			terminate();
		} else {
//			switch ( state ) {
//			case STATE_EXIT:
//				if ( param == button[0] ) {
//					set_state(STATE_EXIT2);
//				}
//				break;
//			}
		}
	}
}

/**
 * ݒ̓ǂݍ
 */
void Main::load_config() {
	int i, j;

	// ftHgl
	neutral       = TRUE;
	level         = 0;
	player        = 0;
	shield_lag[0] = WAIT_H;
	shield_lag[1] = WAIT_H;
	shield_index  = 0;
	for ( i = 0; i < 7; i++ ) {
		for ( j = 0; j < 10; j++ ) {
			best_time[i][j] = 99999;
		}
	}
	for ( i = 0; i < 3; i++ ) {
		for ( j = 0; j < 3; j++ ) {
			win[i][j] = 0;
		}
	}
	best_distance = 0;

	char file[MAX_PATH];
	sprintf(file, "%s\\save.dat", g_appDir);
	FILE* fp;
	int tmp;
	if ( (fp = fopen(file, "rb")) != NULL ) {
		for ( ; ; ) {
			char header[9];
			char header2[9];
			if ( fread(header, 8, 1, fp) <= 0 ) {
				break;
			}
			header[8] = '\0';
			sprintf(header2, "SAVE%s", CONFIG_VERSION);
			if ( strcmp(header, header2) != 0 ) {
				break;
			}
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) neutral = (tmp == 1) ? TRUE : FALSE;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) level = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) player = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) shield_lag[0] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) shield_lag[1] = tmp;
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) shield_index = tmp;
			for ( i = 0; i < 7; i++ ) {
				for ( j = 0; j < 10; j++ ) {
					if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) best_time[i][j] = tmp;
				}
			}
			for ( i = 0; i < 3; i++ ) {
				for ( j = 0; j < 3; j++ ) {
					if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) win[i][j] = tmp;
				}
			}
			if ( fread(&tmp, sizeof(int), 1, fp) > 0 ) best_distance = tmp;
			break;
		}
		fclose(fp);
	}
}

/**
 * ݒ̏o
 */
void Main::save_config() {
	int i, j;

	char file[MAX_PATH];
	sprintf(file, "%s\\save.dat", g_appDir);
	FILE* fp;
	int tmp;
	if ( (fp = fopen(file, "w+b")) != NULL ) {
		char header[9];
		sprintf(header, "SAVE%s", CONFIG_VERSION);
		fwrite(header, sizeof(char), 8, fp);
		tmp = (neutral == TRUE) ? 1 : 0;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = level;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = player;
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = shield_lag[0];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = shield_lag[1];
		fwrite(&tmp, sizeof(int), 1, fp);
		tmp = shield_index;
		fwrite(&tmp, sizeof(int), 1, fp);
		for ( i = 0; i < 7; i++ ) {
			for ( j = 0; j < 10; j++ ) {
				tmp = best_time[i][j];
				fwrite(&tmp, sizeof(int), 1, fp);
			}
		}
		for ( i = 0; i < 3; i++ ) {
			for ( j = 0; j < 3; j++ ) {
				tmp = win[i][j];
				fwrite(&tmp, sizeof(int), 1, fp);
			}
		}
		tmp = best_distance;
		fwrite(&tmp, sizeof(int), 1, fp);
		fflush(fp);
		fclose(fp);
	}
}

/**
 * f[^ǂݍ
 */
_Memory* Main::read_data(int id) {
	_Memory* data = NULL;
	if ( pak_data ) {
		unsigned long top;
		top = ((unsigned long*)pak_data)[id];
		data = new _Memory();
		if ( data->alloc(((unsigned long*)pak_data)[id + 1] - top) ) {
			memcpy(data->ptr(), &pak_data[top], data->size());
		} else {
			delete data;
			data = NULL;
		}
	} else {
		_String* file = new _String("");
		file->set(g_appDir);
		file->add("\\data.pak");
		FILE* fp;
		unsigned long top;
		unsigned long size;
		if ( (fp = fopen(file->str(), "rb")) != NULL ) {
			fseek(fp, id * sizeof(unsigned long), SEEK_SET);
			fread(&top, sizeof(unsigned long), 1, fp);
			fread(&size, sizeof(unsigned long), 1, fp);
			size -= top;
			data = new _Memory();
			if ( data->alloc(size) ) {
				fseek(fp, top, SEEK_SET);
				fread(data->ptr(), data->size(), 1, fp);
			} else {
				delete data;
				data = NULL;
			}
			fclose(fp);
		}
		delete file;
	}
	return data;
}

/**
 * C[Wǂݍ
 */
void Main::create_image(int id) {
	if ( !(main_img[id].isCreated()) ) {
		{
			char tmp[128];
			sprintf(tmp, "C[W %d \z", id);
			writeLog(tmp);
		}
		_Memory* data = read_data(id);
		g->createImage(&main_img[id], data);
		delete data;
	}
}
void Main::dispose_image(int id) {
	if ( lock_dispose_image ) return;
	if ( main_img[id].isCreated() ) {
		{
			char tmp[128];
			sprintf(tmp, "C[W %d ", id);
			writeLog(tmp);
		}
		g->disposeImage(&main_img[id]);
	}
}
void Main::dispose_image() {
	for ( int i = 0; i < IMAGE_NUM; i++ ) {
		dispose_image(i);
	}
}
_Image* Main::use_image(int id) {
	create_image(id);
	return &main_img[id];
}

/**
 * TEhf[^ǂݍ
 */
void Main::create_sound(int id) {
	if ( !(main_sound[id].isEnabled()) ) {
		{
			char tmp[128];
			sprintf(tmp, "SEf[^ %d \z", id);
			writeLog(tmp);
		}

		char key[16];
		char file[128 + 1];
		switch ( id ) {
		case SE_CURSOR : strcpy(key, "cursor"); break;
		case SE_SELECT : strcpy(key, "select"); break;
		case SE_CANCEL : strcpy(key, "cancel"); break;
		case SE_READY  : strcpy(key, "ready"); break;
		case SE_START  : strcpy(key, "start"); break;
		case SE_COUNTER: strcpy(key, "counter"); break;
		case SE_BOOST  : strcpy(key, "boost"); break;
		}
		char inifile[256];
		sprintf(inifile, "%s\\sound.ini", g_appDir);
		::GetPrivateProfileString("SE", key, "", file, 128, inifile);
		char file2[256];
		sprintf(file2, "%s\\sound\\%s", g_appDir, file);

		int type = _SOUND_WAV;
		if ( strstr(file2, ".wav") != NULL ) {
			type = _SOUND_WAV;
#ifdef _USE_MP3
		} else if ( strstr(file2, ".mp3") != NULL ) {
			type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
		} else if ( strstr(file2, ".ogg") != NULL ) {
			type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
		}

		createSound(&main_sound[id], file2, type);
	}
}
void Main::dispose_sound(int id) {
	if ( main_sound[id].isEnabled() ) {
		{
			char tmp[128];
			sprintf(tmp, "SEf[^ %d ", id);
			writeLog(tmp);
		}
		disposeSound(&main_sound[id]);
	}
}
void Main::dispose_sound() {
	for ( int i = 0; i < SE_NUM; i++ ) {
		dispose_sound(i);
	}
}
_SoundData* Main::use_sound(int id) {
	create_sound(id);
	return &main_sound[id];
}

BOOL Main::create_music(int id) {
	if ( !(main_music[id].isEnabled()) ) {
		{
			char tmp[128];
			sprintf(tmp, "BGMf[^ %d \z", id);
			writeLog(tmp);
		}

		char key[16];
		char file[128 + 1];
		switch ( id ) {
		case  0: strcpy(key, "speedy1"); break;
		case  1: strcpy(key, "speedy2"); break;
		case  2: strcpy(key, "speedy3"); break;
		case  3: strcpy(key, "speedy4"); break;
		case  4: strcpy(key, "speedy5"); break;
		case  5: strcpy(key, "slowly1"); break;
		case  6: strcpy(key, "slowly2"); break;
		case  7: strcpy(key, "slowly3"); break;
		case  8: strcpy(key, "slowly4"); break;
		case  9: strcpy(key, "slowly5"); break;
		case 10: strcpy(key, "select"); break;
		}
		char inifile[256];
		sprintf(inifile, "%s\\sound.ini", g_appDir);
		::GetPrivateProfileString("BGM", key, "", file, 128, inifile);
		char file2[256];
		sprintf(file2, "%s\\sound\\%s", g_appDir, file);

		int type = _SOUND_WAV;
		if ( strstr(file2, ".wav") != NULL ) {
			type = _SOUND_WAV;
#ifdef _USE_MP3
		} else if ( strstr(file2, ".mp3") != NULL ) {
			type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
		} else if ( strstr(file2, ".ogg") != NULL ) {
			type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
		}

		createSound(&main_music[id], file2, type);
	}

	return main_music[id].isEnabled();
}
void Main::dispose_music(int id) {
	if ( main_music[id].isEnabled() ) {
		{
			char tmp[128];
			sprintf(tmp, "BGMf[^ %d ", id);
			writeLog(tmp);
		}
		disposeSound(&main_music[id]);
	}
}
void Main::dispose_music() {
	for ( int i = 0; i < BGM_NUM; i++ ) {
		dispose_music(i);
	}
}

void Main::play_music(int id) {
	stopMusic();
	setVolumeMusic(100);
	int select = 0;
	switch ( id ) {
	case BGM_SPEEDY:
	case BGM_SLOWLY:
		for ( ; ; ) {
			select = _rand->nextInt() % (BGM_NUM / 2);
			if ( select >= 0 ) {
				break;
			}
		}
		break;
	}
	id += select;

	if ( main_music[id].isEnabled() ) {
		playMusic(&main_music[id], TRUE);
		return;
	}

	char key[16];
	char file[128 + 1];
	switch ( id ) {
	case  0: strcpy(key, "speedy1"); break;
	case  1: strcpy(key, "speedy2"); break;
	case  2: strcpy(key, "speedy3"); break;
	case  3: strcpy(key, "speedy4"); break;
	case  4: strcpy(key, "speedy5"); break;
	case  5: strcpy(key, "slowly1"); break;
	case  6: strcpy(key, "slowly2"); break;
	case  7: strcpy(key, "slowly3"); break;
	case  8: strcpy(key, "slowly4"); break;
	case  9: strcpy(key, "slowly5"); break;
	case 10: strcpy(key, "select"); break;
	}
	char inifile[256];
	sprintf(inifile, "%s\\sound.ini", g_appDir);
	::GetPrivateProfileString("BGM", key, "", file, 128, inifile);
	char file2[256];
	sprintf(file2, "%s\\sound\\%s", g_appDir, file);

	int type = _SOUND_WAV;
	if ( strstr(file2, ".wav") != NULL ) {
		type = _SOUND_WAV;
#ifdef _USE_MP3
	} else if ( strstr(file2, ".mp3") != NULL ) {
		type = _SOUND_MP3;
#endif // _USE_MP3
#ifdef _USE_OGGVORBIS
	} else if ( strstr(file2, ".ogg") != NULL ) {
		type = _SOUND_OGGVORBIS;
#endif // _USE_OGGVORBIS
	}

	playMusic(file2, type, TRUE);
}
void Main::play_sound(int id) {
	playSound(use_sound(id));
}
void Main::stop_sound(int id) {
	stopSound(use_sound(id));
}

/**
 * oߎԂmF
 */
int Main::elapse() {
	return pause ? _elapse_p : _elapse;
}

/**
 * ܂[hvCł邩mF
 */
BOOL Main::omake1() {
#ifndef _DEBUG
	int i;
	for ( i = 0; i < 6; i++ ) {
		if ( best_time[i][0] == 99999 ) {
			return FALSE;
		}
	}
#endif // _DEBUG
	return TRUE;
}
BOOL Main::omake2() {
#ifndef _DEBUG
	int i, j;
	for ( i = 0; i < 2; i++ ) {
		for ( j = 0; j < 3; j++ ) {
			if ( win[i][j] == 0 ) {
				return FALSE;
			}
		}
	}
#endif // _DEBUG
	return TRUE;
}

int Main::level_max() {
	if ( omake1() ) {
		return omake2() ? 7 : 6;
	}
	return 5;
}

int Main::index_b() {
	return (level == 7) ? 6 : level;
}
int Main::index_w() {
	return (level == 7) ? 2 : level;
}

/**
 * Av̏ԂύX
 */
void Main::set_state(int new_state) {
	int i;

	int old_state = state;
	state = new_state;
	_elapse = 0;
	_elapse_l = 0;
	_elapse_b = 0 - WAIT_BOOST;

	switch ( old_state ) {
	case STATE_TITLE_LOADING:
	case STATE_SELECT_LOADING:
		dispose_image();

		if ( state == STATE_READY ) {
			change_col = 0;

			if ( level != 6 ) {
				shield_wait[0] = 0;
				shield_wait[1] = 0;

				first = (best_time[index_b()][0] == 99999) ? TRUE : FALSE;

				time[0] = 0;

				lap     = 0;
				dsp_lap = FALSE;
				finish  = FALSE;
			} else {
				old_distance = best_distance;
			}

			boost = FALSE;

			if ( (level < 2) || (level == 7) ) {
				BOOL tmp = (_rand->nextInt() > 0) ? TRUE : FALSE;
				switch ( player ) {
				case 0:
					speeder[0]->init(TRUE, SPEEDER1, 0, 0);
					speeder[1]->init(FALSE, tmp ? SPEEDER2 : SPEEDER3, 0, -100);
					speeder[2]->init(FALSE, tmp ? SPEEDER3 : SPEEDER2, 0,  100);
					break;
				case 1:
					speeder[0]->init(TRUE, SPEEDER2, 0, 0);
					speeder[1]->init(FALSE, tmp ? SPEEDER1 : SPEEDER3, 0, -100);
					speeder[2]->init(FALSE, tmp ? SPEEDER3 : SPEEDER1, 0,  100);
					break;
				case 2:
					speeder[0]->init(TRUE, SPEEDER3, 0, 0);
					speeder[1]->init(FALSE, tmp ? SPEEDER1 : SPEEDER2, 0, -100);
					speeder[2]->init(FALSE, tmp ? SPEEDER2 : SPEEDER1, 0,  100);
					break;
				}
			} else {
				switch ( _rand->nextInt() % 2 ) {
				case -1: speeder[0]->init(TRUE, SPEEDER1, (level != 6) ? 0 : 999, 0); break;
				case  0: speeder[0]->init(TRUE, SPEEDER4, (level != 6) ? 0 : 999, 0); break;
				case  1: speeder[0]->init(TRUE, SPEEDER5, (level != 6) ? 0 : 999, 0); break;
				}
			}
		}

		break;
	case STATE_CLEAR:
	case STATE_STOP:
		save_config();
		break;
	}

	switch ( state ) {
	case STATE_LAUNCH:
		launch_step = 0;
		break;
	case STATE_TITLE:
		stopMusic();

		pause = FALSE;
		if ( old_state != STATE_SELECT ) {
			save_config();
		}
		dispose_image();

		break;
	case STATE_SELECT:
play_music(BGM_SELECT);
		create_image(DATA_SPEEDER1_1);
		create_image(DATA_SPEEDER2_1);
		create_image(DATA_SPEEDER3_1);
		break;
	case STATE_READY:
play_music(BGM_SPEEDY);
		create_image(DATA_SPEEDER1_1);
		create_image(DATA_SPEEDER1_2);
		create_image(DATA_SPEEDER1_3);
		create_image(DATA_SPEEDER2_1);
		create_image(DATA_SPEEDER2_2);
		create_image(DATA_SPEEDER2_3);
		create_image(DATA_SPEEDER3_1);
		create_image(DATA_SPEEDER3_2);
		create_image(DATA_SPEEDER3_3);
		wave->create();
		stage->create();
		break;
	case STATE_CLEAR:
		new_time = FALSE;
		if ( time[0] < best_time[index_b()][0] ) {
			new_time = first ? FALSE : TRUE;
			best_time[index_b()][0] = time[0];
			best_time[index_b()][1] = time[1];
			for ( i = 2; i < 10; i++ ) {
				best_time[index_b()][i] = time[i] - time[i - 1];
			}
		}
		ranking = 1;
		if ( (level < 2) || (level == 7) ) {
			if ( speeder[0]->distance() < speeder[1]->distance() ) ranking++;
			if ( speeder[0]->distance() < speeder[2]->distance() ) ranking++;
			if ( ranking == 1 ) {
				win[index_w()][player]++;
			}
		}
		break;
	case STATE_STOP:
		new_distance = FALSE;
		if ( speeder[0]->distance() > best_distance ) {
			new_distance = (best_distance == 0) ? FALSE : TRUE;
			best_distance = speeder[0]->distance();
		}
		break;
	}
}

int Main::drawImage2(_Image* img, int x0, int y0, int x, int y, int w, int h) {
	if ( (x0 + w) <= 0 ) {
		return -1;
	} else if ( x0 >= 640 ) {
		return 1;
	}
	g->drawImage(img, x0, y0, x, y, w, h);
	return 0;
}

/**
 * Xe[^X`
 */
void Main::drawStatus(BOOL ready) {
	int i, x, y;
	int tmp;

	if ( level != 6 ) {
		g->drawImage(use_image(DATA_STATUS), 20, 0, 0, 52, 184, 48);
		x = 30 + 24 * 3;
		tmp = time[0] / 4;
		for ( i = 0; i < 4; i++ ) {
			g->drawImage(use_image(DATA_STATUS), x, 12, (tmp % 10) * 24, 0, 24, 26);
			tmp /= 10;
			x -= 24;
		}

		if ( dsp_lap ) {
			if ( (lap > 0) && ((_elapse - _elapse_l) < WAIT_2) ) {
				if ( !first ) {
					g->drawImage(use_image(DATA_STATUS), 20, 48, 0, 52, 118, 48);
					x = 30 + 24 * 3;
					y = 0;
					tmp = lap_time / 4;
					if ( tmp < 0 ) {
						tmp = 0 - tmp;
						g->drawImage(use_image(DATA_STATUS), 30, 60, 240, 26, 24, 26);
						y = 26;
					} else {
						g->drawImage(use_image(DATA_STATUS), 30, 60, 240, (tmp == 0) ? 52 : 0, 24, 26);
					}
					for ( i = 0; i < 3; i++ ) {
						g->drawImage(use_image(DATA_STATUS), x, 60, (tmp % 10) * 24, y, 24, 26);
						tmp /= 10;
						x -= 24;
					}
				}
			} else {
				dsp_lap = FALSE;
			}
		}
	}

	g->drawImage(use_image(DATA_STATUS), 456, 0, 0, 100, 164, 48);
	x = 540 + 24 * 2;
	tmp = ready ? 0 : speeder[0]->speed();
	for ( i = 0; i < 3; i++ ) {
		g->drawImage(use_image(DATA_STATUS), x, 12, (tmp % 10) * 24, 0, 24, 26);
		tmp /= 10;
		x -= 24;
	}

	g->drawImage(use_image(DATA_STATUS), 0, 0, 264, 0, 20, 480);
	g->drawImage(use_image(DATA_STATUS), 620, 0, 264, 0, 20, 480);

	if ( (level < 2) || (level == 7) ) {
		for ( i = 1; i < 3; i++ ) {
			g->drawImage(use_image(DATA_STATUS), 2, 480 - (480 * speeder[i]->distance() / DISTANCE) - 8, 184, 68, 16, 16);
		}
		g->drawImage(use_image(DATA_STATUS), 2, 480 - (480 * speeder[0]->distance() / DISTANCE) - 8, 184, 52, 16, 16);

		for ( i = 1; i < 3; i++ ) {
			g->drawImage(use_image(DATA_STATUS), 622, (480 / 2 - 8) - ((speeder[i]->distance() - speeder[0]->distance()) / 100), 184, 68, 16, 16);
		}
		g->drawImage(use_image(DATA_STATUS), 622, 480 / 2 - 8, 184, 52, 16, 16);
	} else if ( (level != 6) || (old_distance == 0) ) {
		y = 480 - (480 * speeder[0]->distance() / DISTANCE);
		g->drawImage(use_image(DATA_STATUS), 1, y - 8, 184, 52, 16, 16);
		g->drawImage(use_image(DATA_STATUS), 622, y - 8, 184, 52, 16, 16);
	} else {
		y = 480 - (480 * old_distance / (old_distance * 2));
		g->drawImage(use_image(DATA_STATUS), 2, y - 8, 184, 68, 16, 16);
		g->drawImage(use_image(DATA_STATUS), 622, y - 8, 184, 68, 16, 16);
		y = 480 - (480 * speeder[0]->distance() / (old_distance * 2));
		g->drawImage(use_image(DATA_STATUS), 2, y - 8, 184, 52, 16, 16);
		g->drawImage(use_image(DATA_STATUS), 622, y - 8, 184, 52, 16, 16);
	}

	if ( boost ) {
//		if ( (elapse() % 8) < 4 ) {
//			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_BOOSTOK_W) / 2, 0, TEXT_BOOSTOK_X, TEXT_BOOSTOK_Y, TEXT_BOOSTOK_W, TEXT_BOOSTOK_H);
//		}
		g->drawImage(use_image(DATA_STATUS), 528, 48, ((elapse() % 8) < 4) ? 0 : 92, 594, 92, 46);
	}

	if ( pause && pause2 ) {
		g->setAlpha(((_elapse_p * 3) > 127) ? 127 : (_elapse_p * 3));
		g->drawImage(use_image(DATA_BLACK), 0, 0);
		g->setAlpha(255);
		if ( (_elapse_p % WAIT_1) <= WAIT_H ) {
			g->drawImage(use_image(DATA_STATUS), (640 - TEXT_PAUSE_W) / 2, 200, TEXT_PAUSE_X, TEXT_PAUSE_Y, TEXT_PAUSE_W, TEXT_PAUSE_H);
		}
		g->drawImage(use_image(DATA_STATUS), (640 - TEXT_GAME_W) / 2, 250, TEXT_GAME_X, TEXT_GAME_Y, TEXT_GAME_W, TEXT_GAME_H);
		g->drawImage(use_image(DATA_STATUS), (640 - TEXT_TITLE_W) / 2, 280, TEXT_TITLE_X, TEXT_TITLE_Y, TEXT_TITLE_W, TEXT_TITLE_H);
		g->setROP(_ROP_ADD);
		g->drawImage(use_image(DATA_TITLE), 242, 251 + select_pause * 30, 310, 0, 10, 18);
		g->drawImage(use_image(DATA_TITLE), 390, 251 + select_pause * 30, 300, 0, 10, 18);
		g->setROP(_ROP_COPY);
	}
}
