/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

/**
 *
 * @author d
 */
public class ResultData {
    
    /** 曲ID (not null) */
    private final SongId id;
    /** 得点 (0以上100以下) */
    private final double score;
    /** ビブラートタイプ (0以上9以下) */
    private final byte vibratoType;
    /** ビブラート時間 (0以上) */
    private final double vibratoTime;
    /** しゃくり (0以上32767以下) */
    private final short shakuri;
    /** 音程 (0以上100以下) */
    private final byte interval;
    /** リズム (-3以上3以下) */
    private final byte rhythm;
    /** 抑揚 (0以上10以下) */
    private final byte modulation;
    
    public ResultData(
            SongId id,
            double score,
            int vibratoType,
            double vibratoTime,
            int shakuri,
            int interval,
            int rhythm,
            int modulation
            ) {
        
        if (id == null) {
            throw new NullPointerException("ResultData.ResultData\n\tid=" + id);
        } else if (!ResultData.isValidScore(score)) {
            throw new IllegalArgumentException("ResultData.ResultData score is invalid.\n\tscore=" + score);
        } else if (!ResultData.isValidVibratoType(vibratoType)) {
            throw new IllegalArgumentException("ResultData.ResultData vibratoType is invalid.\n\tvibratoType=" + vibratoType);
        } else if (!ResultData.isValidVibratoTime(vibratoTime)) {
            throw new IllegalArgumentException("ResultData.ResultData vibratoTime is invalid.\n\tvibratoTime=" + vibratoTime);
        } else if (!ResultData.isValidShakuri(shakuri)) {
            throw new IllegalArgumentException("ResultData.ResultData shakuri is invalid.\n\tshakuri=" + shakuri);
        } else if (!ResultData.isValidInterval(interval)) {
            throw new IllegalArgumentException("ResultData.ResultData interval is invalid.\n\tinterval=" + interval);
        } else if (!ResultData.isValidRhythm(rhythm)) {
            throw new IllegalArgumentException("ResultData.ResultData rhythm is invalid.\n\trhythm=" + rhythm);
        } else if (!ResultData.isValidModulation(modulation)) {
            throw new IllegalArgumentException("ResultData.ResultData modulation is invalid.\n\tmodulation=" + modulation);
        }
        
        this.id = id;
        this.score = score;
        this.vibratoType = (byte) vibratoType;
        this.vibratoTime = vibratoTime;
        this.shakuri = (short) shakuri;
        this.interval = (byte) interval;
        this.rhythm = (byte) rhythm;
        this.modulation = (byte) modulation;
    }

    public SongId getId() {
        return id;
    }

    public byte getInterval() {
        return interval;
    }

    public byte getModulation() {
        return modulation;
    }

    public byte getRhythm() {
        return rhythm;
    }

    public double getScore() {
        return score;
    }

    public short getShakuri() {
        return shakuri;
    }

    public double getVibratoTime() {
        return vibratoTime;
    }

    public byte getVibratoType() {
        return vibratoType;
    }
    
    public static boolean isValidScore(double score) {
        if ((score < 0) || (score > 100)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidInterval(int interval) {
        if ((interval < 0) || (interval > 100)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidVibratoTime(double vibratoTime) {
        if (vibratoTime < 0) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidVibratoType(int vibratoType) {
        if ((vibratoType < 0) || vibratoType > 9) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidRhythm(int rhythm) {
        if ((rhythm < -3) || (rhythm > 3)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidShakuri(int shakuri) {
        if ((shakuri < 0) || (shakuri > Short.MAX_VALUE)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidModulation(int modulation) {
        if ((modulation < 0) || (modulation > 10)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{id=");
        buffer.append(this.id);
        buffer.append(", score=");
        buffer.append(this.score);
        buffer.append(", vibratoType=");
        buffer.append(this.vibratoType);
        buffer.append(", vibratoTime=");
        buffer.append(this.vibratoTime);
        buffer.append(", shakuri=");
        buffer.append(this.shakuri);
        buffer.append(", interval=");
        buffer.append(this.interval);
        buffer.append(", rhythm=");
        buffer.append(this.rhythm);
        buffer.append(", modulation=");
        buffer.append(this.modulation);
        buffer.append("}");
        
        return buffer.toString();
    }
}
