/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

/**
 *
 * @author d
 */
public class ResultData2 {
    
    /** 曲ID (not null) */
    private final SongId id;
    /** 得点 (0以上100以下) */
    private final double score;
    /** ビブラートタイプ (0以上9以下) */
    private final byte vibratoType;
    /** ビブラート時間 (0以上) */
    private final double vibratoTime;
    /** しゃくり (0以上32767以下) */
    private final short shakuri;
    /** こぶし (0以上32767以下) */
    private final short kobushi;
    /** フォール (0以上32767以下) */
    private final short fall;
    /** 音程 (0以上100以下) */
    private final byte interval;
    /** 低音 (1以上4以下) */
    private final byte lowTone;
    /** 高音 (1以上4以下) */
    private final byte highTone;
    /** ビブラートの上手さ (0以上10以下) */
    private final byte vibratoSkill;
    /** ロングトーンの上手さ (0以上10以下) */
    private final byte longTone;
    /** 抑揚 (0以上10以下) */
    private final byte modulation;
    /** リズム (-3以上3以下) */
    private final byte rhythm;
    
    public ResultData2(
            SongId id,
            double score,
            int vibratoType,
            double vibratoTime,
            int shakuri,
            int kobushi,
            int fall,
            int interval,
            int lowTone,
            int highTone,
            int vibratoSkill,
            int longTone,
            int modulation,
            int rhythm
            ) {
        
        if (id == null) {
            throw new NullPointerException("ResultData2.ResultData2\n\tid=" + id);
        } else if (!ResultData2.isValidScore(score)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 score is invalid.\n\tscore=" + score);
        } else if (!ResultData2.isValidVibratoType(vibratoType)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoType is invalid.\n\tvibratoType=" + vibratoType);
        } else if (!ResultData2.isValidVibratoTime(vibratoTime)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoTime is invalid.\n\tvibratoTime=" + vibratoTime);
        } else if (!ResultData2.isValidShakuri(shakuri)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tshakuri=" + shakuri);
        } else if (!ResultData2.isValidKobushi(kobushi)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tkobushi=" + kobushi);
        } else if (!ResultData2.isValidFall(fall)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 shakuri is invalid.\n\tfall=" + fall);
        } else if (!ResultData2.isValidInterval(interval)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 interval is invalid.\n\tinterval=" + interval);
        } else if (!ResultData2.isValidLowTone(lowTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 lowTone is invalid.\n\tlowTone=" + lowTone);
        } else if (!ResultData2.isValidHighTone(highTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 highTone is invalid.\n\thighTone=" + highTone);
        } else if (!ResultData2.isValidVibratoSkill(vibratoSkill)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 vibratoSkill is invalid.\n\tvibratoSkill=" + vibratoSkill);
        } else if (!ResultData2.isValidLongTone(longTone)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 longTone is invalid.\n\tlongTone=" + longTone);
        } else if (!ResultData2.isValidModulation(modulation)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 modulation is invalid.\n\tmodulation=" + modulation);
        } else if (!ResultData2.isValidRhythm(rhythm)) {
            throw new IllegalArgumentException("ResultData2.ResultData2 rhythm is invalid.\n\trhythm=" + rhythm);
        }
        
        this.id = id;
        this.score = score;
        this.vibratoType = (byte) vibratoType;
        this.vibratoTime = vibratoTime;
        this.shakuri = (short) shakuri;
        this.kobushi = (short) kobushi;
        this.fall = (short) fall;
        this.interval = (byte) interval;
        this.lowTone = (byte) lowTone;
        this.highTone = (byte) highTone;
        this.vibratoSkill = (byte) vibratoSkill;
        this.longTone = (byte) longTone;
        this.rhythm = (byte) rhythm;
        this.modulation = (byte) modulation;
    }

    public short getFall() {
        return fall;
    }

    public byte getHighTone() {
        return highTone;
    }

    public short getKobushi() {
        return kobushi;
    }

    public byte getLongTone() {
        return longTone;
    }

    public byte getLowTone() {
        return lowTone;
    }

    public byte getVibratoSkill() {
        return vibratoSkill;
    }

    public SongId getId() {
        return id;
    }

    public byte getInterval() {
        return interval;
    }

    public byte getModulation() {
        return modulation;
    }

    public byte getRhythm() {
        return rhythm;
    }

    public double getScore() {
        return score;
    }

    public short getShakuri() {
        return shakuri;
    }

    public double getVibratoTime() {
        return vibratoTime;
    }

    public byte getVibratoType() {
        return vibratoType;
    }
    
    public static boolean isValidScore(double score) {
        if ((score < 0) || (score > 100)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidInterval(int interval) {
        if ((interval < 0) || (interval > 100)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidVibratoTime(double vibratoTime) {
        if (vibratoTime < 0) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidVibratoType(int vibratoType) {
        if ((vibratoType < 0) || vibratoType > 9) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidShakuri(int shakuri) {
        if ((shakuri < 0) || (shakuri > Short.MAX_VALUE)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidKobushi(int kobushi) {
        if ((kobushi < 0) || (kobushi > Short.MAX_VALUE)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidFall(int fall) {
        if ((fall < 0) || (fall > Short.MAX_VALUE)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidLowTone(int lowTone) {
        if ((lowTone < 1) || (lowTone > 4)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidHighTone(int highTone) {
        if ((highTone < 1) || (highTone > 4)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidVibratoSkill(int vibratoSkill) {
        if ((vibratoSkill < 0) || (vibratoSkill > 10)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidLongTone(int longTone) {
        if ((longTone < 0) || (longTone > 10)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidModulation(int modulation) {
        if ((modulation < 0) || (modulation > 10)) {
            return false;
        }
        return true;
    }
    
    public static boolean isValidRhythm(int rhythm) {
        if ((rhythm < -3) || (rhythm > 3)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{id=");
        buffer.append(this.id);
        buffer.append(", score=");
        buffer.append(this.score);
        buffer.append(", vibratoType=");
        buffer.append(this.vibratoType);
        buffer.append(", vibratoTime=");
        buffer.append(this.vibratoTime);
        buffer.append(", shakuri=");
        buffer.append(this.shakuri);
        buffer.append(", kobushi=");
        buffer.append(this.kobushi);
        buffer.append(", fall=");
        buffer.append(this.fall);
        buffer.append(", interval=");
        buffer.append(this.interval);
        buffer.append(", lowTone=");
        buffer.append(this.lowTone);
        buffer.append(", highTone=");
        buffer.append(this.highTone);
        buffer.append(", vibratoSkill=");
        buffer.append(this.vibratoSkill);
        buffer.append(", longTone=");
        buffer.append(this.longTone);
        buffer.append(", modulation=");
        buffer.append(this.modulation);
        buffer.append(", rhythm=");
        buffer.append(this.rhythm);
        buffer.append("}");
        
        return buffer.toString();
    }
}
