/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author d
 */
public class SongId {

    /** IDの長さ */
    public static final int ID_LENGTH = 7;
    
    private static Map<String, SongId> map = new HashMap<String, SongId>();
    
    private String value;
    
    private SongId(String id) {
        if (id == null) {
            throw new NullPointerException("SongId.SongId\n\tid=" + id);
        } else if (!SongId.isValid(id)) {
            throw new IllegalArgumentException("SongId.SongId\n\tid=" + id);
        }
        this.value = id;
    }
    
    public static SongId getInstance(String id) {
        if (SongId.map.containsKey(id)) {
            return SongId.map.get(id);
        } else {
            SongId instance = new SongId(id);
            SongId.map.put(id, instance);
            return instance;
        }
    }
    
    
    public static boolean isValid(String id) {
        if (id == null) {
            throw new NullPointerException("SongId.isValild\n\tid=" + id);
        }
        
        if (ID_LENGTH != id.length()) {
            return false;
        }
        
        for (int i = 0; i < ID_LENGTH; i++) {
            // IDのフォーマットはxxxx-xx
            if (4 == i) {
                if ('-' != id.charAt(i)) {
                    return false;
                }
            }
            else {
                if (!Character.isDigit(id.charAt(i))) {
                    return false;
                }
            }
        }
        
        return true;
    }
    
    public String getValue() {
        return this.value;
    }
    
    @Override
    public String toString() {
        return this.value;
    }
}
