/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.IToc;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.util.ProductPreferences;

public class TocManager {
    public static final String TOC_XP_NAME = "toc";
    public static final String TOC_ELEMENT_NAME = "toc";
    public static final String INDEX_ELEMENT_NAME = "index";
    private Map tocsByLang;
    private Map contributingPlugins2IndexPaths;

    public TocManager() {
        try {
            this.tocsByLang = new HashMap();
            this.build(Platform.getNL());
        }
        catch (Exception e) {
            HelpPlugin.logError("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITocElement[] getTocs(String locale) {
        if (locale == null) {
            return new ITocElement[0];
        }
        ITocElement[] tocs = (ITocElement[])this.tocsByLang.get(locale);
        if (tocs == null) {
            TocManager tocManager = this;
            synchronized (tocManager) {
                if (tocs == null) {
                    this.build(locale);
                }
            }
            tocs = (ITocElement[])this.tocsByLang.get(locale);
            if (tocs == null) {
                tocs = new ITocElement[]{};
            }
        }
        return tocs;
    }

    public ITocElement getToc(String href, String locale) {
        if (href == null || href.equals("")) {
            return null;
        }
        ITocElement[] tocs = this.getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            if (tocs[i].getHref().equals(href)) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public Collection getContributingPlugins() {
        if (this.contributingPlugins2IndexPaths == null) {
            this.getContributedTocFiles(Locale.getDefault().toString());
        }
        return this.contributingPlugins2IndexPaths.keySet();
    }

    public String getIndexPath(String pluginId) {
        if (this.contributingPlugins2IndexPaths == null) {
            this.getContributedTocFiles(Locale.getDefault().toString());
        }
        return (String)this.contributingPlugins2IndexPaths.get(pluginId);
    }

    private void build(String locale) {
        IToc[] tocs;
        try {
            Collection contributedTocFiles = this.getContributedTocFiles(locale);
            TocBuilder builder = new TocBuilder();
            builder.build(contributedTocFiles);
            List builtTocs = builder.getBuiltTocs();
            tocs = new ITocElement[builtTocs.size()];
            int i = 0;
            Iterator it = builtTocs.iterator();
            while (it.hasNext()) {
                tocs[i++] = (ITocElement)it.next();
            }
            List orderedTocs = this.orderTocs(builtTocs);
            tocs = new ITocElement[orderedTocs.size()];
            orderedTocs.toArray(tocs);
        }
        catch (Exception e) {
            tocs = new IToc[]{};
            HelpPlugin.logError("", e);
        }
        this.tocsByLang.put(locale, tocs);
    }

    private List expandCategories(List entries) {
        ArrayList expanded = new ArrayList();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Object entry = iter.next();
            if (entry instanceof ITocElement) {
                expanded.add(entry);
                continue;
            }
            if (!(entry instanceof TocCategory)) continue;
            expanded.addAll((TocCategory)entry);
        }
        return expanded;
    }

    private List orderTocs(List unorderedTocs) {
        try {
            ArrayList itemsToOrder = new ArrayList();
            Map categorized = this.categorizeTocs(unorderedTocs, itemsToOrder);
            List orderedItems = ProductPreferences.getOrderedList(HelpPlugin.getDefault(), "baseTOCS", itemsToOrder);
            orderedItems = TocManager.substituteValues(orderedItems, categorized);
            orderedItems = this.expandCategories(orderedItems);
            return orderedItems;
        }
        catch (Exception e) {
            HelpPlugin.logError("An unexpected internal error occured while ordering TOCs", e);
            return unorderedTocs;
        }
    }

    private Collection getIgnoredTocs() {
        HashSet<Object> ignored = new HashSet<Object>();
        try {
            Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
            String preferredTocs = pref.getString("ignoredTOCS");
            if (preferredTocs != null) {
                StringTokenizer suggestdOrderedInfosets = new StringTokenizer(preferredTocs, " ;,");
                while (suggestdOrderedInfosets.hasMoreElements()) {
                    ignored.add(suggestdOrderedInfosets.nextElement());
                }
            }
        }
        catch (Exception e) {
            HelpPlugin.logError("Problems occurred reading plug-in preferences.", e);
        }
        return ignored;
    }

    protected Collection getContributedTocFiles(String locale) {
        this.contributingPlugins2IndexPaths = new HashMap();
        ArrayList<TocFile> contributedTocFiles = new ArrayList<TocFile>();
        Collection ignored = this.getIgnoredTocs();
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.help", "toc");
        if (xpt == null) {
            return contributedTocFiles;
        }
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            String pluginId = extensions[i].getContributor().getName();
            if (!this.contributingPlugins2IndexPaths.containsKey(pluginId)) {
                this.contributingPlugins2IndexPaths.put(pluginId, null);
            }
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String path;
                if (configElements[j].getName().equals("toc")) {
                    String href = configElements[j].getAttribute("file");
                    String categoryId = configElements[j].getAttribute("category");
                    if (!(href == null || ignored.contains("/" + pluginId + "/" + href) || categoryId != null && ignored.contains(categoryId))) {
                        boolean isPrimary = "true".equals(configElements[j].getAttribute("primary"));
                        String extraDir = configElements[j].getAttribute("extradir");
                        contributedTocFiles.add(new TocFile(pluginId, href, isPrimary, locale, extraDir, categoryId));
                    }
                } else if (configElements[j].getName().equals(INDEX_ELEMENT_NAME) && (path = configElements[j].getAttribute("path")) != null && path.length() != 0) {
                    this.contributingPlugins2IndexPaths.put(pluginId, path);
                }
                ++j;
            }
            ++i;
        }
        return contributedTocFiles;
    }

    private Map categorizeTocs(List tocs, List tocOrder) {
        HashMap<String, Object> categorized = new HashMap<String, Object>();
        Iterator iter = tocs.iterator();
        while (iter.hasNext()) {
            Toc toc = (Toc)iter.next();
            String categoryId = toc.getTocFile().getCategoryId();
            if (categoryId != null) {
                TocCategory category = (TocCategory)categorized.get(categoryId);
                if (category == null) {
                    category = new TocCategory(categoryId);
                    categorized.put(categoryId, category);
                    tocOrder.add(categoryId);
                }
                category.add(toc);
                continue;
            }
            categorized.put(toc.getHref(), toc);
            tocOrder.add(toc.getHref());
        }
        return categorized;
    }

    private static List substituteValues(List items, Map map) {
        if (items != null && map != null) {
            ArrayList result = new ArrayList(items.size());
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = map.get(key);
                if (value == null) continue;
                result.add(value);
            }
            return result;
        }
        return null;
    }

    private static class TocCategory
    extends ArrayList {
        private static final long serialVersionUID = 1L;
        private String id;

        public TocCategory(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

