/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class CachedManifest
extends Dictionary {
    Dictionary manifest = null;
    EclipseBundleData bundledata;

    public CachedManifest(EclipseBundleData bundledata) {
        this.bundledata = bundledata;
    }

    public Dictionary getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = this.bundledata.loadManifest();
            }
            catch (BundleException e) {
                String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CACHEDMANIFEST_UNEXPECTED_EXCEPTION, this.bundledata.getLocation());
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, e, null);
                EclipseAdaptor.getDefault().getFrameworkLog().log(entry);
                return null;
            }
        }
        return this.manifest;
    }

    public int size() {
        return this.getManifest().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration elements() {
        return this.getManifest().elements();
    }

    public Enumeration keys() {
        return this.getManifest().keys();
    }

    public Object get(Object key) {
        String keyString = (String)key;
        if ("Bundle-Version".equalsIgnoreCase(keyString)) {
            Version result = this.bundledata.getVersion();
            return result == null ? null : result.toString();
        }
        if ("Plugin-Class".equalsIgnoreCase(keyString)) {
            return this.bundledata.getPluginClass();
        }
        if ("Bundle-SymbolicName".equalsIgnoreCase(keyString)) {
            if ((this.bundledata.getType() & 8) == 0) {
                return this.bundledata.getSymbolicName();
            }
            return String.valueOf(this.bundledata.getSymbolicName()) + ';' + "singleton" + ":=true";
        }
        if ("Eclipse-BuddyPolicy".equalsIgnoreCase(keyString)) {
            return this.bundledata.getBuddyList();
        }
        if ("Eclipse-RegisterBuddy".equalsIgnoreCase(keyString)) {
            return this.bundledata.getRegisteredBuddyList();
        }
        Dictionary result = this.getManifest();
        return result == null ? null : result.get(key);
    }

    public Object remove(Object key) {
        return this.getManifest().remove(key);
    }

    public Object put(Object key, Object value) {
        return this.getManifest().put(key, value);
    }
}

