/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;

public class PermissionChecker {
    private BundleContext context;
    private boolean checkPermissions = false;

    public PermissionChecker(BundleContext context, boolean checkPermissions) {
        this.context = context;
        this.checkPermissions = checkPermissions;
    }

    public boolean checkImportPermission(ImportPackageSpecification ips, ExportPackageDescription epd) {
        if (!this.checkPermissions) {
            return true;
        }
        boolean success = true;
        Bundle exporter = this.context.getBundle(epd.getExporter().getBundleId());
        if (exporter != null && (exporter.getState() & 1) == 0) {
            success = exporter.hasPermission(new PackagePermission(epd.getName(), "export"));
        }
        Bundle importer = this.context.getBundle(ips.getBundle().getBundleId());
        if (success && importer != null && (importer.getState() & 1) == 0) {
            success = importer.hasPermission(new PackagePermission(ips.getName(), "import"));
        }
        return success;
    }

    public boolean checkBundlePermission(VersionConstraint vc, BundleDescription bd) {
        if (!this.checkPermissions) {
            return true;
        }
        boolean success = true;
        boolean requireBundle = vc instanceof BundleSpecification;
        Bundle provider = this.context.getBundle(bd.getBundleId());
        if (provider != null && (provider.getState() & 1) == 0) {
            success = provider.hasPermission(new BundlePermission(bd.getSymbolicName(), requireBundle ? "provide" : "host"));
        }
        Bundle requirer = this.context.getBundle(vc.getBundle().getBundleId());
        if (success && requirer != null && (requirer.getState() & 1) == 0) {
            success = requirer.hasPermission(new BundlePermission(vc.getName(), requireBundle ? "require" : "fragment"));
        }
        return success;
    }
}

