/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class InlineSchemaValidator
implements ErrorHandler,
NamespaceContext {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected PrintWriter fOut = new PrintWriter(System.out);
    protected HashMap fPrefixToURIMappings;
    protected HashMap fURIToPrefixMappings;

    public InlineSchemaValidator(HashMap hashMap, HashMap hashMap2) {
        this.fPrefixToURIMappings = hashMap;
        this.fURIToPrefixMappings = hashMap2;
    }

    public void validate(Validator validator, Source source, String string, int n, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            int n2 = 0;
            while (n2 < n) {
                validator.validate(source);
                ++n2;
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print((float)l / (float)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public String getNamespaceURI(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.fPrefixToURIMappings != null && (string2 = (String)this.fPrefixToURIMappings.get(string)) != null) {
            return string2;
        }
        return "";
    }

    public String getPrefix(String string) {
        HashSet hashSet;
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        if (this.fURIToPrefixMappings != null && (hashSet = (HashSet)this.fURIToPrefixMappings.get(string)) != null && hashSet.size() > 0) {
            return (String)hashSet.iterator().next();
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        HashSet hashSet;
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return new Iterator(){
                boolean more = true;

                public boolean hasNext() {
                    return this.more;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.more = false;
                    return "xml";
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return new Iterator(){
                boolean more = true;

                public boolean hasNext() {
                    return this.more;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.more = false;
                    return "xmlns";
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (this.fURIToPrefixMappings != null && (hashSet = (HashSet)this.fURIToPrefixMappings.get(string)) != null && hashSet.size() > 0) {
            return hashSet.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        HashSet<Object> hashSet;
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            InlineSchemaValidator.printUsage();
            System.exit(1);
        }
        Vector<Object> vector = null;
        Vector<Object> vector2 = null;
        HashMap<Object, String> hashMap = null;
        HashMap<String, HashSet<Object>> hashMap2 = null;
        String string = stringArray[stringArray.length - 1];
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            block72: {
                object3 = stringArray[n2];
                if (((String)object3).startsWith("-")) {
                    object2 = ((String)object3).substring(1);
                    if (((String)object2).equals("x")) {
                        if (++n2 == stringArray.length) {
                            System.err.println("error: Missing argument to -x option.");
                        } else {
                            object = stringArray[n2];
                            try {
                                int n3 = Integer.parseInt((String)object);
                                if (n3 < 1) {
                                    System.err.println("error: Repetition must be at least 1.");
                                    break block72;
                                }
                                n = n3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("error: invalid number (" + (String)object + ").");
                            }
                        }
                    } else if (((String)object3).equals("-a")) {
                        if (vector == null) {
                            vector = new Vector<Object>();
                        }
                        while (n2 + 1 < stringArray.length - 1 && !((String)(object3 = stringArray[n2 + 1])).startsWith("-")) {
                            vector.add(object3);
                            ++n2;
                        }
                    } else if (((String)object3).equals("-i")) {
                        if (vector2 == null) {
                            vector2 = new Vector<Object>();
                        }
                        while (n2 + 1 < stringArray.length - 1 && !((String)(object3 = stringArray[n2 + 1])).startsWith("-")) {
                            vector2.add(object3);
                            ++n2;
                        }
                    } else if (((String)object3).equals("-nm")) {
                        String string2;
                        while (n2 + 2 < stringArray.length - 1 && !((String)(object = stringArray[n2 + 1])).startsWith("-") && !(string2 = stringArray[n2 + 2]).startsWith("-")) {
                            if (hashMap == null) {
                                hashMap = new HashMap<Object, String>();
                                hashMap2 = new HashMap<String, HashSet<Object>>();
                            }
                            hashMap.put(object, string2);
                            hashSet = (HashSet)hashMap2.get(string2);
                            if (hashSet == null) {
                                hashSet = new HashSet<Object>();
                                hashMap2.put(string2, hashSet);
                            }
                            hashSet.add(object);
                            n2 += 2;
                        }
                    } else if (((String)object2).equalsIgnoreCase("f")) {
                        bl = ((String)object2).equals("f");
                    } else if (((String)object2).equalsIgnoreCase("hs")) {
                        bl2 = ((String)object2).equals("hs");
                    } else if (((String)object2).equalsIgnoreCase("va")) {
                        bl3 = ((String)object2).equals("va");
                    } else if (((String)object2).equalsIgnoreCase("ga")) {
                        bl4 = ((String)object2).equals("ga");
                    } else if (((String)object2).equalsIgnoreCase("m")) {
                        bl5 = ((String)object2).equals("m");
                    } else if (((String)object2).equals("h")) {
                        InlineSchemaValidator.printUsage();
                    } else {
                        System.err.println("error: unknown option (" + (String)object2 + ").");
                    }
                }
            }
            ++n2;
        }
        try {
            Object object4;
            int n4;
            int n5;
            Schema schema;
            Object object5;
            Object object6;
            object3 = new InlineSchemaValidator(hashMap, hashMap2);
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler((ErrorHandler)object3);
            Document document = ((DocumentBuilder)object).parse(string);
            hashSet = XPathFactory.newInstance();
            XPath xPath = ((XPathFactory)((Object)hashSet)).newXPath();
            xPath.setNamespaceContext((NamespaceContext)object3);
            NodeList[] nodeListArray = new NodeList[vector != null ? vector.size() : 0];
            int n6 = 0;
            while (n6 < nodeListArray.length) {
                object6 = xPath.compile((String)vector.elementAt(n6));
                nodeListArray[n6] = (NodeList)object6.evaluate(document, XPathConstants.NODESET);
                ++n6;
            }
            object6 = new NodeList[vector2 != null ? vector2.size() : 0];
            int n7 = 0;
            while (n7 < ((NodeList[])object6).length) {
                object5 = xPath.compile((String)vector2.elementAt(n7));
                object6[n7] = (NodeList)object5.evaluate(document, XPathConstants.NODESET);
                ++n7;
            }
            object5 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ((SchemaFactory)object5).setErrorHandler((ErrorHandler)object3);
            try {
                ((SchemaFactory)object5).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                ((SchemaFactory)object5).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                ((SchemaFactory)object5).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                ((SchemaFactory)object5).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            int n8 = 0;
            int n9 = 0;
            while (n9 < nodeListArray.length) {
                n8 += nodeListArray[n9].getLength();
                ++n9;
            }
            Object object7 = new DOMSource[n8];
            if (n8 == 0) {
                schema = ((SchemaFactory)object5).newSchema();
            } else {
                n5 = 0;
                n4 = 0;
                while (n4 < nodeListArray.length) {
                    object4 = nodeListArray[n4];
                    int n10 = object4.getLength();
                    int n11 = 0;
                    while (n11 < n10) {
                        object7[n5++] = new DOMSource(object4.item(n11));
                        ++n11;
                    }
                    ++n4;
                }
                schema = ((SchemaFactory)object5).newSchema((Source[])object7);
            }
            object7 = schema.newValidator();
            ((Validator)object7).setErrorHandler((ErrorHandler)object3);
            try {
                ((Validator)object7).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                ((Validator)object7).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                ((Validator)object7).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                ((Validator)object7).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            int n12 = 0;
            while (n12 < ((Object)object6).length) {
                Object object8 = object6[n12];
                n5 = object8.getLength();
                n4 = 0;
                while (n4 < n5) {
                    object4 = new DOMSource(object8.item(n4));
                    ((DOMSource)object4).setSystemId(string);
                    ((InlineSchemaValidator)object3).validate((Validator)object7, (Source)object4, string, n, bl5);
                    ++n4;
                }
                ++n12;
            }
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            Object object9;
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                object9 = object;
            }
            ((Throwable)object9).printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.InlineSchemaValidator (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -x number        Select number of repetitions.");
        System.err.println("  -a xpath    ...  Provide a list of XPath expressions for schema roots");
        System.err.println("  -i xpath    ...  Provide a list of XPath expressions for validation roots");
        System.err.println("  -nm pre uri ...  Provide a list of prefix to namespace URI mappings for the XPath expressions.");
        System.err.println("  -f  | -F         Turn on/off Schema full checking.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs | -HS        Turn on/off honouring of all schema locations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va | -VA        Turn on/off validation of schema annotations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga | -GA        Turn on/off generation of synthetic schema annotations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -m  | -M         Turn on/off memory usage report");
        System.err.println("  -h               This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Repetition:                      1");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:  ");
        System.err.println("off");
        System.err.print("  Memory:                          ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document validations within the");
        System.err.println("  same virtual machine to remove class loading from parse time and memory usage.");
    }
}

