/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.components.framework.Components;
import org.eclipse.ui.internal.components.framework.IDisposable;
import org.eclipse.ui.internal.part.Part;
import org.eclipse.ui.internal.part.components.services.IActionBarContributor;
import org.eclipse.ui.internal.part.components.services.IActionBarContributorFactory;
import org.eclipse.ui.internal.part.components.services.IPartActionBars;
import org.eclipse.ui.internal.part.components.services.IPartDescriptor;
import org.eclipse.ui.internal.part.components.services.IStatusFactory;
import org.eclipse.ui.internal.part.components.services.IStatusHandler;
import org.eclipse.ui.internal.part.services.NullPartDescriptor;
import org.eclipse.ui.internal.part.services.PartToEditorActionBarsAdapter;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class ActionBarContributorFactory
implements IActionBarContributorFactory,
IDisposable {
    private IActionBars2 partToEditorActionBars;
    private IWorkbenchPage page;
    private Map actionCache = new HashMap();
    private NullActivator nullActivator = new NullActivator();

    public ActionBarContributorFactory(IPartActionBars parent, IWorkbenchPage page, IStatusHandler handler, IStatusFactory factory) {
        this.partToEditorActionBars = new PartToEditorActionBarsAdapter(parent, handler, factory);
        this.page = page;
    }

    public void activateBars(IActionBarContributor toActivate, Part actualPart) {
        if (toActivate instanceof EditorActionBarActivator) {
            EditorActionBarActivator eaba = (EditorActionBarActivator)toActivate;
            eaba.activate(actualPart);
        }
    }

    public void deactivateBars(IActionBarContributor toDeactivate) {
        if (toDeactivate instanceof EditorActionBarActivator) {
            EditorActionBarActivator eaba = (EditorActionBarActivator)toDeactivate;
            eaba.deactivate();
        }
    }

    public IActionBarContributor getContributor(IPartDescriptor descriptor) {
        String id = descriptor.getId();
        IEditorRegistry reg = WorkbenchPlugin.getDefault().getEditorRegistry();
        EditorDescriptor desc = (EditorDescriptor)reg.findEditor(id);
        if (desc == null) {
            return this.nullActivator;
        }
        EditorActionBarActivator activator = (EditorActionBarActivator)this.actionCache.get(id);
        if (activator == null) {
            EditorActionBuilder builder;
            EditorActionBars actionBars = new EditorActionBars(this.partToEditorActionBars, id);
            IEditorActionBarContributor contr = desc.createActionBarContributor();
            if (contr != null) {
                actionBars.setEditorContributor(contr);
                contr.init(actionBars, this.page);
            }
            if ((contr = (builder = new EditorActionBuilder()).readActionExtensions(desc)) != null) {
                actionBars.setExtensionContributor(contr);
                contr.init(actionBars, this.page);
            }
            activator = new EditorActionBarActivator(actionBars, descriptor);
            this.actionCache.put(id, activator);
        }
        activator.actionBars.addRef();
        return activator;
    }

    public void dispose() {
        Collection activators = this.actionCache.values();
        Iterator iter = activators.iterator();
        while (iter.hasNext()) {
            EditorActionBarActivator next = (EditorActionBarActivator)iter.next();
            next.actionBars.dispose();
        }
        this.actionCache.clear();
    }

    private class NullActivator
    implements IActionBarContributor {
        IPartDescriptor descriptor = new NullPartDescriptor();

        NullActivator() {
        }

        public void dispose() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IPartDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    private class EditorActionBarActivator
    implements IActionBarContributor {
        EditorActionBars actionBars;
        IPartDescriptor descriptor;
        IEditorPart activePart = null;
        boolean isActive = false;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        EditorActionBarActivator(EditorActionBars actionBars, IPartDescriptor descriptor) {
            this.actionBars = actionBars;
            this.descriptor = descriptor;
        }

        public void dispose() {
            if (this.actionBars == null) {
                return;
            }
            this.actionBars.removeRef();
            if (this.actionBars.getRef() <= 0) {
                String type = this.actionBars.getEditorType();
                ActionBarContributorFactory.this.actionCache.remove(type);
                this.actionBars.dispose();
                this.actionBars = null;
            }
        }

        public Object getAdapter(Class adapter) {
            if (this.actionBars == null) {
                return null;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.IEditorActionBarContributor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this.actionBars.getEditorContributor();
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.IActionBars");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                return this.actionBars;
            }
            return null;
        }

        public IPartDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void activate(Part activePart) {
            if (this.actionBars == null) {
                return;
            }
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.IEditorPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IEditorPart editor = (IEditorPart)Components.getAdapter(activePart, clazz);
            if (!this.isActive) {
                this.isActive = true;
                this.actionBars.activate(true);
            }
            if (editor != activePart) {
                this.actionBars.partChanged(editor);
                this.activePart = editor;
            }
            this.actionBars.updateActionBars();
        }

        public void deactivate() {
            if (this.actionBars == null) {
                return;
            }
            if (!this.isActive) {
                return;
            }
            this.actionBars.deactivate(true);
            this.isActive = false;
        }
    }
}

