/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.part.components.services.IStatusFactory;
import org.osgi.framework.Bundle;

public class StatusFactory
implements IStatusFactory {
    private Bundle pluginBundle;

    public StatusFactory(Bundle context) {
        this.pluginBundle = context;
    }

    public IStatus newError(Throwable t) {
        String message = StatusUtil.getLocalizedMessage(t);
        return this.newError(message, t);
    }

    public IStatus newError(String message, Throwable t) {
        String pluginId = this.pluginBundle.getSymbolicName();
        int errorCode = 0;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            pluginId = ce.getStatus().getPlugin();
            errorCode = ce.getStatus().getCode();
        }
        return new Status(4, pluginId, errorCode, message, StatusUtil.getCause(t));
    }

    public IStatus newStatus(int severity, String message) {
        return new Status(severity, this.pluginBundle.getSymbolicName(), 0, message, null);
    }

    public IStatus newMessage(String message) {
        return this.newStatus(1, message);
    }
}

