/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ErrorInfo;
import org.eclipse.ui.internal.progress.ErrorNotificationManager;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.IProgressConstants;

public class JobErrorDialog
extends ErrorDialog {
    private static final String PREF_SKIP_GOTO_ACTION_PROMPT = "pref_skip_goto_action_prompt";
    private static final int GOTO_ACTION_ID = 1025;
    private TableViewer jobListViewer;
    private ErrorInfo selectedError;

    public JobErrorDialog(Shell parentShell, String title, String msg, ErrorInfo errorInfo, int displayMask) {
        super(parentShell, title == null ? errorInfo.getJob().getName() : title, msg, errorInfo.getErrorStatus(), displayMask);
        this.setShellStyle(0x8F0 | JobErrorDialog.getDefaultOrientation());
        this.selectedError = errorInfo;
        this.setBlockOnOpen(false);
    }

    void refresh() {
        if (AUTOMATED_MODE) {
            return;
        }
        if (this.dialogArea == null || this.dialogArea.isDisposed()) {
            return;
        }
        if (this.isMultipleJobErrors()) {
            if (this.jobListViewer == null) {
                this.setMessage(ProgressMessages.JobErrorDialog_MultipleErrorsMessage);
                this.getShell().setText(ProgressMessages.JobErrorDialog_MultipleErrorsTitle);
                this.createJobListArea((Composite)this.dialogArea);
                this.showDetailsArea();
            }
            this.refreshJobList();
        }
        this.updateEnablements();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        IAction gotoAction = this.getGotoAction();
        String text = null;
        if (gotoAction != null) {
            text = gotoAction.getText();
        }
        if (text == null) {
            text = ProgressMessages.JobErrorDialog_CustomJobText;
        }
        this.createButton(parent, 1025, text, false);
        super.createButtonsForButtonBar(parent);
    }

    private void updateEnablements() {
        Button gotoButton;
        Button details = this.getButton(13);
        if (details != null) {
            details.setEnabled(this.selectedError.getErrorStatus().isMultiStatus() || this.isMultipleJobErrors());
        }
        if ((gotoButton = this.getButton(1025)) != null) {
            IAction gotoAction = this.getGotoAction();
            boolean hasValidGotoAction = gotoAction != null;
            String text = gotoButton.getText();
            String newText = null;
            if (hasValidGotoAction) {
                newText = gotoAction.getText();
            }
            if (newText == null) {
                hasValidGotoAction = false;
                newText = ProgressMessages.JobErrorDialog_CustomJobText;
            }
            if (!newText.equals(text)) {
                gotoButton.setText(newText);
            }
            gotoButton.setEnabled(hasValidGotoAction);
            gotoButton.setVisible(hasValidGotoAction);
        }
    }

    protected void buttonPressed(int id) {
        IAction gotoAction;
        if (id == 1025 && (gotoAction = this.getGotoAction()) != null && (!this.isMultipleJobErrors() || this.isPromptToClose())) {
            this.okPressed();
            gotoAction.run();
        }
        super.buttonPressed(id);
    }

    private boolean isPromptToClose() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!store.contains(PREF_SKIP_GOTO_ACTION_PROMPT) || !store.getString(PREF_SKIP_GOTO_ACTION_PROMPT).equals("always")) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)ProgressMessages.JobErrorDialog_CloseDialogTitle, (String)ProgressMessages.JobErrorDialog_CloseDialogMessage, (String)ProgressMessages.JobErrorDialog_DoNotShowAgainMessage, (boolean)false, (IPreferenceStore)store, (String)PREF_SKIP_GOTO_ACTION_PROMPT);
            return dialog.getReturnCode() == 0;
        }
        return true;
    }

    private IAction getGotoAction() {
        Object property = this.selectedError.getJob().getProperty(IProgressConstants.ACTION_PROPERTY);
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(this.message);
    }

    private void createJobListArea(Composite parent) {
        this.jobListViewer = new TableViewer(parent, 2820);
        this.jobListViewer.setSorter(this.getViewerSorter());
        Control control = this.jobListViewer.getControl();
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)data);
        this.initContentProvider();
        this.initLabelProvider();
        this.jobListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JobErrorDialog.this.handleSelectionChange();
            }
        });
        JobErrorDialog.applyDialogFont((Control)parent);
    }

    private boolean isMultipleJobErrors() {
        return this.getManager().getErrors().size() > 1;
    }

    private ErrorNotificationManager getManager() {
        return ProgressManager.getInstance().errorManager;
    }

    public ErrorInfo getSelectedError() {
        return this.selectedError;
    }

    private ViewerSorter getViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    protected void initContentProvider() {
        IStructuredContentProvider provider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return JobErrorDialog.this.getManager().getErrors().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    JobErrorDialog.this.refreshJobList();
                }
            }
        };
        this.jobListViewer.setContentProvider((IContentProvider)provider);
        this.jobListViewer.setInput((Object)this.getManager());
        this.jobListViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedError));
    }

    void refreshJobList() {
        if (this.jobListViewer != null && !this.jobListViewer.getControl().isDisposed()) {
            this.jobListViewer.refresh();
            Point newSize = this.getShell().computeSize(-1, -1);
            this.getShell().setSize(newSize);
        }
        this.setStatus(this.selectedError.getErrorStatus());
    }

    private void initLabelProvider() {
        ITableLabelProvider provider = new ITableLabelProvider(){
            Map imageTable = new HashMap();

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
                if (!this.imageTable.isEmpty()) {
                    Iterator iter = this.imageTable.values().iterator();
                    while (iter.hasNext()) {
                        Image image = (Image)iter.next();
                        image.dispose();
                    }
                }
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return this.getIcon(((ErrorInfo)element).getJob());
            }

            private Image getIcon(Job job) {
                if (job != null) {
                    Object property = job.getProperty(IProgressConstants.ICON_PROPERTY);
                    Image im = (Image)this.imageTable.get(property);
                    if (im != null) {
                        return im;
                    }
                    Display display = JobErrorDialog.this.getShell().getDisplay();
                    if (property instanceof ImageDescriptor) {
                        im = ((ImageDescriptor)property).createImage((Device)display);
                        this.imageTable.put(property, im);
                    } else if (property instanceof URL) {
                        im = ImageDescriptor.createFromURL((URL)((URL)property)).createImage((Device)display);
                        this.imageTable.put(property, im);
                    } else {
                        im = ProgressManager.getInstance().getIconFor(job);
                    }
                    return im;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ErrorInfo)element).getDisplayString();
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.jobListViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    private ErrorInfo getSingleSelection() {
        IStructuredSelection selection;
        ISelection rawSelection = this.jobListViewer.getSelection();
        if (rawSelection != null && rawSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)rawSelection).size() == 1) {
            return (ErrorInfo)selection.getFirstElement();
        }
        return null;
    }

    public boolean close() {
        Rectangle shellPosition = this.getShell().getBounds();
        boolean result = super.close();
        ProgressManagerUtil.animateDown(shellPosition);
        ProgressManager.getInstance().errorManager.dialogClosed();
        return result;
    }

    protected void initializeBounds() {
        this.refresh();
        super.initializeBounds();
        Rectangle shellPosition = this.getShell().getBounds();
        ProgressManagerUtil.animateUp(shellPosition);
    }

    void handleSelectionChange() {
        ErrorInfo newSelection = this.getSingleSelection();
        if (newSelection != null && newSelection != this.selectedError) {
            this.selectedError = newSelection;
            this.setStatus(this.selectedError.getErrorStatus());
            this.updateEnablements();
            this.showDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return true;
    }
}

