/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.datamodel;

import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DaRuMaFeatureType {
    private String targetNS;
    private String typeName;
    private DaRuMaServer server;

    public DaRuMaFeatureType(DaRuMaServer server) {
        this.server = server;
    }

    public static DaRuMaFeatureType makeFeatureType(DaRuMaServer server, String name) {
        Pattern pattern;
        Matcher matcher;
        DaRuMaFeatureType featureType = new DaRuMaFeatureType(server);
        if (name != null && name.length() > 0 && (matcher = (pattern = Pattern.compile("^\\{(.+)\\}(.+)$")).matcher(name)).find()) {
            featureType.targetNS = matcher.group(1);
            featureType.typeName = matcher.group(2);
            return featureType;
        }
        return null;
    }

    public String getTargetNS() {
        return this.targetNS;
    }

    public void setTargetNS(String targetNS) {
        this.targetNS = targetNS;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getName() {
        return "{" + this.targetNS + "}" + this.typeName;
    }

    public void copyTo(DaRuMaFeatureType dst) {
        dst.targetNS = this.targetNS;
        dst.typeName = this.typeName;
        dst.server = this.server;
    }

    public DaRuMaServer getServer() {
        return this.server;
    }
}

