/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.dialogs;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.dialogs.GenericDialog;
import daruma.client.darumaviewer.dialogs.ThreadDialogRunnable;
import daruma.client.darumaviewer.views.SwtUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ThreadDialog
extends GenericDialog {
    private ThreadDialogThread thread = null;
    private ThreadDialogRunnable runner;
    private String displayMsg;
    private Label lblMsg;
    private Button btnClose;
    private Text txtStdIn;
    private StringBuffer bufStdIn = new StringBuffer();
    private String strStdInLatest = "";
    private Text txtStdErr;
    private StringBuffer bufStdErr = new StringBuffer();
    private String strStdErrLatest = "";
    public static int CONSOLE_MAX_SIZE = 131072;
    private int returnVal;
    private boolean autoClose = false;

    public ThreadDialog(Shell parentShell, String title, String displayMsg, ThreadDialogRunnable runner, boolean autoClose) {
        super(parentShell, title, 600, autoClose ? 160 : 440);
        super.setOkText("");
        super.setCancelText("");
        this.runner = runner;
        this.displayMsg = displayMsg;
        this.autoClose = autoClose;
    }

    public int open() {
        this.setAllowEscape(false);
        this.setAllowClose(false);
        this.thread = new ThreadDialogThread(this, this.runner);
        this.thread.start();
        super.open();
        this.runner.stop();
        this.runner = null;
        this.thread = null;
        return this.returnVal;
    }

    public void createPropertyDialogArea(Composite composite) {
        composite.setLayout((Layout)SwtUtil.makeGridLayout(1));
        new Label(composite, 0).setText("");
        this.lblMsg = new Label(composite, 0);
        this.lblMsg.setText(this.displayMsg);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)SwtUtil.makeVarGridData(500, 400, 1));
        TabItem tabStdIn = new TabItem(tabFolder, 0);
        Composite compTab = new Composite((Composite)tabFolder, 0);
        tabStdIn.setText(Messages.getString("ThreadDialog.4"));
        tabStdIn.setControl((Control)compTab);
        compTab.setLayout((Layout)SwtUtil.makeGridLayout(1));
        this.txtStdIn = new Text(compTab, 2826);
        this.txtStdIn.setLayoutData((Object)SwtUtil.makeVarGridData(500, 400, 1));
        TabItem tabStdErr = new TabItem(tabFolder, 0);
        compTab = new Composite((Composite)tabFolder, 0);
        tabStdErr.setText(Messages.getString("ThreadDialog.5"));
        tabStdErr.setControl((Control)compTab);
        compTab.setLayout((Layout)SwtUtil.makeGridLayout(1));
        this.txtStdErr = new Text(compTab, 2826);
        this.txtStdErr.setLayoutData((Object)SwtUtil.makeVarGridData(500, 400, 1));
        tabFolder.setVisible(!this.autoClose);
        this.btnClose = new Button(composite, 0);
        this.btnClose.addSelectionListener((SelectionListener)new BtnCloseSelectionListener(this));
        this.btnClose.setText(Messages.getString("ThreadDialog.1"));
    }

    public void dialogClose(boolean flgCancel) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void addToConsole(char[] buf, int start, int len, boolean stderr) {
        if (stderr) {
            this.bufStdErr.append(buf, start, len);
            this.strStdErrLatest = String.valueOf(this.strStdErrLatest) + new String(buf, start, len);
        } else {
            this.bufStdIn.append(buf, start, len);
            this.strStdInLatest = String.valueOf(this.strStdInLatest) + new String(buf, start, len);
        }
    }

    public void refreshConsole() {
        if (this.bufStdIn.length() > CONSOLE_MAX_SIZE) {
            this.bufStdIn.delete(0, this.bufStdIn.length() - CONSOLE_MAX_SIZE);
            this.txtStdIn.setText(this.bufStdIn.toString());
            this.txtStdIn.append("");
        } else {
            this.txtStdIn.append(this.strStdInLatest);
        }
        this.strStdInLatest = "";
        if (this.bufStdErr.length() > CONSOLE_MAX_SIZE) {
            this.bufStdErr.delete(0, this.bufStdErr.length() - CONSOLE_MAX_SIZE);
            this.txtStdErr.setText(this.bufStdErr.toString());
            this.txtStdErr.append("");
        } else {
            this.txtStdErr.append(this.strStdErrLatest);
        }
        this.strStdErrLatest = "";
    }

    private class ThreadDialogThread
    extends Thread {
        ThreadDialog dialog;
        ThreadDialogRunnable runner;

        public ThreadDialogThread(ThreadDialog dialog, ThreadDialogRunnable runner) {
            this.dialog = dialog;
            this.runner = runner;
        }

        public void run() {
            try {
                ThreadDialog.this.returnVal = this.runner.run();
            }
            catch (Exception exception) {
                ThreadDialog.this.returnVal = -1;
            }
            Display display = this.dialog.getShell().getDisplay();
            if (!display.isDisposed()) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (ThreadDialogThread.this.dialog.autoClose) {
                            ThreadDialogThread.this.dialog.close();
                        } else {
                            ThreadDialogThread.this.dialog.txtStdIn.append("\r\n");
                            ThreadDialogThread.this.dialog.txtStdErr.append("\r\n");
                            ThreadDialogThread.this.dialog.lblMsg.setText(Messages.getString("ThreadDialog.2"));
                            ThreadDialog.this.btnClose.setText(Messages.getString("ThreadDialog.3"));
                        }
                    }
                };
                display.syncExec(r);
            }
        }
    }

    public class BtnCloseSelectionListener
    implements SelectionListener {
        ThreadDialog dialog;

        public BtnCloseSelectionListener(ThreadDialog dialog) {
            this.dialog = dialog;
        }

        public void widgetSelected(SelectionEvent e) {
            if (ThreadDialog.this.thread != null && ThreadDialog.this.thread.isAlive()) {
                ThreadDialog.this.runner.stop();
            } else {
                this.dialog.close();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

