/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.prefs;

import daruma.client.darumaviewer.DaRuMaViewerPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class DaRuMaViewerPreference {
    public static final String P_SERVERS = "Servers";
    public static final String P_DEBUG = "Debug";
    public static final String P_CLIENT_TOOL_DIR = "ClientToolDir";
    public static final String P_WORK_DIR = "WorkDir";
    public static final String P_DISPLAY_TARGET_NS = "DisplayTargetNS";
    private String servers;
    private boolean debug = false;
    private String clientToolDir = "";
    private String workDir = "./work";
    private boolean displayTargetNS = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void load() {
        Preferences pref = DaRuMaViewerPlugin.getPreferences();
        this.servers = pref.getString(P_SERVERS);
        this.clientToolDir = pref.getString(P_CLIENT_TOOL_DIR);
        this.workDir = pref.getString(P_WORK_DIR);
        this.debug = pref.getBoolean(P_DEBUG);
        this.displayTargetNS = pref.getBoolean(P_DISPLAY_TARGET_NS);
    }

    public void save() {
        Preferences pref = DaRuMaViewerPlugin.getPreferences();
        pref.setValue(P_SERVERS, this.servers);
        pref.setValue(P_CLIENT_TOOL_DIR, this.clientToolDir);
        pref.setValue(P_WORK_DIR, this.workDir);
        pref.setValue(P_DEBUG, this.debug);
        pref.setValue(P_DISPLAY_TARGET_NS, this.displayTargetNS);
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getClientToolDir() {
        return this.clientToolDir;
    }

    public void setClientToolDir(String clientToolPath) {
        this.clientToolDir = clientToolPath.replaceAll("\\\\", "/");
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir.replaceAll("\\\\", "/");
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDisplayTargetNS() {
        return this.displayTargetNS;
    }

    public void setDisplayTargetNS(boolean displayTargetNS) {
        this.displayTargetNS = displayTargetNS;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        store.setDefault(P_SERVERS, "localhost:5050");
        store.setDefault(P_DEBUG, false);
        store.setDefault(P_CLIENT_TOOL_DIR, "");
        store.setDefault(P_WORK_DIR, "./work");
        store.setDefault(P_DISPLAY_TARGET_NS, true);
    }
}

