/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.views;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureTypeInfo;
import daruma.client.darumaviewer.views.DaRuMaViewerView;
import daruma.client.darumaviewer.views.SwtUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class FeatureTypeView
extends ViewPart {
    public static final String ID = FeatureTypeView.class.getName();
    private Button btnSchemaUpdate;
    private Button btnCountUpdate;
    private Label lblSts;
    private Text txtServer;
    private Text txtTargetNS;
    private Text txtTypeName;
    private Text txtCount;
    private Text txtSchema;
    private DaRuMaFeatureType currType = null;
    private DaRuMaFeatureTypeInfo currInfo = null;
    public FeatureTypeViewSelectionListener listener;

    public void createPartControl(Composite parent) {
        int colNum = 3;
        this.listener = new FeatureTypeViewSelectionListener();
        parent.setLayout((Layout)SwtUtil.makeGridLayout(colNum));
        new Label(parent, 0).setText(Messages.getString("FeatureTypeView.4"));
        this.txtServer = new Text(parent, 2056);
        this.txtServer.setLayoutData((Object)SwtUtil.makeHorVarGridData(100, 0, colNum - 1));
        new Label(parent, 0).setText(Messages.getString("FeatureTypeView.0"));
        this.txtTargetNS = new Text(parent, 2056);
        this.txtTargetNS.setLayoutData((Object)SwtUtil.makeHorVarGridData(100, 0, colNum - 1));
        new Label(parent, 0).setText(Messages.getString("FeatureTypeView.1"));
        this.txtTypeName = new Text(parent, 2056);
        this.txtTypeName.setLayoutData((Object)SwtUtil.makeHorVarGridData(100, 0, colNum - 1));
        new Label(parent, 0).setText(Messages.getString("FeatureTypeView.2"));
        this.txtCount = new Text(parent, 2056);
        this.txtCount.setLayoutData((Object)SwtUtil.makeFixedGridData(100, 0, 1));
        this.btnCountUpdate = new Button(parent, 0);
        this.btnCountUpdate.setText(Messages.getString("FeatureTypeView.11"));
        this.btnCountUpdate.addSelectionListener((SelectionListener)this.listener);
        this.btnCountUpdate.setLayoutData((Object)SwtUtil.makeFixedGridData(100, 0, colNum - 2));
        new Label(parent, 0).setText(Messages.getString("FeatureTypeView.3"));
        new Label(parent, 0).setText("");
        this.btnSchemaUpdate = new Button(parent, 0);
        this.btnSchemaUpdate.setText(Messages.getString("FeatureTypeView.7"));
        this.btnSchemaUpdate.addSelectionListener((SelectionListener)this.listener);
        this.btnSchemaUpdate.setLayoutData((Object)SwtUtil.makeFixedGridData(100, 0, colNum - 2));
        this.txtSchema = new Text(parent, 2826);
        this.txtSchema.setLayoutData((Object)SwtUtil.makeVarGridData(100, 100, colNum));
        this.lblSts = new Label(parent, 0);
        this.lblSts.setLayoutData((Object)SwtUtil.makeHorVarGridData(100, 0, colNum));
    }

    public void setFeatureType(DaRuMaFeatureType type) {
        this.currType = type;
        this.currInfo = new DaRuMaFeatureTypeInfo(this.currType);
        this.update(true, true);
    }

    private boolean update(boolean blSchema, boolean blCount) {
        boolean rc = false;
        this.btnSchemaUpdate.setEnabled(false);
        this.btnCountUpdate.setEnabled(false);
        this.lblSts.setText(Messages.getString("FeatureTypeView.8"));
        try {
            if (blSchema) {
                this.currInfo.setSchema("");
            }
            if (blCount) {
                this.currInfo.setCount(-1);
            }
            this.display();
            if (!DaRuMaViewerView.dftService.getFeatureTypeInfo(DaRuMaViewerView.dftPref, this.currInfo, blSchema, blCount)) {
                SwtUtil.showError(String.valueOf(Messages.getString("FeatureTypeView.5")) + this.currType.getName() + Messages.getString("FeatureTypeView.6"));
            } else {
                this.display();
                rc = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblSts.setText(rc ? Messages.getString("FeatureTypeView.9") : Messages.getString("FeatureTypeView.10"));
        this.btnSchemaUpdate.setEnabled(true);
        this.btnCountUpdate.setEnabled(true);
        return rc;
    }

    private void display() {
        this.setPartName(String.valueOf(this.currType.getTypeName()) + "@" + this.currType.getServer().getHost());
        this.txtServer.setText(this.currType.getServer().getName());
        this.txtTargetNS.setText(this.currType.getTargetNS());
        this.txtTypeName.setText(this.currType.getTypeName());
        this.txtCount.setText(this.currInfo.getCount() < 0 ? "" : "" + this.currInfo.getCount());
        this.txtSchema.setText(this.currInfo.getSchema());
    }

    public void setFocus() {
    }

    class FeatureTypeViewSelectionListener
    implements SelectionListener {
        FeatureTypeViewSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == FeatureTypeView.this.btnSchemaUpdate) {
                FeatureTypeView.this.update(true, false);
            } else if (e.widget == FeatureTypeView.this.btnCountUpdate) {
                FeatureTypeView.this.update(false, true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

