/*
 * Decompiled with CFR 0.152.
 */
package daruma.client.darumaviewer.views;

import daruma.client.darumaviewer.DaRuMaViewerPlugin;
import daruma.client.darumaviewer.Messages;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SwtUtil {
    public static GridLayout makeGridLayout(int gridCol) {
        GridLayout layout = new GridLayout(gridCol, false);
        layout.verticalSpacing = 8;
        layout.horizontalSpacing = 8;
        return layout;
    }

    public static GridData makeFixedGridData(int width, int height, int hSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, -1, 32);
    }

    public static GridData makeFixedGridData(int width, int height, int hSpan, int vSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, vSpan, 32);
    }

    public static GridData makeVarGridData(int width, int height, int hSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, -1, 1840);
    }

    public static GridData makeVarGridData(int width, int height, int hSpan, int vSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, vSpan, 1840);
    }

    public static GridData makeMaximumGridData() {
        return SwtUtil.makeGridData(-1, -1, -1, -1, 1840);
    }

    public static GridData makeHorVarGridData(int width, int height, int hSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, -1, 800);
    }

    public static GridData makeHorVarGridData(int width, int height, int hSpan, int vSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, vSpan, 800);
    }

    public static GridData makeVerVarGridData(int width, int height, int hSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, -1, 1072);
    }

    public static GridData makeVerVarGridData(int width, int height, int hSpan, int vSpan) {
        return SwtUtil.makeGridData(width, height, hSpan, vSpan, 1072);
    }

    private static GridData makeGridData(int width, int height, int hSpan, int vSpan, int flg) {
        GridData gridData = new GridData(flg);
        if (width > 0) {
            gridData.widthHint = width;
        }
        if (height > 0) {
            gridData.heightHint = height;
        }
        if (hSpan > 0) {
            gridData.horizontalSpan = hSpan;
        }
        if (vSpan > 0) {
            gridData.verticalSpan = vSpan;
        }
        return gridData;
    }

    public static IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public static IViewPart showView(IFolderLayout layout, String id) {
        IViewPart view = null;
        IWorkbenchPage page = SwtUtil.getPage();
        try {
            if (page != null) {
                view = page.findView(id);
                if (view == null && layout != null) {
                    layout.addView(id);
                }
                view = page.showView(id, null, 1);
            }
        }
        catch (PartInitException e) {
            view = null;
            e.printStackTrace();
        }
        return view;
    }

    public static void hideView(String id) {
        try {
            IViewPart view = SwtUtil.findView(id);
            IWorkbenchPage page = SwtUtil.getPage();
            if (page != null && view != null) {
                page.hideView(view);
            }
        }
        catch (Exception exception) {}
    }

    public static void hideView(IViewPart view) {
        try {
            IWorkbenchPage page = view.getSite().getPage();
            if (page != null) {
                page.hideView(view);
            }
        }
        catch (Exception exception) {}
    }

    public static IViewPart findView(String id) {
        IViewPart view = null;
        IWorkbenchPage page = SwtUtil.getPage();
        if (page != null) {
            view = SwtUtil.getPage().findView(id);
        }
        return view;
    }

    public static IViewPart showView(IFolderLayout layout, String id, String secondaryId) {
        IViewPart view = null;
        IWorkbenchPage page = SwtUtil.getPage();
        try {
            if (page != null) {
                view = page.showView(id, secondaryId, 1);
            }
        }
        catch (PartInitException e) {
            view = null;
            e.printStackTrace();
        }
        return view;
    }

    public static void setupTable(Table table, String[] cols, int[] widths) {
        int i = 0;
        while (i < cols.length) {
            TableColumn col = new TableColumn(table, 16384);
            col.setText(cols[i]);
            col.setWidth(widths[i]);
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public static Image makeImg(int width, int height) {
        Display display = Display.getCurrent();
        try {
            Image img = new Image((Device)display, width, height);
            return img;
        }
        catch (Exception exception) {
            System.out.println("Fail to make image");
            return null;
        }
    }

    public static Image loadImg(String name) {
        Display display = Display.getCurrent();
        try {
            URL url = DaRuMaViewerPlugin.getDefault().find((IPath)new Path(name));
            Image img = new Image((Device)display, url.openStream());
            return img;
        }
        catch (Exception exception) {
            System.out.println("Fail to load image " + name);
            return null;
        }
    }

    public static ImageDescriptor loadImageDescriptor(String name) {
        try {
            URL url = DaRuMaViewerPlugin.getDefault().find((IPath)new Path(name));
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)url);
            return img;
        }
        catch (Exception exception) {
            System.out.println("Fail to load image " + name);
            return null;
        }
    }

    public static void expandToLevel(TreeViewer tree, Object obj, int level) {
        tree.getTree().setRedraw(false);
        if (obj == null) {
            tree.expandToLevel(level);
        } else {
            tree.expandToLevel(obj, level);
        }
        tree.getTree().setRedraw(true);
    }

    public static boolean showQuestion(String msg) {
        return MessageDialog.openQuestion(null, (String)Messages.getString("SwtUtil.0"), (String)msg);
    }

    public static void showInfo(String msg) {
        MessageDialog.openInformation(null, (String)Messages.getString("SwtUtil.1"), (String)msg);
    }

    public static void showError(String msg) {
        MessageDialog.openError(null, (String)Messages.getString("SwtUtil.2"), (String)msg);
    }

    public static class DirectoryButtonListener
    implements SelectionListener {
        private Text currText;

        public DirectoryButtonListener(Text txt) {
            this.currText = txt;
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog dialog = new DirectoryDialog(this.currText.getShell());
            String dir = dialog.open();
            if (dir != null && this.currText.isEnabled()) {
                this.currText.setText(dir);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public static class FileButtonListener
    implements SelectionListener {
        private Text currText;

        public FileButtonListener(Text txt) {
            this.currText = txt;
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(this.currText.getShell());
            String dir = dialog.open();
            if (dir != null && this.currText.isEnabled()) {
                this.currText.setText(dir);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public static class TextDropTargetListener
    implements DropTargetListener {
        private Text currText;
        private FileTransfer fileTransfer;

        public static TextDropTargetListener makeTextDropTargetListener(Text currText) {
            TextDropTargetListener listener = new TextDropTargetListener();
            FileTransfer fileTransfer = FileTransfer.getInstance();
            listener.currText = currText;
            listener.fileTransfer = fileTransfer;
            Transfer[] types = new Transfer[]{fileTransfer};
            int operations = 19;
            DropTarget source = new DropTarget((Control)currText, operations);
            source.setTransfer(types);
            source.addDropListener((DropTargetListener)listener);
            return listener;
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files;
            if (this.fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0 && this.currText.isEnabled()) {
                this.currText.setText(files[0]);
            }
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }
    }
}

