/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private Object token;

    public EclipseBundleListener(ExtensionRegistry registry, Object key) {
        this.registry = registry;
        this.token = key;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i]);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        this.registry.remove(Long.toString(bundle.getBundleId()));
    }

    private void addBundle(Bundle bundle) {
        Bundle[] hosts;
        String contributorId = Long.toString(bundle.getBundleId());
        if (this.registry.hasContribution(contributorId)) {
            return;
        }
        if (bundle.getBundleId() == 0L) {
            return;
        }
        if (bundle.getSymbolicName() == null) {
            return;
        }
        if (!this.isSingleton(bundle)) {
            return;
        }
        boolean isFragment = OSGIUtils.getDefault().isFragment(bundle);
        if (isFragment && (hosts = OSGIUtils.getDefault().getHosts(bundle)) != null && !this.isSingleton(hosts[0])) {
            return;
        }
        InputStream is = null;
        String manifestName = isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        try {
            URL url = bundle.getEntry(manifestName);
            if (url != null) {
                is = url.openStream();
            }
        }
        catch (IOException iOException) {
            is = null;
        }
        if (is == null) {
            return;
        }
        ResourceBundle translationBundle = null;
        try {
            translationBundle = ResourceTranslator.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {}
        IContributor contributor = ContributorFactoryOSGi.createContributor(bundle);
        this.registry.addContribution(is, contributor, true, manifestName, translationBundle, this.token);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSingleton(Bundle bundle) {
        Dictionary allHeaders = bundle.getHeaders("");
        String symbolicNameHeader = (String)allHeaders.get("Bundle-SymbolicName");
        try {
            if (symbolicNameHeader == null) return true;
            ManifestElement[] symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader);
            if (symbolicNameElements.length <= 0) return true;
            String singleton = symbolicNameElements[0].getDirective("singleton");
            if (singleton == null) {
                singleton = symbolicNameElements[0].getAttribute("singleton");
            }
            if ("true".equalsIgnoreCase(singleton)) return true;
            int status = 1;
            String manifestVersion = (String)allHeaders.get("Bundle-ManifestVersion");
            if (manifestVersion == null) {
                if (OSGIUtils.getDefault().getBundle(symbolicNameElements[0].getValue()) == bundle) {
                    return true;
                }
                status = 4;
            }
            if (!this.registry.debug()) {
                if (status != 4) return false;
            }
            String message = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundle.getLocation());
            RuntimeLog.log((IStatus)new Status(status, "org.eclipse.equinox.registry", 0, message, null));
            return false;
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

