/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.DefaultVariable;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class AdaptExpression
extends CompositeExpression {
    private static final String ATT_TYPE = "type";
    private String fTypeName;

    public AdaptExpression(IConfigurationElement configElement) throws CoreException {
        this.fTypeName = configElement.getAttribute(ATT_TYPE);
        Expressions.checkAttribute(ATT_TYPE, this.fTypeName);
    }

    public AdaptExpression(String typeName) {
        Assert.isNotNull(typeName);
        this.fTypeName = typeName;
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        if (this.fTypeName == null) {
            return EvaluationResult.FALSE;
        }
        Object var = context.getDefaultVariable();
        Object adapted = null;
        if (Expressions.isInstanceOf(var, this.fTypeName)) {
            adapted = var;
        } else {
            IAdapterManager manager = Platform.getAdapterManager();
            if (!manager.hasAdapter(var, this.fTypeName)) {
                return EvaluationResult.FALSE;
            }
            adapted = manager.getAdapter(var, this.fTypeName);
        }
        if (adapted == null) {
            return EvaluationResult.NOT_LOADED;
        }
        return this.evaluateAnd(new DefaultVariable(context, adapted));
    }
}

