/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;
    boolean moveable;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        int hwnd = this.parent.handle;
        return OS.SendMessage(hwnd, 4125, index, 0);
    }

    public void pack() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        int oldWidth = OS.SendMessage(hwnd, 4125, index, 0);
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.text, true);
        int headerWidth = OS.SendMessage(hwnd, OS.LVM_GETSTRINGWIDTH, 0, buffer) + 10;
        if (this.image != null) {
            int margin = 0;
            if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
                int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
                margin = OS.SendMessage(hwndHeader, 4629, 0, 0);
            } else {
                margin = OS.GetSystemMetrics(45) * 3;
            }
            Rectangle rect = this.image.getBounds();
            headerWidth += rect.width + margin * 2;
        }
        this.parent.ignoreResize = true;
        OS.SendMessage(hwnd, 4126, index, -1);
        int columnWidth = OS.SendMessage(hwnd, 4125, index, 0);
        if (index == 0) {
            int hStateList;
            if (this.parent.imageList == null) {
                columnWidth += 2;
            }
            if ((this.parent.style & 0x20) != 0 && (hStateList = OS.SendMessage(hwnd, 4098, 2, 0)) != 0) {
                int[] cx = new int[1];
                int[] cy = new int[1];
                OS.ImageList_GetIconSize(hStateList, cx, cy);
                columnWidth += cx[0];
            }
        }
        if (headerWidth > columnWidth) {
            if (this.image == null) {
                boolean fixWidth;
                RECT rect = null;
                boolean bl = fixWidth = index == this.parent.getColumnCount() - 1;
                if (fixWidth) {
                    rect = new RECT();
                    OS.GetWindowRect(hwnd, rect);
                    OS.UpdateWindow(hwnd);
                    int flags = 30;
                    this.SetWindowPos(hwnd, 0, 0, 0, 0, rect.bottom - rect.top, flags);
                }
                OS.SendMessage(hwnd, 4126, index, -2);
                if (fixWidth) {
                    int flags = 22;
                    this.SetWindowPos(hwnd, 0, 0, 0, rect.right - rect.left, rect.bottom - rect.top, flags);
                }
            } else {
                OS.SendMessage(hwnd, 4126, index, headerWidth);
            }
        } else if (index == 0) {
            OS.SendMessage(hwnd, 4126, index, columnWidth);
        }
        this.parent.ignoreResize = false;
        int newWidth = OS.SendMessage(hwnd, 4125, index, 0);
        if (oldWidth != newWidth) {
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            boolean moved = false;
            int[] order = this.parent.getColumnOrder();
            TableColumn[] columns = this.parent.getColumns();
            int i = 0;
            while (i < order.length) {
                TableColumn column = columns[order[i]];
                if (moved && !column.isDisposed()) {
                    column.sendEvent(10);
                }
                if (column == this) {
                    moved = true;
                }
                ++i;
            }
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 17;
        OS.SendMessage(hwnd, OS.LVM_GETCOLUMN, index, lvColumn);
        lvColumn.fmt &= 0xFFFFFFFC;
        int fmt = 0;
        if ((this.style & 0x4000) == 16384) {
            fmt = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            fmt = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            fmt = 1;
        }
        lvColumn.fmt |= fmt;
        OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 17;
        OS.SendMessage(hwnd, OS.LVM_GETCOLUMN, index, lvColumn);
        if (image != null) {
            lvColumn.fmt |= 0x800;
            lvColumn.iImage = this.parent.imageIndex(image);
        } else {
            lvColumn.fmt &= 0xFFFFF7FF;
        }
        OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        int hwnd = this.parent.handle;
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 1;
        OS.SendMessage(hwnd, OS.LVM_GETCOLUMN, index, lvColumn);
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string), true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        lvColumn.mask |= 4;
        lvColumn.pszText = pszText;
        int result = OS.SendMessage(hwnd, OS.LVM_SETCOLUMN, index, lvColumn);
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (result == 0) {
            this.error(13);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwnd = this.parent.handle;
        OS.SendMessage(hwnd, 4126, index, width);
    }
}

