/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    int imageIndent;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.imageIndent = 0;
        this.grayed = false;
        this.checked = false;
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int pixel = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.display, pixel);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int pixel = this.cellBackground != null ? this.cellBackground[index] : -1;
        return pixel == -1 ? this.getBackground() : Color.win32_new(this.display, pixel);
    }

    Rectangle getBounds() {
        int itemIndex;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rect = this.getBounds(itemIndex, 0, true, false);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public Rectangle getBounds(int index) {
        int itemIndex;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rect = this.getBounds(itemIndex, index, true, true);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    RECT getBounds(int row, int column, boolean getText, boolean getImage) {
        int gridWidth;
        if (!getText && !getImage) {
            return new RECT();
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (column < 0 || column > count - 1) {
            return new RECT();
        }
        if (this.parent.fixScrollWidth) {
            this.parent.setScrollWidth(null, true);
        }
        RECT rect = new RECT();
        int hwnd = this.parent.handle;
        if (column == 0 && count == 1) {
            if (getText && getImage) {
                rect.left = 3;
            } else {
                int n = rect.left = getText ? 2 : 1;
            }
            if (OS.SendMessage(hwnd, 4110, row, rect) == 0) {
                rect.left = 0;
            }
        } else {
            rect.top = column;
            int n = rect.left = getText ? 2 : 1;
            if (OS.SendMessage(hwnd, 4152, row, rect) != 0) {
                RECT iconRect;
                if (getText && getImage) {
                    if (column == 0) {
                        iconRect = new RECT();
                        iconRect.left = 1;
                        iconRect.top = column;
                        if (OS.SendMessage(hwnd, 4152, row, iconRect) != 0) {
                            rect.left = iconRect.left;
                            rect.right = Math.max(rect.right, iconRect.right);
                        }
                    }
                } else if (column != 0) {
                    if (this.images != null && this.images[column] != null) {
                        if (getText) {
                            iconRect = new RECT();
                            iconRect.left = 1;
                            iconRect.top = column;
                            if (OS.SendMessage(hwnd, 4152, row, iconRect) != 0) {
                                rect.left = iconRect.right + 2;
                            }
                        }
                    } else if (getImage) {
                        rect.right = rect.left;
                    }
                }
            } else {
                rect.top = 0;
                rect.left = 0;
            }
        }
        int n = gridWidth = this.parent.getLinesVisible() ? 1 : 0;
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            rect.top -= gridWidth;
        }
        if (column != 0) {
            rect.left += gridWidth;
        }
        rect.right = Math.max(rect.right, rect.left);
        rect.top += gridWidth;
        rect.bottom = Math.max(rect.bottom - gridWidth, rect.top);
        return rect;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        int hFont = this.cellFont != null ? this.cellFont[index] : this.font;
        return hFont == -1 ? this.getFont() : Font.win32_new(this.display, hFont);
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int pixel = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.display, pixel);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int pixel = this.cellForeground != null ? this.cellForeground[index] : -1;
        return pixel == -1 ? this.getForeground() : Color.win32_new(this.display, pixel);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        int itemIndex;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((itemIndex = this.parent.indexOf(this)) == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rect = this.getBounds(itemIndex, index, false, true);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.imageIndent;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (index == 0) {
            return this.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    void redraw() {
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        OS.SendMessage(hwnd, 4117, index, index);
    }

    void redraw(int column, boolean drawText, boolean drawImage) {
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int hwnd = this.parent.handle;
        if (!OS.IsWindowVisible(hwnd)) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        RECT rect = this.getBounds(index, column, drawText, drawImage);
        OS.InvalidateRect(hwnd, rect, true);
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        this.redraw();
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellBackground[i] = -1;
                ++i;
            }
        }
        if (this.cellBackground[index] == pixel) {
            return;
        }
        this.cellBackground[index] = pixel;
        this.redraw(index, true, true);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.setChecked(checked, false);
    }

    void setChecked(boolean checked, boolean notify) {
        this.checked = checked;
        if (notify) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
        this.redraw();
    }

    public void setFont(Font font) {
        int itemIndex;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int hFont = -1;
        if (font != null) {
            this.parent.customDraw = true;
            hFont = font.handle;
        }
        if (this.font == hFont) {
            return;
        }
        this.font = hFont;
        if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
            int hwnd = this.parent.handle;
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 1;
            lvItem.iItem = itemIndex;
            lvItem.pszText = -1;
            OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
            this.cached = false;
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int hFont = -1;
        if (font != null) {
            this.parent.customDraw = true;
            hFont = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[count];
            int i = 0;
            while (i < count) {
                this.cellFont[i] = -1;
                ++i;
            }
        }
        if (this.cellFont[index] == hFont) {
            return;
        }
        this.cellFont[index] = hFont;
        if (index == 0) {
            int itemIndex;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
                int hwnd = this.parent.handle;
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 1;
                lvItem.iItem = itemIndex;
                lvItem.pszText = -1;
                OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, true, false);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        this.redraw();
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellForeground[i] = -1;
                ++i;
            }
        }
        if (this.cellForeground[index] == pixel) {
            return;
        }
        this.cellForeground[index] = pixel;
        this.redraw(index, true, false);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.redraw();
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null && index != 0) {
            this.images = new Image[count];
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        this.parent.imageIndex(image);
        if (index == 0) {
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, false, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        int index;
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        if (this.imageIndent == indent) {
            return;
        }
        this.imageIndent = indent;
        if ((this.parent.style & 0x10000000) == 0 && (index = this.parent.indexOf(this)) != -1) {
            int hwnd = this.parent.handle;
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 16;
            lvItem.iItem = index;
            lvItem.iIndent = indent;
            OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
        }
        this.parent.setScrollWidth(this, false);
        this.redraw();
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.strings == null && index != 0) {
            this.strings = new String[count];
        }
        if (this.strings != null) {
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (index == 0) {
            int itemIndex;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
                int hwnd = this.parent.handle;
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 1;
                lvItem.iItem = itemIndex;
                lvItem.pszText = -1;
                OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, true, false);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

