package daruma.client.darumaviewer.datamodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DaRuMaFeatureType {
	private String targetNS;

	private String typeName;

	private DaRuMaServer server;
	
	public DaRuMaFeatureType(DaRuMaServer server)
	{
		this.server = server;
	}
	
	public static DaRuMaFeatureType makeFeatureType(DaRuMaServer server, String name)
	{
		DaRuMaFeatureType featureType = new DaRuMaFeatureType(server);
		if ((name != null) && (name.length() > 0)) {
			Pattern pattern = Pattern.compile("^\\{(.+)\\}(.+)$");
			Matcher matcher = pattern.matcher(name);
			if (matcher.find()) {
				featureType.targetNS = matcher.group(1);
				featureType.typeName = matcher.group(2);
				return featureType;
			}
		}
		return null;
	}
	
	/**
	 * targetNSを取得する
	 * 
	 * @return Returns the targetNS.
	 */
	public String getTargetNS() {
		return targetNS;
	}

	/**
	 * targetNSをセットする
	 * 
	 * @param targetNS
	 *            The targetNS to set.
	 */
	public void setTargetNS(String targetNS) {
		this.targetNS = targetNS;
	}

	/**
	 * typeNameを取得する
	 * 
	 * @return Returns the typeName.
	 */
	public String getTypeName() {
		return typeName;
	}

	/**
	 * typeNameをセットする
	 * 
	 * @param typeName
	 *            The typeName to set.
	 */
	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public String getName() {
		return "{" + targetNS + "}" + typeName; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void copyTo(DaRuMaFeatureType dst)
	{
		dst.targetNS = this.targetNS;
		dst.typeName = this.typeName;
		dst.server = this.server;	}

	/**
	 * serverを取得する
	 * @return Returns the server.
	 */
	public DaRuMaServer getServer() {
		return server;
	}
}
