package daruma.client.darumaviewer.dialogs;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import daruma.client.darumaviewer.Const;
import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaServer;
import daruma.client.darumaviewer.views.SwtUtil;

public class AddServerDialog extends GenericDialog {
	private DaRuMaServer newServer;

	private Text txtHost;

	private Text txtPort;

	public AddServerDialog(Shell parentShell) {
		super(parentShell, Messages.getString("AddServerDialog.0"), 500, 200); //$NON-NLS-1$
	}

	public void createPropertyDialogArea(Composite composite) {
		int colNum = 2;

		composite.setLayout(SwtUtil.makeGridLayout(colNum));

		Label lbl = new Label(composite, SWT.NULL);
		lbl.setText(Messages.getString("AddServerDialog.1")); //$NON-NLS-1$
		txtHost = new Text(composite, SWT.BORDER);
		txtHost.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));

		lbl = new Label(composite, SWT.NULL);
		lbl.setText(Messages.getString("AddServerDialog.2")); //$NON-NLS-1$
		txtPort = new Text(composite, SWT.BORDER);
		txtPort.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, 1));
		txtPort.setTextLimit(5);
		txtPort.setText("" + Const.DFT_PORT); //$NON-NLS-1$
		if (!Const.USE_PORT) {
			lbl.setVisible(false);
			txtPort.setVisible(false);
		}
		newServer = null;
	}

	public void dialogClose(boolean flgCancel) {
		if (!flgCancel) {
			String host = txtHost.getText();
			int port =  Const.DFT_PORT;

			try {
				int temp = Integer.parseInt(txtPort.getText());
				port = temp;
			} catch (Exception e) {

			}
			newServer = new DaRuMaServer(host, port);
		}
	}

	/**
	 * newServerを取得する
	 * 
	 * @return Returns the newServer.
	 */
	public DaRuMaServer getNewServer() {
		return newServer;
	}

	public void widgetSelected(SelectionEvent e) {
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

}
