package daruma.client.darumaviewer.prefs;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;

import daruma.client.darumaviewer.Const;
import daruma.client.darumaviewer.DaRuMaViewerPlugin;

public class DaRuMaViewerPreference {
	public static final String P_SERVERS = "Servers"; //$NON-NLS-1$

	public static final String P_DEBUG = "Debug"; //$NON-NLS-1$

	public static final String P_CLIENT_TOOL_DIR = "ClientToolDir"; //$NON-NLS-1$

	public static final String P_WORK_DIR = "WorkDir"; //$NON-NLS-1$
	
	public static final String P_DISPLAY_TARGET_NS = "DisplayTargetNS";
	
	private String servers;

	private boolean debug = false;;
	
	private String clientToolDir = Const.DFT_CLIENT_TOOL_DIR;
	
	private String workDir = Const.DFT_WORK_DIR;
	
	private boolean displayTargetNS = false;

	public Object clone() {
		try {
			return (super.clone());
		} catch (CloneNotSupportedException e) {
			throw (new InternalError(e.getMessage()));
		}
	}

	public void load() {
		Preferences pref = DaRuMaViewerPlugin.getPreferences();
		servers = pref.getString(P_SERVERS);
		clientToolDir = pref.getString(P_CLIENT_TOOL_DIR);
		workDir = pref.getString(P_WORK_DIR);
		debug = pref.getBoolean(P_DEBUG);
		displayTargetNS = pref.getBoolean(P_DISPLAY_TARGET_NS);
	}

	public void save() {
		Preferences pref = DaRuMaViewerPlugin.getPreferences();
		pref.setValue(P_SERVERS, servers);
		pref.setValue(P_CLIENT_TOOL_DIR, clientToolDir);
		pref.setValue(P_WORK_DIR, workDir);
		pref.setValue(P_DEBUG, debug);
		pref.setValue(P_DISPLAY_TARGET_NS, displayTargetNS);
	}

	
	/**
	 * serversを取得する
	 * @return Returns the servers.
	 */
	public String getServers() {
		return servers;
	}

	/**
	 * serversをセットする
	 * @param servers The servers to set.
	 */
	public void setServers(String servers) {
		this.servers = servers;
	}

	/**
	 * clientToolPathを取得する
	 * @return Returns the clientToolPath.
	 */
	public String getClientToolDir() {
		return clientToolDir;
	}

	/**
	 * clientToolPathをセットする
	 * @param clientToolPath The clientToolPath to set.
	 */
	public void setClientToolDir(String clientToolPath) {
		this.clientToolDir = clientToolPath.replaceAll("\\\\", "/");
	}

	/**
	 * workDirを取得する
	 * @return Returns the workDir.
	 */
	public String getWorkDir() {
		return workDir;
	}

	/**
	 * workDirをセットする
	 * @param workDir The workDir to set.
	 */
	public void setWorkDir(String workDir) {
		this.workDir = workDir.replaceAll("\\\\", "/");;
	}

	/**
	 * debugを取得する
	 * @return Returns the debug.
	 */
	public boolean isDebug() {
		return debug;
	}

	/**
	 * debugをセットする
	 * @param debug The debug to set.
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}
	
	/**
	 * displayTargetNSを取得する
	 * @return Returns the displayTargetNS.
	 */
	public boolean isDisplayTargetNS() {
		return displayTargetNS;
	}

	/**
	 * displayTargetNSをセットする
	 * @param displayTargetNS The displayTargetNS to set.
	 */
	public void setDisplayTargetNS(boolean displayTargetNS) {
		this.displayTargetNS = displayTargetNS;
	}

	/**
	 * Sets the default values of the preferences.
	 */
	public static void initializeDefaults(IPreferenceStore store) {
		store.setDefault(P_SERVERS,  Const.DFT_SERVERS); //$NON-NLS-1$
		store.setDefault(P_DEBUG, false);
		store.setDefault(P_CLIENT_TOOL_DIR, Const.DFT_CLIENT_TOOL_DIR);
		store.setDefault(P_WORK_DIR, Const.DFT_WORK_DIR);
		store.setDefault(P_DISPLAY_TARGET_NS, Const.DFT_DISPLAY_TARGET_NS);
	}	
}
