package daruma.client.darumaviewer.views;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.*;

import daruma.client.darumaviewer.Messages;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureType;
import daruma.client.darumaviewer.datamodel.DaRuMaFeatureTypeInfo;

public class FeatureTypeView extends ViewPart {

	/**
	 * ビューID
	 */
	public static final String ID = FeatureTypeView.class.getName();

	private Button btnSchemaUpdate;

	private Button btnCountUpdate;

	private Label lblSts;

	private Text txtServer;

	private Text txtTargetNS;

	private Text txtTypeName;

	private Text txtCount;

	private Text txtSchema;

	private DaRuMaFeatureType currType = null;

	private DaRuMaFeatureTypeInfo currInfo = null;
	
	public FeatureTypeViewSelectionListener listener;

	/**
	 * ビューの画面を作成する
	 * 
	 * @param parent
	 *            親Composite
	 */
	public void createPartControl(Composite parent) {
		int colNum = 3;

		listener = new FeatureTypeViewSelectionListener();
		
		parent.setLayout(SwtUtil.makeGridLayout(colNum));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("FeatureTypeView.4")); //$NON-NLS-1$
		txtServer = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		txtServer.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum - 1));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("FeatureTypeView.0")); //$NON-NLS-1$
		txtTargetNS = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		txtTargetNS.setLayoutData(SwtUtil
				.makeHorVarGridData(100, 0, colNum - 1));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("FeatureTypeView.1")); //$NON-NLS-1$
		txtTypeName = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		txtTypeName.setLayoutData(SwtUtil
				.makeHorVarGridData(100, 0, colNum - 1));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("FeatureTypeView.2")); //$NON-NLS-1$
		txtCount = new Text(parent, SWT.BORDER | SWT.READ_ONLY);
		txtCount.setLayoutData(SwtUtil.makeFixedGridData(100, 0, 1));
		btnCountUpdate = new Button(parent, SWT.NULL);
		btnCountUpdate.setText(Messages.getString("FeatureTypeView.11")); //$NON-NLS-1$
		btnCountUpdate.addSelectionListener(listener);
		btnCountUpdate.setLayoutData(SwtUtil.makeFixedGridData(100, 0, colNum - 2));

		new Label(parent, SWT.NULL).setText(Messages
				.getString("FeatureTypeView.3")); //$NON-NLS-1$
		new Label(parent, SWT.NULL).setText(""); //$NON-NLS-1$
		btnSchemaUpdate = new Button(parent, SWT.NULL);
		btnSchemaUpdate.setText(Messages.getString("FeatureTypeView.7")); //$NON-NLS-1$
		btnSchemaUpdate.addSelectionListener(listener);
		btnSchemaUpdate.setLayoutData(SwtUtil.makeFixedGridData(100, 0, colNum - 2));

		txtSchema = new Text(parent, SWT.BORDER | SWT.READ_ONLY | SWT.MULTI
				| SWT.V_SCROLL | SWT.H_SCROLL);
		txtSchema.setLayoutData(SwtUtil.makeVarGridData(100, 100, colNum));

		lblSts = new Label(parent, SWT.NULL);
		lblSts.setLayoutData(SwtUtil.makeHorVarGridData(100, 0, colNum));
	}

	public void setFeatureType(DaRuMaFeatureType type) {
		currType = type;
		currInfo = new DaRuMaFeatureTypeInfo(currType);
		update(true, true);
	}

	private boolean update(boolean blSchema, boolean blCount) {
		boolean rc = false;
		btnSchemaUpdate.setEnabled(false);
		btnCountUpdate.setEnabled(false);
		lblSts.setText(Messages.getString("FeatureTypeView.8")); //$NON-NLS-1$
		try {
			if(blSchema) currInfo.setSchema(""); //$NON-NLS-1$
			if(blCount) currInfo.setCount(-1);
			display();
			if(!DaRuMaViewerView.dftService.getFeatureTypeInfo(
					DaRuMaViewerView.dftPref, currInfo, blSchema, blCount)){
				SwtUtil
						.showError(Messages.getString("FeatureTypeView.5") + currType.getName() + Messages.getString("FeatureTypeView.6")); //$NON-NLS-1$ //$NON-NLS-2$
			} else {
				display();
				rc = true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		lblSts
				.setText(rc ? Messages.getString("FeatureTypeView.9") : Messages.getString("FeatureTypeView.10")); //$NON-NLS-1$ //$NON-NLS-2$
		btnSchemaUpdate.setEnabled(true);
		btnCountUpdate.setEnabled(true);
		return rc;
	}

	private void display() {
		this.setPartName(currType.getTypeName()
				+ "@" + currType.getServer().getHost()); //$NON-NLS-1$
		txtServer.setText(currType.getServer().getName());
		txtTargetNS.setText(currType.getTargetNS());
		txtTypeName.setText(currType.getTypeName());
		txtCount.setText((currInfo.getCount() < 0) ? "" : ("" + currInfo.getCount())); //$NON-NLS-1$ //$NON-NLS-2$
		txtSchema.setText(currInfo.getSchema()); //$NON-NLS-1$
	}

	/**
	 * フォーカスを設定する
	 */
	public void setFocus() {
	}

	class FeatureTypeViewSelectionListener implements SelectionListener {
		public void widgetSelected(SelectionEvent e) {
			if(e.widget == btnSchemaUpdate)
			{
				update(true, false);
			}
			else if(e.widget == btnCountUpdate)
			{
				update(false, true);
			}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
	}
}