﻿using System;
using System.Collections.Generic;
using System.Text;
using Con = System.Console;
using DataUnit.Core;
using System.Reflection;
using System.IO;
using log4net;

namespace DataUnit.Console
{
    class Program
    {
        private static readonly ILog _logger
           = LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);


        static void Main(string[] args)
        {
            _logger.Info("───────────────");
            _logger.Info("コンソールアプリケーション起動");
            WriteVersion();
            if (args.Length >= 2 ){
                Con.WriteLine("引数は１つ（設定ファイルのパス）のみ指定してください。");
                _logger.Error("引数は１つ（設定ファイルのパス）のみ指定してください。");
                WriteParamError();
                return;
            }

            string configPath;
            if (args.Length == 0){
                Assembly ab = Assembly.GetEntryAssembly();
                configPath = Path.GetDirectoryName(ab.Location) + @"\config.xml" ;
            }else{
                configPath = GetConfigPath(args[0]);
            }

            
            if (!File.Exists(configPath))
            {
                Con.WriteLine("設定ファイルが見つかりません。\n　{0}\n",configPath);
                _logger.Error(String.Format("設定ファイルが見つかりません。{0}", configPath));
                WriteParamError();
                return;
            }

            Host host = new Host(configPath);
            try
            {
                host.ReadConfig();
                
                Con.WriteLine("「{0}」フォルダのSQLを実行します。", host.Config.SqlPath);
                _logger.Info(String.Format("「{0}」フォルダのSQLを実行します。", host.Config.SqlPath));
                host.Status += new Host.StatusEventHandler(host_Status);
                host.CheckData();
            }
            catch (Exception ex)
            {
                WriteException(ex);
            }
            _logger.Info("コンソールアプリケーション終了");
        }

        private static string GetConfigPath(string arg )
        {
            string result = "";
            if (Path.IsPathRooted(arg))
            {
                result = arg;
            }
            else
            {
                result = Path.GetFullPath(arg);
            }
            return result;
        }

        private static void WriteException(Exception ex)
        {
            Con.WriteLine("エラーが発生しました。");
            Con.WriteLine(ex.Message);
            Con.WriteLine(ex.ToString());
            Con.WriteLine("");
            _logger.Error("エラーが発生しました。", ex);
        }

        private static void WriteParamError()
        {

            Con.WriteLine("　例：DataUnit.Console.exe config.xml");
            Con.WriteLine(@"　例：DataUnit.Console.exe C:\DataUnit\config.xml");
            Con.WriteLine("");

            _logger.Info("コンソールアプリケーション終了");
            
        }

        private static void WriteVersion()
        {
            Assembly mainAssembly = Assembly.GetEntryAssembly();
            AssemblyName mainAssemName = mainAssembly.GetName();
            Version ver = mainAssemName.Version;
            Con.WriteLine("*** DataUnit Ver {0}.{1}.{2} ***", ver.Major, ver.Minor, ver.Build);
            Con.WriteLine("");
        }

        static void host_Status(object sender, StatusEventArgs e)
        {
            Con.WriteLine(e.Message);
            if (e.Kind == StatusKind.Start){
                Con.WriteLine("全{0}件のSQLを実行します。",e.AllCount.ToString());
                _logger.Info(String.Format("全{0}件のSQLを実行します。", e.AllCount.ToString()));
            }
        }
    }
}

