// This file was generated by WTL Dialog wizard 
// SettingDialog_2D.cpp : Implementation of CSettingDialog_2D

#include "stdafx.h"
#include "SettingDialog_2D.h"

#include "DataViewerCommon.h"
#include "ColorFormat.h"

#include "TwoWayMap.h"
#include "converter.h"
#include "arrayutil.h"

#include "Setting.h"

struct TargetStructureTypeMapper : public TwoWayMap<CString, DataSetting2D::TargetStructureType>
{
	TargetStructureTypeMapper()
	{
		map(CString("Manual"),				DataSetting2D::TargetStructureType_Manual);
		map(CString("BITMAPINFOHEADER"),	DataSetting2D::TargetStructureType_BITMAPINFOHEADER);
	}
};

TargetStructureTypeMapper targetStructureTypeMapper;

struct ColorFormatTypeMapper : public TwoWayMap<CString, DataSetting2D::ColorFormatType>
{
	ColorFormatTypeMapper()
	{
		map(CString("B5G6R5"),		DataSetting2D::ColorFormatType_B5G6R5);
		map(CString("B8G8R8"),		DataSetting2D::ColorFormatType_B8G8R8);
		map(CString("B8G8R8A8"),	DataSetting2D::ColorFormatType_B8G8R8A8);
//		map(CString("16F"),			DataSetting2D::ColorFormatType_16F);
		map(CString("32F"),			DataSetting2D::ColorFormatType_32F);
		map(CString("64F"),			DataSetting2D::ColorFormatType_64F);
		map(CString("1"),			DataSetting2D::ColorFormatType_1);
		map(CString("8"),			DataSetting2D::ColorFormatType_8);
		map(CString("16"),			DataSetting2D::ColorFormatType_16);
		map(CString("32"),			DataSetting2D::ColorFormatType_32);
	}
};

ColorFormatTypeMapper colorFormatTypeMapper;

CSettingDialog_2D::CSettingDialog_2D()
{
}

CSettingDialog_2D::~CSettingDialog_2D()
{
}

BOOL CSettingDialog_2D::PreTranslateMessage(MSG* pMsg)
{
	return IsDialogMessage(pMsg);
}

LRESULT CSettingDialog_2D::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	DoDataExchange();
	
	m_wndCmbTargetStructureType.AddString(targetStructureTypeMapper[DataSetting2D::TargetStructureType_Manual]);
	m_wndCmbTargetStructureType.AddString(targetStructureTypeMapper[DataSetting2D::TargetStructureType_BITMAPINFOHEADER]);
	m_wndCmbTargetStructureType.SetCurSel(0);

	for (int i=DataSetting2D::ColorFormatType_Begin; i<=DataSetting2D::ColorFormatType_End; ++i) {
		m_wndCmbColorFormat.AddString(colorFormatTypeMapper[(DataSetting2D::ColorFormatType)i]);
	}
	
	m_wndRadAddressedLineFirst.Click();
	EnableControls(true);
	
	return 1;  // Let the system set the focus
}

LRESULT CSettingDialog_2D::OnClickedOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
//	DoDataExchange(TRUE);
//	EndDialog(wID);
	return 0;
}

LRESULT CSettingDialog_2D::OnClickedCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
//	EndDialog(wID);
	return 0;
}

LRESULT CSettingDialog_2D::OnCmbTargetStructureTypeCbnSelChange(WORD wNotifyCode, WORD wID, HWND hWndCtl)
{
	int selIdx = m_wndCmbTargetStructureType.GetCurSel();
	CString str;
	m_wndCmbTargetStructureType.GetLBText(selIdx, str);
	DataSetting2D::TargetStructureType targetType = targetStructureTypeMapper[str];
	switch (targetType) {
	case DataSetting2D::TargetStructureType_Manual:
		EnableControls(true);
		break;
	case DataSetting2D::TargetStructureType_BITMAPINFOHEADER:
		EnableControls(false);
		SetControlsByBITMAPINFOHEADER();
		break;
	}
	return 0;
}

LRESULT CSettingDialog_2D::OnBnClickedBtnReadTargetStructure(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	SetControlsByBITMAPINFOHEADER();
	return 0;
}

void CSettingDialog_2D::SetControlsByBITMAPINFOHEADER()
{
	if (!m_dataFetch_delegate)
		return;

	CString str;
	m_wndEdtTargetStructureAddress.GetWindowText(str);
	size_t address = AddressHexStrToNum(str);
	
	BITMAPINFOHEADER bmpih;
	if (!m_dataFetch_delegate((LPCVOID)address, (void*)&bmpih, sizeof(bmpih)))
		return;
	
	convert(bmpih.biWidth, str);		m_wndEdtWidth.SetWindowText(str);
	convert(abs(bmpih.biHeight), str);	m_wndEdtHeight.SetWindowText(str);
	size_t lineBytes = 0;
	DataSetting2D::ColorFormatType colorFormat;
	switch (bmpih.biBitCount) {
	case 24:
		lineBytes = (3*bmpih.biWidth+3)&~3;
		colorFormat = DataSetting2D::ColorFormatType_B8G8R8;
		break;
	case 32:
		lineBytes = (4*bmpih.biWidth);
		colorFormat = DataSetting2D::ColorFormatType_B8G8R8A8;
		break;
	}
	
	int lineOffset = lineBytes;;
	if (bmpih.biHeight >= 0) {
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_FIRST, BST_UNCHECKED);
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_LAST, BST_CHECKED);
		lineOffset = -lineOffset;
	}else {
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_FIRST, BST_CHECKED);
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_LAST, BST_UNCHECKED);
	}
	
	convert(lineOffset, str);
	m_wndEdtLineOffset.SetWindowText(str);
	m_wndCmbColorFormat.SelectString(-1, colorFormatTypeMapper[colorFormat]);
	
}

void CSettingDialog_2D::EnableControls(bool bEnable)
{
	BOOL enable = bEnable ? TRUE : FALSE;
	m_wndEdtTargetStructureAddress.EnableWindow(!enable);
	m_wndBtnReadTargetStructure.EnableWindow(!enable);

	m_wndEdtWidth.EnableWindow(enable);
	m_wndEdtHeight.EnableWindow(enable);
	m_wndRadAddressedLineFirst.EnableWindow(enable);
	m_wndRadAddressedLineLast.EnableWindow(enable);
	m_wndEdtLineOffset.EnableWindow(enable);
	m_wndCmbColorFormat.EnableWindow(enable);
}

void CSettingDialog_2D::RetrieveSetting(boost::shared_ptr<IDataSetting>& pSetting)
{
	DataSetting2D* ps = new DataSetting2D;
	pSetting = boost::shared_ptr<DataSetting2D>(ps);

	CString str;
	m_wndCmbTargetStructureType.GetLBText(m_wndCmbTargetStructureType.GetCurSel(), str);
	ps->targetStructureType = targetStructureTypeMapper[str];
	m_wndEdtTargetStructureAddress.GetWindowText(ps->structureAddressFormula, Count(ps->structureAddressFormula));
	m_wndEdtWidth.GetWindowText(ps->widthFormula, Count(ps->widthFormula));
	m_wndEdtHeight.GetWindowText(ps->heightFormula, Count(ps->heightFormula));
	if (IsDlgButtonChecked(IDC_RAD_ADDRESSEDLINE_FIRST) == BST_CHECKED) {
		ps->addressedLine = DataSetting2D::AddressedLine_First;
	}else if (IsDlgButtonChecked(IDC_RAD_ADDRESSEDLINE_LAST) == BST_CHECKED) {
		ps->addressedLine = DataSetting2D::AddressedLine_Last;
	}
	m_wndEdtLineOffset.GetWindowText(ps->lineOffsetFormula, Count(ps->lineOffsetFormula));
	m_wndCmbColorFormat.GetLBText(m_wndCmbColorFormat.GetCurSel(), str);
	ps->colorFormat = colorFormatTypeMapper[str];
}

void CSettingDialog_2D::SetSetting(const DataSetting2D& setting)
{
	CString str;
	m_wndCmbTargetStructureType.SelectString(-1, targetStructureTypeMapper[setting.targetStructureType]);
	switch (setting.targetStructureType) {
	case DataSetting2D::TargetStructureType_Manual:
		EnableControls(true);
		break;
	case DataSetting2D::TargetStructureType_BITMAPINFOHEADER:
		EnableControls(false);
		break;
	}
	m_wndEdtTargetStructureAddress.SetWindowText(setting.structureAddressFormula);
	m_wndEdtWidth.SetWindowTextW(setting.widthFormula);
	m_wndEdtHeight.SetWindowTextW(setting.heightFormula);
	switch (setting.addressedLine) {
	case DataSetting2D::AddressedLine_First:
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_FIRST, BST_CHECKED);
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_LAST, BST_UNCHECKED);
		break;
	case DataSetting2D::AddressedLine_Last:
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_FIRST, BST_UNCHECKED);
		CheckDlgButton(IDC_RAD_ADDRESSEDLINE_LAST, BST_CHECKED);
		break;
	}
	m_wndEdtLineOffset.SetWindowTextW(setting.lineOffsetFormula);
	m_wndCmbColorFormat.SelectString(-1, colorFormatTypeMapper[setting.colorFormat]);
}

