/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.sql.SQLException;
import java.util.Arrays;
import junit.framework.ComparisonFailure;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assertion {
    private static final Logger logger = LoggerFactory.getLogger((Class)Assertion.class);

    private Assertion() {
    }

    public static void assertEqualsIgnoreCols(IDataSet expectedDataset, IDataSet actualDataset, String tableName, String[] ignoreCols) throws DatabaseUnitException {
        logger.debug("assertEqualsIgnoreCols(expectedDataset={}, actualDataset={}, tableName={}, ignoreCols={}) - start", new Object[]{expectedDataset, actualDataset, tableName, Arrays.asList(ignoreCols)});
        Assertion.assertEqualsIgnoreCols(expectedDataset.getTable(tableName), actualDataset.getTable(tableName), ignoreCols);
    }

    public static void assertEqualsIgnoreCols(ITable expectedTable, ITable actualTable, String[] ignoreCols) throws DatabaseUnitException {
        logger.debug("assertEqualsIgnoreCols(expectedTable={}, actualTable={}, ignoreCols={}) - start", new Object[]{expectedTable, actualTable, Arrays.asList(ignoreCols)});
        ITable expectedTableFiltered = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable actualTableFiltered = DefaultColumnFilter.excludedColumnsTable(actualTable, ignoreCols);
        Assertion.assertEquals(expectedTableFiltered, actualTableFiltered);
    }

    public static void assertEqualsByQuery(IDataSet expectedDataset, IDatabaseConnection connection, String sqlQuery, String tableName, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        logger.debug("assertEqualsByQuery(expectedDataset={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedDataset, connection, tableName, sqlQuery, ignoreCols});
        ITable expectedTable = expectedDataset.getTable(tableName);
        Assertion.assertEqualsByQuery(expectedTable, connection, tableName, sqlQuery, ignoreCols);
    }

    public static void assertEqualsByQuery(ITable expectedTable, IDatabaseConnection connection, String tableName, String sqlQuery, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        logger.debug("assertEqualsByQuery(expectedTable={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedTable, connection, tableName, sqlQuery, ignoreCols});
        ITable expected = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable queriedTable = connection.createQueryTable(tableName, sqlQuery);
        ITable actual = DefaultColumnFilter.excludedColumnsTable(queriedTable, ignoreCols);
        Assertion.assertEquals(expected, actual);
    }

    public static void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        int i;
        String[] actualNames;
        logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}) - start", (Object)expectedDataSet, (Object)actualDataSet);
        if (expectedDataSet == actualDataSet) {
            return;
        }
        String[] expectedNames = Assertion.getSortedUpperTableNames(expectedDataSet);
        if (expectedNames.length != (actualNames = Assertion.getSortedUpperTableNames(actualDataSet)).length) {
            throw new ComparisonFailure("table count", String.valueOf(expectedNames.length), String.valueOf(actualNames.length));
        }
        for (i = 0; i < expectedNames.length; ++i) {
            if (actualNames[i].equals(expectedNames[i])) continue;
            throw new ComparisonFailure("tables", Arrays.asList(expectedNames).toString(), Arrays.asList(actualNames).toString());
        }
        for (i = 0; i < expectedNames.length; ++i) {
            String name = expectedNames[i];
            Assertion.assertEquals(expectedDataSet.getTable(name), actualDataSet.getTable(name));
        }
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}) - start", (Object)expectedTable, (Object)actualTable);
        Assertion.assertEquals(expectedTable, actualTable, null);
    }

    public static void assertEquals(ITable expectedTable, ITable actualTable, Column[] additionalColumnInfo) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}, rowValueProvider) - start", (Object)expectedTable, (Object)actualTable);
        if (expectedTable == actualTable) {
            logger.debug("The given tables reference the same object. Will return immediately. (Table={})", (Object)expectedTable);
            return;
        }
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        Column[] expectedColumns = Columns.getSortedColumns(expectedMetaData);
        Column[] actualColumns = Columns.getSortedColumns(actualMetaData);
        Columns.ColumnDiff columnDiff = Columns.getColumnDiff(expectedMetaData, actualMetaData);
        if (columnDiff.hasDifference()) {
            String message = columnDiff.getMessage();
            throw new ComparisonFailure(message, Columns.getColumnNamesAsString(expectedColumns), Columns.getColumnNamesAsString(actualColumns));
        }
        if (expectedTable.getRowCount() != actualTable.getRowCount()) {
            throw new ComparisonFailure("row count (table=" + expectedTableName + ")", String.valueOf(expectedTable.getRowCount()), String.valueOf(actualTable.getRowCount()));
        }
        for (int i = 0; i < expectedTable.getRowCount(); ++i) {
            for (int j = 0; j < expectedColumns.length; ++j) {
                Column expectedColumn = expectedColumns[j];
                Column actualColumn = actualColumns[j];
                String columnName = expectedColumn.getColumnName();
                Object expectedValue = expectedTable.getValue(i, columnName);
                Object actualValue = actualTable.getValue(i, columnName);
                DataType dataType = Assertion.getComparisonDataType(expectedTableName, expectedColumn, actualColumn);
                if (dataType.compare(expectedValue, actualValue) == 0) continue;
                String additionalInfo = Assertion.buildAdditionalColumnInfo(expectedTable, actualTable, i, additionalColumnInfo);
                String msg = "value (table=" + expectedTableName + ", row=" + i + ", col=" + columnName;
                if (additionalInfo != null && !additionalInfo.trim().equals("")) {
                    msg = msg + "," + additionalInfo;
                }
                msg = msg + ")";
                throw new ComparisonFailure(msg, String.valueOf(expectedValue), String.valueOf(actualValue));
            }
        }
    }

    private static String buildAdditionalColumnInfo(ITable expectedTable, ITable actualTable, int rowIndex, Column[] additionalColumnInfo) {
        String additionalInfo = "";
        if (additionalColumnInfo != null && additionalColumnInfo.length > 0) {
            additionalInfo = " Additional row info:";
            for (int j = 0; j < additionalColumnInfo.length; ++j) {
                String columnName = additionalColumnInfo[j].getColumnName();
                try {
                    Object expectedKeyValue = expectedTable.getValue(rowIndex, columnName);
                    Object actualKeyValue = actualTable.getValue(rowIndex, columnName);
                    additionalInfo = additionalInfo + " (col '" + columnName + "' values: expected=<" + expectedKeyValue + ">, actual=<" + actualKeyValue + ">)";
                    continue;
                }
                catch (DataSetException e) {
                    logger.debug("Exception while building additional info for column " + columnName, (Throwable)e);
                }
            }
        }
        return additionalInfo;
    }

    static DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn) {
        if (logger.isDebugEnabled()) {
            logger.debug("getComparisonDataType(tableName={}, expectedColumn={}, actualColumn={}) - start", new Object[]{tableName, expectedColumn, actualColumn});
        }
        DataType expectedDataType = expectedColumn.getDataType();
        DataType actualDataType = actualColumn.getDataType();
        if (!expectedDataType.getClass().isInstance(actualDataType)) {
            if (expectedDataType instanceof UnknownDataType) {
                return actualDataType;
            }
            if (actualDataType instanceof UnknownDataType) {
                return expectedDataType;
            }
            throw new ComparisonFailure("Incompatible data types: (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")", String.valueOf(expectedDataType), String.valueOf(actualDataType));
        }
        return expectedDataType;
    }

    private static String[] getSortedUpperTableNames(IDataSet dataSet) throws DataSetException {
        logger.debug("getSortedUpperTableNames(dataSet={}) - start", (Object)dataSet);
        Object[] names = dataSet.getTableNames();
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((String)names[i]).toUpperCase();
        }
        Arrays.sort(names);
        return names;
    }
}

