/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FilterSet;
import org.dbunit.ant.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySet {
    private static final Logger logger = LoggerFactory.getLogger((Class)QuerySet.class);
    private String id;
    private String refid;
    private List queries = new ArrayList();
    private List filterSets = new ArrayList();
    private static String ERR_MSG = "Cannot specify 'id' and 'refid' attributes together in queryset.";

    public void addQuery(Query query) {
        logger.debug("addQuery(query={}) - start", (Object)query);
        this.queries.add(query);
    }

    public void addFilterSet(FilterSet filterSet) {
        logger.debug("addFilterSet(filterSet={}) - start", (Object)filterSet);
        this.filterSets.add(filterSet);
    }

    public String getId() {
        return this.id;
    }

    public String getRefid() {
        return this.refid;
    }

    public void setId(String string) {
        logger.debug("setId(string={}) - start", (Object)string);
        if (this.refid != null) {
            throw new BuildException(ERR_MSG);
        }
        this.id = string;
    }

    public void setRefid(String string) {
        logger.debug("setRefid(string={}) - start", (Object)string);
        if (this.id != null) {
            throw new BuildException(ERR_MSG);
        }
        this.refid = string;
    }

    protected List getQueries() {
        logger.debug("getQueries() - start");
        Iterator i = this.queries.iterator();
        while (i.hasNext()) {
            Query query = (Query)i.next();
            this.replaceTokens(query);
        }
        return this.queries;
    }

    private void replaceTokens(Query query) {
        logger.debug("replaceTokens(query={}) - start", (Object)query);
        Iterator i = this.filterSets.iterator();
        while (i.hasNext()) {
            FilterSet filterSet = (FilterSet)i.next();
            query.setSql(filterSet.replaceTokens(query.getSql()));
        }
    }

    public void copyQueriesFrom(QuerySet referenced) {
        logger.debug("copyQueriesFrom(referenced={}) - start", (Object)referenced);
        Iterator i = referenced.queries.iterator();
        while (i.hasNext()) {
            this.addQuery((Query)i.next());
        }
    }
}

