/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.statement.PreparedStatementFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfig {
    private static final Logger logger = LoggerFactory.getLogger((Class)DatabaseConfig.class);
    public static final String PROPERTY_STATEMENT_FACTORY = "http://www.dbunit.org/properties/statementFactory";
    public static final String PROPERTY_RESULTSET_TABLE_FACTORY = "http://www.dbunit.org/properties/resultSetTableFactory";
    public static final String PROPERTY_DATATYPE_FACTORY = "http://www.dbunit.org/properties/datatypeFactory";
    public static final String PROPERTY_ESCAPE_PATTERN = "http://www.dbunit.org/properties/escapePattern";
    public static final String PROPERTY_TABLE_TYPE = "http://www.dbunit.org/properties/tableType";
    public static final String PROPERTY_PRIMARY_KEY_FILTER = "http://www.dbunit.org/properties/primaryKeyFilter";
    public static final String PROPERTY_BATCH_SIZE = "http://www.dbunit.org/properties/batchSize";
    public static final String PROPERTY_FETCH_SIZE = "http://www.dbunit.org/properties/fetchSize";
    public static final String FEATURE_QUALIFIED_TABLE_NAMES = "http://www.dbunit.org/features/qualifiedTableNames";
    public static final String FEATURE_BATCHED_STATEMENTS = "http://www.dbunit.org/features/batchedStatements";
    public static final String FEATURE_DATATYPE_WARNING = "http://www.dbunit.org/features/datatypeWarning";
    public static final String FEATURE_SKIP_ORACLE_RECYCLEBIN_TABLES = "http://www.dbunit.org/features/skipOracleRecycleBinTables";
    private static final DefaultDataTypeFactory DEFAULT_DATA_TYPE_FACTORY = new DefaultDataTypeFactory();
    private static final PreparedStatementFactory PREPARED_STATEMENT_FACTORY = new PreparedStatementFactory();
    private static final CachedResultSetTableFactory RESULT_SET_TABLE_FACTORY = new CachedResultSetTableFactory();
    private static final String DEFAULT_ESCAPE_PATTERN = null;
    private static final String[] DEFAULT_TABLE_TYPE = new String[]{"TABLE"};
    private static final Integer DEFAULT_BATCH_SIZE = new Integer(100);
    private static final Integer DEFAULT_FETCH_SIZE = new Integer(100);
    private Set _featuresSet = new HashSet();
    private Map _propertyMap = new HashMap();

    public DatabaseConfig() {
        this.setFeature(FEATURE_BATCHED_STATEMENTS, false);
        this.setFeature(FEATURE_QUALIFIED_TABLE_NAMES, false);
        this.setFeature(FEATURE_DATATYPE_WARNING, true);
        this.setProperty(PROPERTY_STATEMENT_FACTORY, PREPARED_STATEMENT_FACTORY);
        this.setProperty(PROPERTY_RESULTSET_TABLE_FACTORY, RESULT_SET_TABLE_FACTORY);
        this.setProperty(PROPERTY_DATATYPE_FACTORY, DEFAULT_DATA_TYPE_FACTORY);
        this.setProperty(PROPERTY_ESCAPE_PATTERN, DEFAULT_ESCAPE_PATTERN);
        this.setProperty(PROPERTY_TABLE_TYPE, DEFAULT_TABLE_TYPE);
        this.setProperty(PROPERTY_BATCH_SIZE, DEFAULT_BATCH_SIZE);
        this.setProperty(PROPERTY_FETCH_SIZE, DEFAULT_FETCH_SIZE);
    }

    public void setFeature(String name, boolean value) {
        logger.debug("setFeature(name={}, value={}) - start", (Object)name, (Object)new Boolean(value));
        if (value) {
            this._featuresSet.add(name);
        } else {
            this._featuresSet.remove(name);
        }
    }

    public boolean getFeature(String name) {
        logger.debug("getFeature(name={}) - start", (Object)name);
        return this._featuresSet.contains(name);
    }

    public void setProperty(String name, Object value) {
        logger.debug("setProperty(name={}, value={}) - start", (Object)name, value);
        this._propertyMap.put(name, value);
    }

    public Object getProperty(String name) {
        return this._propertyMap.get(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_featuresSet=").append(this._featuresSet);
        sb.append(", _propertyMap=").append(this._propertyMap);
        sb.append("]");
        return sb.toString();
    }
}

