/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryTableIterator;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)QueryDataSet.class);
    private final IDatabaseConnection _connection;
    private final List _tableEntries = new ArrayList();

    public QueryDataSet(IDatabaseConnection connection) {
        if (connection == null) {
            throw new NullPointerException("The parameter 'connection' must not be null");
        }
        this._connection = connection;
    }

    public void addTable(String tableName, String query) {
        logger.debug("addTable(tableName={}, query={}) - start", (Object)tableName, (Object)query);
        this._tableEntries.add(new TableEntry(tableName, query));
    }

    public void addTable(String tableName) {
        logger.debug("addTable(tableName={}) - start", (Object)tableName);
        this._tableEntries.add(new TableEntry(tableName, null));
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        ArrayList tableEntries = new ArrayList(this._tableEntries);
        if (reversed) {
            Collections.reverse(tableEntries);
        }
        return new QueryTableIterator(tableEntries, this._connection);
    }

    public String[] getTableNames() throws DataSetException {
        logger.debug("getTableNames() - start");
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this._tableEntries.iterator();
        while (it.hasNext()) {
            TableEntry entry = (TableEntry)it.next();
            names.add(entry.getTableName());
        }
        return names.toArray(new String[0]);
    }

    static class TableEntry {
        private final String _tableName;
        private final String _query;

        public TableEntry(String tableName, String query) {
            this._tableName = tableName;
            this._query = query;
        }

        public String getTableName() {
            return this._tableName;
        }

        public String getQuery() {
            return this._query;
        }
    }
}

