/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database.search;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallback;
import org.dbunit.database.search.ImportedAndExportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.database.search.ImportedKeysSearchCallback;
import org.dbunit.database.search.ImportedKeysSearchCallbackFilteredByPKs;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.util.CollectionsHelper;
import org.dbunit.util.search.DepthFirstSearch;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesDependencyHelper {
    private static final Logger logger = LoggerFactory.getLogger((Class)TablesDependencyHelper.class);

    private TablesDependencyHelper() {
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getDependentTables(connection={}, rootTable={}) - start", (Object)connection, (Object)rootTable);
        return TablesDependencyHelper.getDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getDependentTables(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedKeysSearchCallback callback = new ImportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        Set tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings(tables);
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String rootTable) throws SearchException {
        logger.debug("getAllDependentTables(connection={}, rootTable={}) - start", (Object)connection, (Object)rootTable);
        return TablesDependencyHelper.getAllDependentTables(connection, new String[]{rootTable});
    }

    public static String[] getAllDependentTables(IDatabaseConnection connection, String[] rootTables) throws SearchException {
        logger.debug("getAllDependentTables(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedAndExportedKeysSearchCallback callback = new ImportedAndExportedKeysSearchCallback(connection);
        DepthFirstSearch search = new DepthFirstSearch();
        Set tables = search.search(rootTables, (ISearchCallback)callback);
        return CollectionsHelper.setToStrings(tables);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, String rootTable, Set allowedIds) throws SearchException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("getDataset(connection={}, rootTable={}, allowedIds={}) - start", new Object[]{connection, rootTable, allowedIds});
        }
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        map.put(rootTable, allowedIds);
        return TablesDependencyHelper.getDataset(connection, map);
    }

    public static IDataSet getDataset(IDatabaseConnection connection, Map rootTables) throws SearchException, SQLException {
        logger.debug("getDataset(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        ImportedKeysSearchCallbackFilteredByPKs callback = new ImportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = CollectionsHelper.setToStrings(rootTables.keySet());
        Set tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings(tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, String rootTable, Set allowedPKs) throws SearchException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllDataset(connection={}, rootTable={}, allowedPKs={}) - start", new Object[]{connection, rootTable, allowedPKs});
        }
        HashMap<String, Set> map = new HashMap<String, Set>(1);
        map.put(rootTable, allowedPKs);
        return TablesDependencyHelper.getAllDataset(connection, map);
    }

    public static IDataSet getAllDataset(IDatabaseConnection connection, Map rootTables) throws SearchException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllDataset(connection={}, rootTables={}) - start", (Object)connection, (Object)rootTables);
        }
        ImportedAndExportedKeysSearchCallbackFilteredByPKs callback = new ImportedAndExportedKeysSearchCallbackFilteredByPKs(connection, rootTables);
        ITableFilter filter = callback.getFilter();
        DepthFirstSearch search = new DepthFirstSearch();
        Object[] tableNames = CollectionsHelper.setToStrings(rootTables.keySet());
        Set tmpTables = search.search(tableNames, (ISearchCallback)callback);
        String[] dependentTables = CollectionsHelper.setToStrings(tmpTables);
        IDataSet tmpDataset = connection.createDataSet(dependentTables);
        FilteredDataSet dataset = new FilteredDataSet(filter, tmpDataset);
        return dataset;
    }
}

