/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CachedTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataSet
extends AbstractDataSet
implements IDataSetConsumer {
    private static final Logger logger = LoggerFactory.getLogger((Class)CachedDataSet.class);
    private ITable[] _tables;
    private List _tableList;
    private DefaultTable _activeTable;

    public CachedDataSet() {
    }

    public CachedDataSet(IDataSet dataSet) throws DataSetException {
        ArrayList<CachedTable> tableList = new ArrayList<CachedTable>();
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            tableList.add(new CachedTable(iterator.getTable()));
        }
        this._tables = tableList.toArray(new ITable[0]);
    }

    public CachedDataSet(IDataSetProducer producer) throws DataSetException {
        producer.setConsumer(this);
        producer.produce();
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        return new DefaultTableIterator(this._tables, reversed);
    }

    public void startDataSet() throws DataSetException {
        logger.debug("startDataSet() - start");
        this._tableList = new ArrayList();
        this._tables = null;
    }

    public void endDataSet() throws DataSetException {
        logger.debug("endDataSet() - start");
        this._tables = this._tableList.toArray(new ITable[0]);
        this._tableList = null;
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        logger.debug("startTable(metaData={}) - start", (Object)metaData);
        this._activeTable = new DefaultTable(metaData);
    }

    public void endTable() throws DataSetException {
        logger.debug("endTable() - start");
        this._tableList.add(this._activeTable);
        this._activeTable = null;
    }

    public void row(Object[] values) throws DataSetException {
        logger.debug("row(values={}) - start", values);
        this._activeTable.addRow(values);
    }
}

