/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CaseInsensitiveTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInsensitiveDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)CaseInsensitiveDataSet.class);
    private final IDataSet _dataSet;

    public CaseInsensitiveDataSet(IDataSet dataSet) {
        this._dataSet = dataSet;
    }

    private String getInternalTableName(String tableName) throws DataSetException {
        logger.debug("getInternalTableName(tableName={}) - start", (Object)tableName);
        String found = null;
        String[] names = this._dataSet.getTableNames();
        for (int i = 0; i < names.length; ++i) {
            if (!tableName.equalsIgnoreCase(names[i])) continue;
            if (found != null) {
                throw new AmbiguousTableNameException(tableName);
            }
            found = names[i];
        }
        if (found != null) {
            return found;
        }
        throw new NoSuchTableException(tableName);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        return new CaseInsensitiveIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        return this._dataSet.getTableNames();
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        logger.debug("getTableMetaData(tableName={}) - start", (Object)tableName);
        return this._dataSet.getTableMetaData(this.getInternalTableName(tableName));
    }

    public ITable getTable(String tableName) throws DataSetException {
        logger.debug("getTable(tableName={}) - start", (Object)tableName);
        ITable table = this._dataSet.getTable(this.getInternalTableName(tableName));
        return new CaseInsensitiveTable(table);
    }

    private class CaseInsensitiveIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public CaseInsensitiveIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return new CaseInsensitiveTable(this._iterator.getTable());
        }
    }
}

