/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)CompositeDataSet.class);
    private ITable[] _tables;

    public CompositeDataSet(IDataSet[] dataSets) throws DataSetException {
        this(dataSets, true);
    }

    public CompositeDataSet(IDataSet[] dataSets, boolean combine) throws DataSetException {
        ArrayList tableList = new ArrayList();
        for (int i = 0; i < dataSets.length; ++i) {
            IDataSet dataSet = dataSets[i];
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                this.addTable(iterator.getTable(), tableList, combine);
            }
        }
        this._tables = tableList.toArray(new ITable[0]);
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2});
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2}, combine);
    }

    public CompositeDataSet(IDataSet dataSet, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet}, combine);
    }

    public CompositeDataSet(IDataSet dataSet) throws DataSetException {
        this(new IDataSet[]{dataSet}, true);
    }

    public CompositeDataSet(ITable[] tables) throws DataSetException {
        ArrayList tableList = new ArrayList();
        for (int i = 0; i < tables.length; ++i) {
            this.addTable(tables[i], tableList, true);
        }
        this._tables = tableList.toArray(new ITable[0]);
    }

    private void addTable(ITable newTable, List tableList, boolean combine) {
        if (logger.isDebugEnabled()) {
            logger.debug("addTable(newTable={}, tableList={}, combine={}) - start", new Object[]{newTable, tableList, String.valueOf(combine)});
        }
        if (!combine) {
            tableList.add(newTable);
            return;
        }
        String tableName = newTable.getTableMetaData().getTableName();
        ListIterator<CompositeTable> it = tableList.listIterator();
        while (it.hasNext()) {
            ITable table = (ITable)it.next();
            if (!tableName.equalsIgnoreCase(table.getTableMetaData().getTableName())) continue;
            it.set(new CompositeTable(table, newTable));
            return;
        }
        tableList.add(newTable);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        return new DefaultTableIterator(this._tables, reversed);
    }
}

